# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 admin_credentials: pulumi.Input['ConnectionAdminCredentialsArgs'],
                 compartment_id: pulumi.Input[str],
                 database_type: pulumi.Input[str],
                 vault_details: pulumi.Input['ConnectionVaultDetailsArgs'],
                 certificate_tdn: Optional[pulumi.Input[str]] = None,
                 connect_descriptor: Optional[pulumi.Input['ConnectionConnectDescriptorArgs']] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manual_database_sub_type: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_endpoint: Optional[pulumi.Input['ConnectionPrivateEndpointArgs']] = None,
                 replication_credentials: Optional[pulumi.Input['ConnectionReplicationCredentialsArgs']] = None,
                 ssh_details: Optional[pulumi.Input['ConnectionSshDetailsArgs']] = None,
                 tls_keystore: Optional[pulumi.Input[str]] = None,
                 tls_wallet: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input['ConnectionAdminCredentialsArgs'] admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[str] database_type: Database connection type.
        :param pulumi.Input['ConnectionVaultDetailsArgs'] vault_details: (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        :param pulumi.Input[str] certificate_tdn: (Updatable) This name is the distinguished name used while creating the certificate on target database. Requires a TLS wallet to be specified. Not required for source container database connections.
        :param pulumi.Input['ConnectionConnectDescriptorArgs'] connect_descriptor: (Updatable) Connect Descriptor details. Required for Manual and UserManagerOci connection types. If a Private Endpoint was specified for the Connection, the host should contain a valid IP address.
        :param pulumi.Input[str] database_id: (Updatable) The OCID of the cloud database. Required if the database connection type is Autonomous.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Database Connection display name identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        :param pulumi.Input['ConnectionPrivateEndpointArgs'] private_endpoint: (Updatable) Oracle Cloud Infrastructure Private Endpoint configuration details. Not required for source container database connections, it will default to the specified Source Database Connection Private Endpoint.
        :param pulumi.Input['ConnectionReplicationCredentialsArgs'] replication_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input['ConnectionSshDetailsArgs'] ssh_details: (Updatable) Details of the SSH key that will be used. Required for source database Manual and UserManagerOci connection types. Not required for source container database connections.
        :param pulumi.Input[str] tls_keystore: (Updatable) keystore.jks file contents; base64 encoded String. Requires a TLS wallet to be specified. Not required for source container database connections.
        :param pulumi.Input[str] tls_wallet: (Updatable) cwallet.sso containing containing the TCPS/SSL certificate; base64 encoded String. Not required for source container database connections.
        """
        pulumi.set(__self__, "admin_credentials", admin_credentials)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "database_type", database_type)
        pulumi.set(__self__, "vault_details", vault_details)
        if certificate_tdn is not None:
            pulumi.set(__self__, "certificate_tdn", certificate_tdn)
        if connect_descriptor is not None:
            pulumi.set(__self__, "connect_descriptor", connect_descriptor)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if manual_database_sub_type is not None:
            pulumi.set(__self__, "manual_database_sub_type", manual_database_sub_type)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if replication_credentials is not None:
            pulumi.set(__self__, "replication_credentials", replication_credentials)
        if ssh_details is not None:
            pulumi.set(__self__, "ssh_details", ssh_details)
        if tls_keystore is not None:
            pulumi.set(__self__, "tls_keystore", tls_keystore)
        if tls_wallet is not None:
            pulumi.set(__self__, "tls_wallet", tls_wallet)

    @property
    @pulumi.getter(name="adminCredentials")
    def admin_credentials(self) -> pulumi.Input['ConnectionAdminCredentialsArgs']:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "admin_credentials")

    @admin_credentials.setter
    def admin_credentials(self, value: pulumi.Input['ConnectionAdminCredentialsArgs']):
        pulumi.set(self, "admin_credentials", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Input[str]:
        """
        Database connection type.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="vaultDetails")
    def vault_details(self) -> pulumi.Input['ConnectionVaultDetailsArgs']:
        """
        (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        return pulumi.get(self, "vault_details")

    @vault_details.setter
    def vault_details(self, value: pulumi.Input['ConnectionVaultDetailsArgs']):
        pulumi.set(self, "vault_details", value)

    @property
    @pulumi.getter(name="certificateTdn")
    def certificate_tdn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This name is the distinguished name used while creating the certificate on target database. Requires a TLS wallet to be specified. Not required for source container database connections.
        """
        return pulumi.get(self, "certificate_tdn")

    @certificate_tdn.setter
    def certificate_tdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_tdn", value)

    @property
    @pulumi.getter(name="connectDescriptor")
    def connect_descriptor(self) -> Optional[pulumi.Input['ConnectionConnectDescriptorArgs']]:
        """
        (Updatable) Connect Descriptor details. Required for Manual and UserManagerOci connection types. If a Private Endpoint was specified for the Connection, the host should contain a valid IP address.
        """
        return pulumi.get(self, "connect_descriptor")

    @connect_descriptor.setter
    def connect_descriptor(self, value: Optional[pulumi.Input['ConnectionConnectDescriptorArgs']]):
        pulumi.set(self, "connect_descriptor", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the cloud database. Required if the database connection type is Autonomous.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Database Connection display name identifier.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="manualDatabaseSubType")
    def manual_database_sub_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manual_database_sub_type")

    @manual_database_sub_type.setter
    def manual_database_sub_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manual_database_sub_type", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input['ConnectionPrivateEndpointArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Private Endpoint configuration details. Not required for source container database connections, it will default to the specified Source Database Connection Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input['ConnectionPrivateEndpointArgs']]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> Optional[pulumi.Input['ConnectionReplicationCredentialsArgs']]:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "replication_credentials")

    @replication_credentials.setter
    def replication_credentials(self, value: Optional[pulumi.Input['ConnectionReplicationCredentialsArgs']]):
        pulumi.set(self, "replication_credentials", value)

    @property
    @pulumi.getter(name="sshDetails")
    def ssh_details(self) -> Optional[pulumi.Input['ConnectionSshDetailsArgs']]:
        """
        (Updatable) Details of the SSH key that will be used. Required for source database Manual and UserManagerOci connection types. Not required for source container database connections.
        """
        return pulumi.get(self, "ssh_details")

    @ssh_details.setter
    def ssh_details(self, value: Optional[pulumi.Input['ConnectionSshDetailsArgs']]):
        pulumi.set(self, "ssh_details", value)

    @property
    @pulumi.getter(name="tlsKeystore")
    def tls_keystore(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) keystore.jks file contents; base64 encoded String. Requires a TLS wallet to be specified. Not required for source container database connections.
        """
        return pulumi.get(self, "tls_keystore")

    @tls_keystore.setter
    def tls_keystore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_keystore", value)

    @property
    @pulumi.getter(name="tlsWallet")
    def tls_wallet(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) cwallet.sso containing containing the TCPS/SSL certificate; base64 encoded String. Not required for source container database connections.
        """
        return pulumi.get(self, "tls_wallet")

    @tls_wallet.setter
    def tls_wallet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_wallet", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 admin_credentials: Optional[pulumi.Input['ConnectionAdminCredentialsArgs']] = None,
                 certificate_tdn: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connect_descriptor: Optional[pulumi.Input['ConnectionConnectDescriptorArgs']] = None,
                 credentials_secret_id: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 manual_database_sub_type: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_endpoint: Optional[pulumi.Input['ConnectionPrivateEndpointArgs']] = None,
                 replication_credentials: Optional[pulumi.Input['ConnectionReplicationCredentialsArgs']] = None,
                 ssh_details: Optional[pulumi.Input['ConnectionSshDetailsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 tls_keystore: Optional[pulumi.Input[str]] = None,
                 tls_wallet: Optional[pulumi.Input[str]] = None,
                 vault_details: Optional[pulumi.Input['ConnectionVaultDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input['ConnectionAdminCredentialsArgs'] admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[str] certificate_tdn: (Updatable) This name is the distinguished name used while creating the certificate on target database. Requires a TLS wallet to be specified. Not required for source container database connections.
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input['ConnectionConnectDescriptorArgs'] connect_descriptor: (Updatable) Connect Descriptor details. Required for Manual and UserManagerOci connection types. If a Private Endpoint was specified for the Connection, the host should contain a valid IP address.
        :param pulumi.Input[str] credentials_secret_id: OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Database Connection credentials.
        :param pulumi.Input[str] database_id: (Updatable) The OCID of the cloud database. Required if the database connection type is Autonomous.
        :param pulumi.Input[str] database_type: Database connection type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Database Connection display name identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        :param pulumi.Input['ConnectionPrivateEndpointArgs'] private_endpoint: (Updatable) Oracle Cloud Infrastructure Private Endpoint configuration details. Not required for source container database connections, it will default to the specified Source Database Connection Private Endpoint.
        :param pulumi.Input['ConnectionReplicationCredentialsArgs'] replication_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input['ConnectionSshDetailsArgs'] ssh_details: (Updatable) Details of the SSH key that will be used. Required for source database Manual and UserManagerOci connection types. Not required for source container database connections.
        :param pulumi.Input[str] state: The current state of the Connection resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the Connection resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time of the last Connection resource details update. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] tls_keystore: (Updatable) keystore.jks file contents; base64 encoded String. Requires a TLS wallet to be specified. Not required for source container database connections.
        :param pulumi.Input[str] tls_wallet: (Updatable) cwallet.sso containing containing the TCPS/SSL certificate; base64 encoded String. Not required for source container database connections.
        :param pulumi.Input['ConnectionVaultDetailsArgs'] vault_details: (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        if admin_credentials is not None:
            pulumi.set(__self__, "admin_credentials", admin_credentials)
        if certificate_tdn is not None:
            pulumi.set(__self__, "certificate_tdn", certificate_tdn)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connect_descriptor is not None:
            pulumi.set(__self__, "connect_descriptor", connect_descriptor)
        if credentials_secret_id is not None:
            pulumi.set(__self__, "credentials_secret_id", credentials_secret_id)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if manual_database_sub_type is not None:
            pulumi.set(__self__, "manual_database_sub_type", manual_database_sub_type)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if replication_credentials is not None:
            pulumi.set(__self__, "replication_credentials", replication_credentials)
        if ssh_details is not None:
            pulumi.set(__self__, "ssh_details", ssh_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if tls_keystore is not None:
            pulumi.set(__self__, "tls_keystore", tls_keystore)
        if tls_wallet is not None:
            pulumi.set(__self__, "tls_wallet", tls_wallet)
        if vault_details is not None:
            pulumi.set(__self__, "vault_details", vault_details)

    @property
    @pulumi.getter(name="adminCredentials")
    def admin_credentials(self) -> Optional[pulumi.Input['ConnectionAdminCredentialsArgs']]:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "admin_credentials")

    @admin_credentials.setter
    def admin_credentials(self, value: Optional[pulumi.Input['ConnectionAdminCredentialsArgs']]):
        pulumi.set(self, "admin_credentials", value)

    @property
    @pulumi.getter(name="certificateTdn")
    def certificate_tdn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This name is the distinguished name used while creating the certificate on target database. Requires a TLS wallet to be specified. Not required for source container database connections.
        """
        return pulumi.get(self, "certificate_tdn")

    @certificate_tdn.setter
    def certificate_tdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_tdn", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectDescriptor")
    def connect_descriptor(self) -> Optional[pulumi.Input['ConnectionConnectDescriptorArgs']]:
        """
        (Updatable) Connect Descriptor details. Required for Manual and UserManagerOci connection types. If a Private Endpoint was specified for the Connection, the host should contain a valid IP address.
        """
        return pulumi.get(self, "connect_descriptor")

    @connect_descriptor.setter
    def connect_descriptor(self, value: Optional[pulumi.Input['ConnectionConnectDescriptorArgs']]):
        pulumi.set(self, "connect_descriptor", value)

    @property
    @pulumi.getter(name="credentialsSecretId")
    def credentials_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Database Connection credentials.
        """
        return pulumi.get(self, "credentials_secret_id")

    @credentials_secret_id.setter
    def credentials_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credentials_secret_id", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the cloud database. Required if the database connection type is Autonomous.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        Database connection type.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Database Connection display name identifier.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="manualDatabaseSubType")
    def manual_database_sub_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manual_database_sub_type")

    @manual_database_sub_type.setter
    def manual_database_sub_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manual_database_sub_type", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input['ConnectionPrivateEndpointArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Private Endpoint configuration details. Not required for source container database connections, it will default to the specified Source Database Connection Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input['ConnectionPrivateEndpointArgs']]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> Optional[pulumi.Input['ConnectionReplicationCredentialsArgs']]:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "replication_credentials")

    @replication_credentials.setter
    def replication_credentials(self, value: Optional[pulumi.Input['ConnectionReplicationCredentialsArgs']]):
        pulumi.set(self, "replication_credentials", value)

    @property
    @pulumi.getter(name="sshDetails")
    def ssh_details(self) -> Optional[pulumi.Input['ConnectionSshDetailsArgs']]:
        """
        (Updatable) Details of the SSH key that will be used. Required for source database Manual and UserManagerOci connection types. Not required for source container database connections.
        """
        return pulumi.get(self, "ssh_details")

    @ssh_details.setter
    def ssh_details(self, value: Optional[pulumi.Input['ConnectionSshDetailsArgs']]):
        pulumi.set(self, "ssh_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Connection resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the Connection resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time of the last Connection resource details update. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="tlsKeystore")
    def tls_keystore(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) keystore.jks file contents; base64 encoded String. Requires a TLS wallet to be specified. Not required for source container database connections.
        """
        return pulumi.get(self, "tls_keystore")

    @tls_keystore.setter
    def tls_keystore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_keystore", value)

    @property
    @pulumi.getter(name="tlsWallet")
    def tls_wallet(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) cwallet.sso containing containing the TCPS/SSL certificate; base64 encoded String. Not required for source container database connections.
        """
        return pulumi.get(self, "tls_wallet")

    @tls_wallet.setter
    def tls_wallet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_wallet", value)

    @property
    @pulumi.getter(name="vaultDetails")
    def vault_details(self) -> Optional[pulumi.Input['ConnectionVaultDetailsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        return pulumi.get(self, "vault_details")

    @vault_details.setter
    def vault_details(self, value: Optional[pulumi.Input['ConnectionVaultDetailsArgs']]):
        pulumi.set(self, "vault_details", value)


class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_credentials: Optional[pulumi.Input[pulumi.InputType['ConnectionAdminCredentialsArgs']]] = None,
                 certificate_tdn: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connect_descriptor: Optional[pulumi.Input[pulumi.InputType['ConnectionConnectDescriptorArgs']]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manual_database_sub_type: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_endpoint: Optional[pulumi.Input[pulumi.InputType['ConnectionPrivateEndpointArgs']]] = None,
                 replication_credentials: Optional[pulumi.Input[pulumi.InputType['ConnectionReplicationCredentialsArgs']]] = None,
                 ssh_details: Optional[pulumi.Input[pulumi.InputType['ConnectionSshDetailsArgs']]] = None,
                 tls_keystore: Optional[pulumi.Input[str]] = None,
                 tls_wallet: Optional[pulumi.Input[str]] = None,
                 vault_details: Optional[pulumi.Input[pulumi.InputType['ConnectionVaultDetailsArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Connection resource in Oracle Cloud Infrastructure Database Migration service.

        Create a Database Connection resource that contains the details to connect to either a Source or Target Database
        in the migration.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.database_migration.Connection("test_connection",
            admin_credentials=oci.database_migration.ConnectionAdminCredentialsArgs(
                password=connection_admin_credentials_password,
                username=connection_admin_credentials_username,
            ),
            compartment_id=compartment_id,
            database_type=connection_database_type,
            vault_details=oci.database_migration.ConnectionVaultDetailsArgs(
                compartment_id=compartment_id,
                key_id=test_key["id"],
                vault_id=test_vault["id"],
            ),
            certificate_tdn=connection_certificate_tdn,
            connect_descriptor=oci.database_migration.ConnectionConnectDescriptorArgs(
                connect_string=connection_connect_descriptor_connect_string,
                database_service_name=test_service["name"],
                host=connection_connect_descriptor_host,
                port=connection_connect_descriptor_port,
            ),
            database_id=test_database["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=connection_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            nsg_ids=connection_nsg_ids,
            private_endpoint=oci.database_migration.ConnectionPrivateEndpointArgs(
                compartment_id=compartment_id,
                subnet_id=test_subnet["id"],
                vcn_id=test_vcn["id"],
            ),
            replication_credentials=oci.database_migration.ConnectionReplicationCredentialsArgs(
                password=connection_replication_credentials_password,
                username=connection_replication_credentials_username,
            ),
            ssh_details=oci.database_migration.ConnectionSshDetailsArgs(
                host=connection_ssh_details_host,
                sshkey=connection_ssh_details_sshkey,
                user=connection_ssh_details_user,
                sudo_location=connection_ssh_details_sudo_location,
            ),
            tls_keystore=connection_tls_keystore,
            tls_wallet=connection_tls_wallet)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseMigration/connection:Connection test_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConnectionAdminCredentialsArgs']] admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[str] certificate_tdn: (Updatable) This name is the distinguished name used while creating the certificate on target database. Requires a TLS wallet to be specified. Not required for source container database connections.
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[pulumi.InputType['ConnectionConnectDescriptorArgs']] connect_descriptor: (Updatable) Connect Descriptor details. Required for Manual and UserManagerOci connection types. If a Private Endpoint was specified for the Connection, the host should contain a valid IP address.
        :param pulumi.Input[str] database_id: (Updatable) The OCID of the cloud database. Required if the database connection type is Autonomous.
        :param pulumi.Input[str] database_type: Database connection type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Database Connection display name identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        :param pulumi.Input[pulumi.InputType['ConnectionPrivateEndpointArgs']] private_endpoint: (Updatable) Oracle Cloud Infrastructure Private Endpoint configuration details. Not required for source container database connections, it will default to the specified Source Database Connection Private Endpoint.
        :param pulumi.Input[pulumi.InputType['ConnectionReplicationCredentialsArgs']] replication_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[pulumi.InputType['ConnectionSshDetailsArgs']] ssh_details: (Updatable) Details of the SSH key that will be used. Required for source database Manual and UserManagerOci connection types. Not required for source container database connections.
        :param pulumi.Input[str] tls_keystore: (Updatable) keystore.jks file contents; base64 encoded String. Requires a TLS wallet to be specified. Not required for source container database connections.
        :param pulumi.Input[str] tls_wallet: (Updatable) cwallet.sso containing containing the TCPS/SSL certificate; base64 encoded String. Not required for source container database connections.
        :param pulumi.Input[pulumi.InputType['ConnectionVaultDetailsArgs']] vault_details: (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Connection resource in Oracle Cloud Infrastructure Database Migration service.

        Create a Database Connection resource that contains the details to connect to either a Source or Target Database
        in the migration.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.database_migration.Connection("test_connection",
            admin_credentials=oci.database_migration.ConnectionAdminCredentialsArgs(
                password=connection_admin_credentials_password,
                username=connection_admin_credentials_username,
            ),
            compartment_id=compartment_id,
            database_type=connection_database_type,
            vault_details=oci.database_migration.ConnectionVaultDetailsArgs(
                compartment_id=compartment_id,
                key_id=test_key["id"],
                vault_id=test_vault["id"],
            ),
            certificate_tdn=connection_certificate_tdn,
            connect_descriptor=oci.database_migration.ConnectionConnectDescriptorArgs(
                connect_string=connection_connect_descriptor_connect_string,
                database_service_name=test_service["name"],
                host=connection_connect_descriptor_host,
                port=connection_connect_descriptor_port,
            ),
            database_id=test_database["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=connection_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            nsg_ids=connection_nsg_ids,
            private_endpoint=oci.database_migration.ConnectionPrivateEndpointArgs(
                compartment_id=compartment_id,
                subnet_id=test_subnet["id"],
                vcn_id=test_vcn["id"],
            ),
            replication_credentials=oci.database_migration.ConnectionReplicationCredentialsArgs(
                password=connection_replication_credentials_password,
                username=connection_replication_credentials_username,
            ),
            ssh_details=oci.database_migration.ConnectionSshDetailsArgs(
                host=connection_ssh_details_host,
                sshkey=connection_ssh_details_sshkey,
                user=connection_ssh_details_user,
                sudo_location=connection_ssh_details_sudo_location,
            ),
            tls_keystore=connection_tls_keystore,
            tls_wallet=connection_tls_wallet)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseMigration/connection:Connection test_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_credentials: Optional[pulumi.Input[pulumi.InputType['ConnectionAdminCredentialsArgs']]] = None,
                 certificate_tdn: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connect_descriptor: Optional[pulumi.Input[pulumi.InputType['ConnectionConnectDescriptorArgs']]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 manual_database_sub_type: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_endpoint: Optional[pulumi.Input[pulumi.InputType['ConnectionPrivateEndpointArgs']]] = None,
                 replication_credentials: Optional[pulumi.Input[pulumi.InputType['ConnectionReplicationCredentialsArgs']]] = None,
                 ssh_details: Optional[pulumi.Input[pulumi.InputType['ConnectionSshDetailsArgs']]] = None,
                 tls_keystore: Optional[pulumi.Input[str]] = None,
                 tls_wallet: Optional[pulumi.Input[str]] = None,
                 vault_details: Optional[pulumi.Input[pulumi.InputType['ConnectionVaultDetailsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            if admin_credentials is None and not opts.urn:
                raise TypeError("Missing required property 'admin_credentials'")
            __props__.__dict__["admin_credentials"] = admin_credentials
            __props__.__dict__["certificate_tdn"] = certificate_tdn
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connect_descriptor"] = connect_descriptor
            __props__.__dict__["database_id"] = database_id
            if database_type is None and not opts.urn:
                raise TypeError("Missing required property 'database_type'")
            __props__.__dict__["database_type"] = database_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["manual_database_sub_type"] = manual_database_sub_type
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["private_endpoint"] = private_endpoint
            __props__.__dict__["replication_credentials"] = replication_credentials
            __props__.__dict__["ssh_details"] = ssh_details
            __props__.__dict__["tls_keystore"] = tls_keystore
            __props__.__dict__["tls_wallet"] = tls_wallet
            if vault_details is None and not opts.urn:
                raise TypeError("Missing required property 'vault_details'")
            __props__.__dict__["vault_details"] = vault_details
            __props__.__dict__["credentials_secret_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Connection, __self__).__init__(
            'oci:DatabaseMigration/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_credentials: Optional[pulumi.Input[pulumi.InputType['ConnectionAdminCredentialsArgs']]] = None,
            certificate_tdn: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connect_descriptor: Optional[pulumi.Input[pulumi.InputType['ConnectionConnectDescriptorArgs']]] = None,
            credentials_secret_id: Optional[pulumi.Input[str]] = None,
            database_id: Optional[pulumi.Input[str]] = None,
            database_type: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            manual_database_sub_type: Optional[pulumi.Input[str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            private_endpoint: Optional[pulumi.Input[pulumi.InputType['ConnectionPrivateEndpointArgs']]] = None,
            replication_credentials: Optional[pulumi.Input[pulumi.InputType['ConnectionReplicationCredentialsArgs']]] = None,
            ssh_details: Optional[pulumi.Input[pulumi.InputType['ConnectionSshDetailsArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            tls_keystore: Optional[pulumi.Input[str]] = None,
            tls_wallet: Optional[pulumi.Input[str]] = None,
            vault_details: Optional[pulumi.Input[pulumi.InputType['ConnectionVaultDetailsArgs']]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConnectionAdminCredentialsArgs']] admin_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[str] certificate_tdn: (Updatable) This name is the distinguished name used while creating the certificate on target database. Requires a TLS wallet to be specified. Not required for source container database connections.
        :param pulumi.Input[str] compartment_id: (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        :param pulumi.Input[pulumi.InputType['ConnectionConnectDescriptorArgs']] connect_descriptor: (Updatable) Connect Descriptor details. Required for Manual and UserManagerOci connection types. If a Private Endpoint was specified for the Connection, the host should contain a valid IP address.
        :param pulumi.Input[str] credentials_secret_id: OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Database Connection credentials.
        :param pulumi.Input[str] database_id: (Updatable) The OCID of the cloud database. Required if the database connection type is Autonomous.
        :param pulumi.Input[str] database_type: Database connection type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Database Connection display name identifier.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        :param pulumi.Input[pulumi.InputType['ConnectionPrivateEndpointArgs']] private_endpoint: (Updatable) Oracle Cloud Infrastructure Private Endpoint configuration details. Not required for source container database connections, it will default to the specified Source Database Connection Private Endpoint.
        :param pulumi.Input[pulumi.InputType['ConnectionReplicationCredentialsArgs']] replication_credentials: (Updatable) Database Administrator Credentials details.
        :param pulumi.Input[pulumi.InputType['ConnectionSshDetailsArgs']] ssh_details: (Updatable) Details of the SSH key that will be used. Required for source database Manual and UserManagerOci connection types. Not required for source container database connections.
        :param pulumi.Input[str] state: The current state of the Connection resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the Connection resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time of the last Connection resource details update. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] tls_keystore: (Updatable) keystore.jks file contents; base64 encoded String. Requires a TLS wallet to be specified. Not required for source container database connections.
        :param pulumi.Input[str] tls_wallet: (Updatable) cwallet.sso containing containing the TCPS/SSL certificate; base64 encoded String. Not required for source container database connections.
        :param pulumi.Input[pulumi.InputType['ConnectionVaultDetailsArgs']] vault_details: (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["admin_credentials"] = admin_credentials
        __props__.__dict__["certificate_tdn"] = certificate_tdn
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connect_descriptor"] = connect_descriptor
        __props__.__dict__["credentials_secret_id"] = credentials_secret_id
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["manual_database_sub_type"] = manual_database_sub_type
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["private_endpoint"] = private_endpoint
        __props__.__dict__["replication_credentials"] = replication_credentials
        __props__.__dict__["ssh_details"] = ssh_details
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["tls_keystore"] = tls_keystore
        __props__.__dict__["tls_wallet"] = tls_wallet
        __props__.__dict__["vault_details"] = vault_details
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminCredentials")
    def admin_credentials(self) -> pulumi.Output['outputs.ConnectionAdminCredentials']:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "admin_credentials")

    @property
    @pulumi.getter(name="certificateTdn")
    def certificate_tdn(self) -> pulumi.Output[str]:
        """
        (Updatable) This name is the distinguished name used while creating the certificate on target database. Requires a TLS wallet to be specified. Not required for source container database connections.
        """
        return pulumi.get(self, "certificate_tdn")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) OCID of the compartment where the secret containing the credentials will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectDescriptor")
    def connect_descriptor(self) -> pulumi.Output['outputs.ConnectionConnectDescriptor']:
        """
        (Updatable) Connect Descriptor details. Required for Manual and UserManagerOci connection types. If a Private Endpoint was specified for the Connection, the host should contain a valid IP address.
        """
        return pulumi.get(self, "connect_descriptor")

    @property
    @pulumi.getter(name="credentialsSecretId")
    def credentials_secret_id(self) -> pulumi.Output[str]:
        """
        OCID of the Secret in the Oracle Cloud Infrastructure vault containing the Database Connection credentials.
        """
        return pulumi.get(self, "credentials_secret_id")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the cloud database. Required if the database connection type is Autonomous.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[str]:
        """
        Database connection type.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Database Connection display name identifier.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="manualDatabaseSubType")
    def manual_database_sub_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "manual_database_sub_type")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> pulumi.Output['outputs.ConnectionPrivateEndpoint']:
        """
        (Updatable) Oracle Cloud Infrastructure Private Endpoint configuration details. Not required for source container database connections, it will default to the specified Source Database Connection Private Endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="replicationCredentials")
    def replication_credentials(self) -> pulumi.Output['outputs.ConnectionReplicationCredentials']:
        """
        (Updatable) Database Administrator Credentials details.
        """
        return pulumi.get(self, "replication_credentials")

    @property
    @pulumi.getter(name="sshDetails")
    def ssh_details(self) -> pulumi.Output['outputs.ConnectionSshDetails']:
        """
        (Updatable) Details of the SSH key that will be used. Required for source database Manual and UserManagerOci connection types. Not required for source container database connections.
        """
        return pulumi.get(self, "ssh_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Connection resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the Connection resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time of the last Connection resource details update. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="tlsKeystore")
    def tls_keystore(self) -> pulumi.Output[str]:
        """
        (Updatable) keystore.jks file contents; base64 encoded String. Requires a TLS wallet to be specified. Not required for source container database connections.
        """
        return pulumi.get(self, "tls_keystore")

    @property
    @pulumi.getter(name="tlsWallet")
    def tls_wallet(self) -> pulumi.Output[str]:
        """
        (Updatable) cwallet.sso containing containing the TCPS/SSL certificate; base64 encoded String. Not required for source container database connections.
        """
        return pulumi.get(self, "tls_wallet")

    @property
    @pulumi.getter(name="vaultDetails")
    def vault_details(self) -> pulumi.Output['outputs.ConnectionVaultDetails']:
        """
        (Updatable) Oracle Cloud Infrastructure Vault details to store migration and connection credentials secrets
        """
        return pulumi.get(self, "vault_details")

