# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    """
    A collection of values returned by getConnection.
    """
    def __init__(__self__, catalog_id=None, connection_key=None, created_by_id=None, data_asset_key=None, description=None, display_name=None, enc_properties=None, external_key=None, fields=None, id=None, is_default=None, key=None, properties=None, state=None, time_created=None, time_status_updated=None, time_updated=None, type_key=None, updated_by_id=None, uri=None):
        if catalog_id and not isinstance(catalog_id, str):
            raise TypeError("Expected argument 'catalog_id' to be a str")
        pulumi.set(__self__, "catalog_id", catalog_id)
        if connection_key and not isinstance(connection_key, str):
            raise TypeError("Expected argument 'connection_key' to be a str")
        pulumi.set(__self__, "connection_key", connection_key)
        if created_by_id and not isinstance(created_by_id, str):
            raise TypeError("Expected argument 'created_by_id' to be a str")
        pulumi.set(__self__, "created_by_id", created_by_id)
        if data_asset_key and not isinstance(data_asset_key, str):
            raise TypeError("Expected argument 'data_asset_key' to be a str")
        pulumi.set(__self__, "data_asset_key", data_asset_key)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enc_properties and not isinstance(enc_properties, dict):
            raise TypeError("Expected argument 'enc_properties' to be a dict")
        pulumi.set(__self__, "enc_properties", enc_properties)
        if external_key and not isinstance(external_key, str):
            raise TypeError("Expected argument 'external_key' to be a str")
        pulumi.set(__self__, "external_key", external_key)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_status_updated and not isinstance(time_status_updated, str):
            raise TypeError("Expected argument 'time_status_updated' to be a str")
        pulumi.set(__self__, "time_status_updated", time_status_updated)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type_key and not isinstance(type_key, str):
            raise TypeError("Expected argument 'type_key' to be a str")
        pulumi.set(__self__, "type_key", type_key)
        if updated_by_id and not isinstance(updated_by_id, str):
            raise TypeError("Expected argument 'updated_by_id' to be a str")
        pulumi.set(__self__, "updated_by_id", updated_by_id)
        if uri and not isinstance(uri, str):
            raise TypeError("Expected argument 'uri' to be a str")
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="connectionKey")
    def connection_key(self) -> str:
        return pulumi.get(self, "connection_key")

    @property
    @pulumi.getter(name="createdById")
    def created_by_id(self) -> str:
        """
        OCID of the user who created the connection.
        """
        return pulumi.get(self, "created_by_id")

    @property
    @pulumi.getter(name="dataAssetKey")
    def data_asset_key(self) -> str:
        """
        Unique key of the parent data asset.
        """
        return pulumi.get(self, "data_asset_key")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly display name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="encProperties")
    def enc_properties(self) -> Mapping[str, Any]:
        return pulumi.get(self, "enc_properties")

    @property
    @pulumi.getter(name="externalKey")
    def external_key(self) -> str:
        """
        Unique external key of this object from the source system.
        """
        return pulumi.get(self, "external_key")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Indicates whether this connection is the default connection.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Unique connection key that is immutable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, Any]:
        """
        A map of maps that contains the properties which are specific to the connection type. Each connection type definition defines it's set of required and optional properties. The map keys are category names and the values are maps of property name to property value. Every property is contained inside of a category. Most connections have required properties within the "default" category. Example: `{"properties": { "default": { "username": "user1"}}}`
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the connection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2019-03-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStatusUpdated")
    def time_status_updated(self) -> str:
        """
        Time that the connections status was last updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_status_updated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The last time that any change was made to the connection. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="typeKey")
    def type_key(self) -> str:
        """
        The key of the object type. Type key's can be found via the '/types' endpoint.
        """
        return pulumi.get(self, "type_key")

    @property
    @pulumi.getter(name="updatedById")
    def updated_by_id(self) -> str:
        """
        OCID of the user who modified the connection.
        """
        return pulumi.get(self, "updated_by_id")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI to the connection instance in the API.
        """
        return pulumi.get(self, "uri")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            catalog_id=self.catalog_id,
            connection_key=self.connection_key,
            created_by_id=self.created_by_id,
            data_asset_key=self.data_asset_key,
            description=self.description,
            display_name=self.display_name,
            enc_properties=self.enc_properties,
            external_key=self.external_key,
            fields=self.fields,
            id=self.id,
            is_default=self.is_default,
            key=self.key,
            properties=self.properties,
            state=self.state,
            time_created=self.time_created,
            time_status_updated=self.time_status_updated,
            time_updated=self.time_updated,
            type_key=self.type_key,
            updated_by_id=self.updated_by_id,
            uri=self.uri)


def get_connection(catalog_id: Optional[str] = None,
                   connection_key: Optional[str] = None,
                   data_asset_key: Optional[str] = None,
                   fields: Optional[Sequence[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    This data source provides details about a specific Connection resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a specific data asset connection by key.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection = oci.DataCatalog.get_connection(catalog_id=test_catalog["id"],
        connection_key=connection_connection_key,
        data_asset_key=connection_data_asset_key,
        fields=connection_fields)
    ```
    <!--End PulumiCodeChooser -->


    :param str catalog_id: Unique catalog identifier.
    :param str connection_key: Unique connection key.
    :param str data_asset_key: Unique data asset key.
    :param Sequence[str] fields: Specifies the fields to return in a connection response.
    """
    __args__ = dict()
    __args__['catalogId'] = catalog_id
    __args__['connectionKey'] = connection_key
    __args__['dataAssetKey'] = data_asset_key
    __args__['fields'] = fields
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getConnection:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        catalog_id=pulumi.get(__ret__, 'catalog_id'),
        connection_key=pulumi.get(__ret__, 'connection_key'),
        created_by_id=pulumi.get(__ret__, 'created_by_id'),
        data_asset_key=pulumi.get(__ret__, 'data_asset_key'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        enc_properties=pulumi.get(__ret__, 'enc_properties'),
        external_key=pulumi.get(__ret__, 'external_key'),
        fields=pulumi.get(__ret__, 'fields'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        key=pulumi.get(__ret__, 'key'),
        properties=pulumi.get(__ret__, 'properties'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_status_updated=pulumi.get(__ret__, 'time_status_updated'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type_key=pulumi.get(__ret__, 'type_key'),
        updated_by_id=pulumi.get(__ret__, 'updated_by_id'),
        uri=pulumi.get(__ret__, 'uri'))


@_utilities.lift_output_func(get_connection)
def get_connection_output(catalog_id: Optional[pulumi.Input[str]] = None,
                          connection_key: Optional[pulumi.Input[str]] = None,
                          data_asset_key: Optional[pulumi.Input[str]] = None,
                          fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionResult]:
    """
    This data source provides details about a specific Connection resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a specific data asset connection by key.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection = oci.DataCatalog.get_connection(catalog_id=test_catalog["id"],
        connection_key=connection_connection_key,
        data_asset_key=connection_data_asset_key,
        fields=connection_fields)
    ```
    <!--End PulumiCodeChooser -->


    :param str catalog_id: Unique catalog identifier.
    :param str connection_key: Unique connection key.
    :param str data_asset_key: Unique data asset key.
    :param Sequence[str] fields: Specifies the fields to return in a connection response.
    """
    ...
