# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetApplicationsResult',
    'AwaitableGetApplicationsResult',
    'get_applications',
    'get_applications_output',
]

@pulumi.output_type
class GetApplicationsResult:
    """
    A collection of values returned by getApplications.
    """
    def __init__(__self__, applications=None, compartment_id=None, display_name=None, display_name_starts_with=None, filters=None, id=None, owner_principal_id=None, spark_version=None):
        if applications and not isinstance(applications, list):
            raise TypeError("Expected argument 'applications' to be a list")
        pulumi.set(__self__, "applications", applications)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_starts_with and not isinstance(display_name_starts_with, str):
            raise TypeError("Expected argument 'display_name_starts_with' to be a str")
        pulumi.set(__self__, "display_name_starts_with", display_name_starts_with)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if owner_principal_id and not isinstance(owner_principal_id, str):
            raise TypeError("Expected argument 'owner_principal_id' to be a str")
        pulumi.set(__self__, "owner_principal_id", owner_principal_id)
        if spark_version and not isinstance(spark_version, str):
            raise TypeError("Expected argument 'spark_version' to be a str")
        pulumi.set(__self__, "spark_version", spark_version)

    @property
    @pulumi.getter
    def applications(self) -> Sequence['outputs.GetApplicationsApplicationResult']:
        """
        The list of applications.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. This name is not necessarily unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameStartsWith")
    def display_name_starts_with(self) -> Optional[str]:
        return pulumi.get(self, "display_name_starts_with")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetApplicationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ownerPrincipalId")
    def owner_principal_id(self) -> Optional[str]:
        """
        The OCID of the user who created the resource.
        """
        return pulumi.get(self, "owner_principal_id")

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[str]:
        """
        The Spark version utilized to run the application.
        """
        return pulumi.get(self, "spark_version")


class AwaitableGetApplicationsResult(GetApplicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationsResult(
            applications=self.applications,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            display_name_starts_with=self.display_name_starts_with,
            filters=self.filters,
            id=self.id,
            owner_principal_id=self.owner_principal_id,
            spark_version=self.spark_version)


def get_applications(compartment_id: Optional[str] = None,
                     display_name: Optional[str] = None,
                     display_name_starts_with: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetApplicationsFilterArgs']]] = None,
                     owner_principal_id: Optional[str] = None,
                     spark_version: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationsResult:
    """
    This data source provides the list of Applications in Oracle Cloud Infrastructure Data Flow service.

    Lists all applications in the specified compartment. Only one parameter other than compartmentId may also be included in a query. The query must include compartmentId. If the query does not include compartmentId, or includes compartmentId but two or more other parameters an error is returned.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_applications = oci.DataFlow.get_applications(compartment_id=compartment_id,
        display_name=application_display_name,
        display_name_starts_with=application_display_name_starts_with,
        owner_principal_id=test_owner_principal["id"],
        spark_version=application_spark_version)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment.
    :param str display_name: The query parameter for the Spark application name.
    :param str display_name_starts_with: The displayName prefix.
    :param str owner_principal_id: The OCID of the user who created the resource.
    :param str spark_version: The Spark version utilized to run the application.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameStartsWith'] = display_name_starts_with
    __args__['filters'] = filters
    __args__['ownerPrincipalId'] = owner_principal_id
    __args__['sparkVersion'] = spark_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataFlow/getApplications:getApplications', __args__, opts=opts, typ=GetApplicationsResult).value

    return AwaitableGetApplicationsResult(
        applications=pulumi.get(__ret__, 'applications'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_starts_with=pulumi.get(__ret__, 'display_name_starts_with'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        owner_principal_id=pulumi.get(__ret__, 'owner_principal_id'),
        spark_version=pulumi.get(__ret__, 'spark_version'))


@_utilities.lift_output_func(get_applications)
def get_applications_output(compartment_id: Optional[pulumi.Input[str]] = None,
                            display_name: Optional[pulumi.Input[Optional[str]]] = None,
                            display_name_starts_with: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetApplicationsFilterArgs']]]]] = None,
                            owner_principal_id: Optional[pulumi.Input[Optional[str]]] = None,
                            spark_version: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationsResult]:
    """
    This data source provides the list of Applications in Oracle Cloud Infrastructure Data Flow service.

    Lists all applications in the specified compartment. Only one parameter other than compartmentId may also be included in a query. The query must include compartmentId. If the query does not include compartmentId, or includes compartmentId but two or more other parameters an error is returned.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_applications = oci.DataFlow.get_applications(compartment_id=compartment_id,
        display_name=application_display_name,
        display_name_starts_with=application_display_name_starts_with,
        owner_principal_id=test_owner_principal["id"],
        spark_version=application_spark_version)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment.
    :param str display_name: The query parameter for the Spark application name.
    :param str display_name_starts_with: The displayName prefix.
    :param str owner_principal_id: The OCID of the user who created the resource.
    :param str spark_version: The Spark version utilized to run the application.
    """
    ...
