# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRunStatementResult',
    'AwaitableGetRunStatementResult',
    'get_run_statement',
    'get_run_statement_output',
]

@pulumi.output_type
class GetRunStatementResult:
    """
    A collection of values returned by getRunStatement.
    """
    def __init__(__self__, code=None, id=None, outputs=None, progress=None, run_id=None, state=None, statement_id=None, time_completed=None, time_created=None):
        if code and not isinstance(code, str):
            raise TypeError("Expected argument 'code' to be a str")
        pulumi.set(__self__, "code", code)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if outputs and not isinstance(outputs, list):
            raise TypeError("Expected argument 'outputs' to be a list")
        pulumi.set(__self__, "outputs", outputs)
        if progress and not isinstance(progress, float):
            raise TypeError("Expected argument 'progress' to be a float")
        pulumi.set(__self__, "progress", progress)
        if run_id and not isinstance(run_id, str):
            raise TypeError("Expected argument 'run_id' to be a str")
        pulumi.set(__self__, "run_id", run_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if statement_id and not isinstance(statement_id, str):
            raise TypeError("Expected argument 'statement_id' to be a str")
        pulumi.set(__self__, "statement_id", statement_id)
        if time_completed and not isinstance(time_completed, str):
            raise TypeError("Expected argument 'time_completed' to be a str")
        pulumi.set(__self__, "time_completed", time_completed)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The statement code to execute. Example: `println(sc.version)`
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The statement ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def outputs(self) -> Sequence['outputs.GetRunStatementOutputResult']:
        """
        The execution output of a statement.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def progress(self) -> float:
        """
        The execution progress.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        """
        The ID of a run.
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of this statement.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> str:
        return pulumi.get(self, "statement_id")

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> str:
        """
        The date and time a statement execution was completed, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2022-05-31T21:10:29.600Z`
        """
        return pulumi.get(self, "time_completed")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2018-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetRunStatementResult(GetRunStatementResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunStatementResult(
            code=self.code,
            id=self.id,
            outputs=self.outputs,
            progress=self.progress,
            run_id=self.run_id,
            state=self.state,
            statement_id=self.statement_id,
            time_completed=self.time_completed,
            time_created=self.time_created)


def get_run_statement(run_id: Optional[str] = None,
                      statement_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunStatementResult:
    """
    This data source provides details about a specific Run Statement resource in Oracle Cloud Infrastructure Data Flow service.

    Retrieves the statement corresponding to the `statementId` for a Session run specified by `runId`.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_run_statement = oci.DataFlow.get_run_statement(run_id=test_run["id"],
        statement_id=test_statement["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str run_id: The unique ID for the run
    :param str statement_id: The unique ID for the statement.
    """
    __args__ = dict()
    __args__['runId'] = run_id
    __args__['statementId'] = statement_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataFlow/getRunStatement:getRunStatement', __args__, opts=opts, typ=GetRunStatementResult).value

    return AwaitableGetRunStatementResult(
        code=pulumi.get(__ret__, 'code'),
        id=pulumi.get(__ret__, 'id'),
        outputs=pulumi.get(__ret__, 'outputs'),
        progress=pulumi.get(__ret__, 'progress'),
        run_id=pulumi.get(__ret__, 'run_id'),
        state=pulumi.get(__ret__, 'state'),
        statement_id=pulumi.get(__ret__, 'statement_id'),
        time_completed=pulumi.get(__ret__, 'time_completed'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_run_statement)
def get_run_statement_output(run_id: Optional[pulumi.Input[str]] = None,
                             statement_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRunStatementResult]:
    """
    This data source provides details about a specific Run Statement resource in Oracle Cloud Infrastructure Data Flow service.

    Retrieves the statement corresponding to the `statementId` for a Session run specified by `runId`.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_run_statement = oci.DataFlow.get_run_statement(run_id=test_run["id"],
        statement_id=test_statement["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str run_id: The unique ID for the run
    :param str statement_id: The unique ID for the statement.
    """
    ...
