# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRunStatementsResult',
    'AwaitableGetRunStatementsResult',
    'get_run_statements',
    'get_run_statements_output',
]

@pulumi.output_type
class GetRunStatementsResult:
    """
    A collection of values returned by getRunStatements.
    """
    def __init__(__self__, filters=None, id=None, run_id=None, state=None, statement_collections=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if run_id and not isinstance(run_id, str):
            raise TypeError("Expected argument 'run_id' to be a str")
        pulumi.set(__self__, "run_id", run_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if statement_collections and not isinstance(statement_collections, list):
            raise TypeError("Expected argument 'statement_collections' to be a list")
        pulumi.set(__self__, "statement_collections", statement_collections)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRunStatementsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> str:
        """
        The ID of a run.
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of this statement.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="statementCollections")
    def statement_collections(self) -> Sequence['outputs.GetRunStatementsStatementCollectionResult']:
        """
        The list of statement_collection.
        """
        return pulumi.get(self, "statement_collections")


class AwaitableGetRunStatementsResult(GetRunStatementsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRunStatementsResult(
            filters=self.filters,
            id=self.id,
            run_id=self.run_id,
            state=self.state,
            statement_collections=self.statement_collections)


def get_run_statements(filters: Optional[Sequence[pulumi.InputType['GetRunStatementsFilterArgs']]] = None,
                       run_id: Optional[str] = None,
                       state: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRunStatementsResult:
    """
    This data source provides the list of Run Statements in Oracle Cloud Infrastructure Data Flow service.

    Lists all statements for a Session run.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_run_statements = oci.DataFlow.get_run_statements(run_id=test_run["id"],
        state=run_statement_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str run_id: The unique ID for the run
    :param str state: The LifecycleState of the statement.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['runId'] = run_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataFlow/getRunStatements:getRunStatements', __args__, opts=opts, typ=GetRunStatementsResult).value

    return AwaitableGetRunStatementsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        run_id=pulumi.get(__ret__, 'run_id'),
        state=pulumi.get(__ret__, 'state'),
        statement_collections=pulumi.get(__ret__, 'statement_collections'))


@_utilities.lift_output_func(get_run_statements)
def get_run_statements_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetRunStatementsFilterArgs']]]]] = None,
                              run_id: Optional[pulumi.Input[str]] = None,
                              state: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRunStatementsResult]:
    """
    This data source provides the list of Run Statements in Oracle Cloud Infrastructure Data Flow service.

    Lists all statements for a Session run.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_run_statements = oci.DataFlow.get_run_statements(run_id=test_run["id"],
        state=run_statement_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str run_id: The unique ID for the run
    :param str state: The LifecycleState of the statement.
    """
    ...
