# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceApplicationArgs', 'WorkspaceApplication']

@pulumi.input_type
class WorkspaceApplicationArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[str],
                 model_type: pulumi.Input[str],
                 workspace_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationRegistryMetadataArgs']] = None,
                 source_application_info: Optional[pulumi.Input['WorkspaceApplicationSourceApplicationInfoArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WorkspaceApplication resource.
        :param pulumi.Input[str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] model_type: (Updatable) The type of the application.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[str] display_name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] key: The identifying key for the object.
        :param pulumi.Input[str] model_version: (Updatable) The object's model version.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input['WorkspaceApplicationRegistryMetadataArgs'] registry_metadata: Information about the object and its parent.
        :param pulumi.Input['WorkspaceApplicationSourceApplicationInfoArgs'] source_application_info: The information about the application.
        :param pulumi.Input[str] state: (Updatable) The current state of the workspace.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if source_application_info is not None:
            pulumi.set(__self__, "source_application_info", source_application_info)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of the application.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The identifying key for the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The object's model version.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationRegistryMetadataArgs']]:
        """
        Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter(name="sourceApplicationInfo")
    def source_application_info(self) -> Optional[pulumi.Input['WorkspaceApplicationSourceApplicationInfoArgs']]:
        """
        The information about the application.
        """
        return pulumi.get(self, "source_application_info")

    @source_application_info.setter
    def source_application_info(self, value: Optional[pulumi.Input['WorkspaceApplicationSourceApplicationInfoArgs']]):
        pulumi.set(self, "source_application_info", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The current state of the workspace.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _WorkspaceApplicationState:
    def __init__(__self__, *,
                 application_version: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 dependent_object_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationDependentObjectMetadataArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 key_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationMetadataArgs']]]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 parent_reves: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationParentRefArgs']]]] = None,
                 published_object_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPublishedObjectMetadataArgs']]]] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationRegistryMetadataArgs']] = None,
                 source_application_info: Optional[pulumi.Input['WorkspaceApplicationSourceApplicationInfoArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_patched: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceApplication resources.
        :param pulumi.Input[int] application_version: The source application version of the application.
        :param pulumi.Input[str] compartment_id: OCID of the compartment that this resource belongs to. Defaults to compartment of the Workspace.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationDependentObjectMetadataArgs']]] dependent_object_metadatas: A list of dependent objects in this patch.
        :param pulumi.Input[str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[str] display_name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] key: The identifying key for the object.
        :param pulumi.Input[Mapping[str, Any]] key_map: A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationMetadataArgs']]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[str] model_type: (Updatable) The type of the application.
        :param pulumi.Input[str] model_version: (Updatable) The object's model version.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: The object version.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationParentRefArgs']]] parent_reves: A reference to the object's parent.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPublishedObjectMetadataArgs']]] published_object_metadatas: A list of objects that are published or unpublished in this patch.
        :param pulumi.Input['WorkspaceApplicationRegistryMetadataArgs'] registry_metadata: Information about the object and its parent.
        :param pulumi.Input['WorkspaceApplicationSourceApplicationInfoArgs'] source_application_info: The information about the application.
        :param pulumi.Input[str] state: (Updatable) The current state of the workspace.
        :param pulumi.Input[str] time_created: The date and time the application was created, in the timestamp format defined by RFC3339.
        :param pulumi.Input[str] time_patched: The date and time the application was patched, in the timestamp format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the application was updated, in the timestamp format defined by RFC3339. example: 2019-08-25T21:10:29.41Z
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if application_version is not None:
            pulumi.set(__self__, "application_version", application_version)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if dependent_object_metadatas is not None:
            pulumi.set(__self__, "dependent_object_metadatas", dependent_object_metadatas)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key_map is not None:
            pulumi.set(__self__, "key_map", key_map)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if parent_reves is not None:
            pulumi.set(__self__, "parent_reves", parent_reves)
        if published_object_metadatas is not None:
            pulumi.set(__self__, "published_object_metadatas", published_object_metadatas)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if source_application_info is not None:
            pulumi.set(__self__, "source_application_info", source_application_info)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_patched is not None:
            pulumi.set(__self__, "time_patched", time_patched)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> Optional[pulumi.Input[int]]:
        """
        The source application version of the application.
        """
        return pulumi.get(self, "application_version")

    @application_version.setter
    def application_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "application_version", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the compartment that this resource belongs to. Defaults to compartment of the Workspace.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="dependentObjectMetadatas")
    def dependent_object_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationDependentObjectMetadataArgs']]]]:
        """
        A list of dependent objects in this patch.
        """
        return pulumi.get(self, "dependent_object_metadatas")

    @dependent_object_metadatas.setter
    def dependent_object_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationDependentObjectMetadataArgs']]]]):
        pulumi.set(self, "dependent_object_metadatas", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The identifying key for the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @key_map.setter
    def key_map(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "key_map", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationMetadataArgs']]]]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of the application.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The object's model version.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[int]]:
        """
        The object version.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_version", value)

    @property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationParentRefArgs']]]]:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @parent_reves.setter
    def parent_reves(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationParentRefArgs']]]]):
        pulumi.set(self, "parent_reves", value)

    @property
    @pulumi.getter(name="publishedObjectMetadatas")
    def published_object_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPublishedObjectMetadataArgs']]]]:
        """
        A list of objects that are published or unpublished in this patch.
        """
        return pulumi.get(self, "published_object_metadatas")

    @published_object_metadatas.setter
    def published_object_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPublishedObjectMetadataArgs']]]]):
        pulumi.set(self, "published_object_metadatas", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationRegistryMetadataArgs']]:
        """
        Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter(name="sourceApplicationInfo")
    def source_application_info(self) -> Optional[pulumi.Input['WorkspaceApplicationSourceApplicationInfoArgs']]:
        """
        The information about the application.
        """
        return pulumi.get(self, "source_application_info")

    @source_application_info.setter
    def source_application_info(self, value: Optional[pulumi.Input['WorkspaceApplicationSourceApplicationInfoArgs']]):
        pulumi.set(self, "source_application_info", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The current state of the workspace.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the application was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timePatched")
    def time_patched(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the application was patched, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_patched")

    @time_patched.setter
    def time_patched(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_patched", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the application was updated, in the timestamp format defined by RFC3339. example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


class WorkspaceApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationRegistryMetadataArgs']]] = None,
                 source_application_info: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationSourceApplicationInfoArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Application resource in Oracle Cloud Infrastructure Data Integration service.

        Creates an application.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application = oci.data_integration.WorkspaceApplication("test_workspace_application",
            identifier=workspace_application_identifier,
            name=workspace_application_name,
            workspace_id=test_workspace["id"],
            model_type=workspace_application_model_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=workspace_application_description,
            display_name=workspace_application_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            key=workspace_application_key,
            model_version=workspace_application_model_version,
            object_status=workspace_application_object_status,
            registry_metadata=oci.data_integration.WorkspaceApplicationRegistryMetadataArgs(
                aggregator_key=workspace_application_registry_metadata_aggregator_key,
                is_favorite=workspace_application_registry_metadata_is_favorite,
                key=workspace_application_registry_metadata_key,
                labels=workspace_application_registry_metadata_labels,
                registry_version=workspace_application_registry_metadata_registry_version,
            ),
            source_application_info=oci.data_integration.WorkspaceApplicationSourceApplicationInfoArgs(
                application_key=workspace_application_source_application_info_application_key,
                copy_type=workspace_application_source_application_info_copy_type,
                workspace_id=test_workspace["id"],
            ),
            state=workspace_application_state)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        WorkspaceApplications can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplication:WorkspaceApplication test_workspace_application "workspaces/{workspaceId}/applications/{applicationKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[str] display_name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] key: The identifying key for the object.
        :param pulumi.Input[str] model_type: (Updatable) The type of the application.
        :param pulumi.Input[str] model_version: (Updatable) The object's model version.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationRegistryMetadataArgs']] registry_metadata: Information about the object and its parent.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationSourceApplicationInfoArgs']] source_application_info: The information about the application.
        :param pulumi.Input[str] state: (Updatable) The current state of the workspace.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Application resource in Oracle Cloud Infrastructure Data Integration service.

        Creates an application.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application = oci.data_integration.WorkspaceApplication("test_workspace_application",
            identifier=workspace_application_identifier,
            name=workspace_application_name,
            workspace_id=test_workspace["id"],
            model_type=workspace_application_model_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=workspace_application_description,
            display_name=workspace_application_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            key=workspace_application_key,
            model_version=workspace_application_model_version,
            object_status=workspace_application_object_status,
            registry_metadata=oci.data_integration.WorkspaceApplicationRegistryMetadataArgs(
                aggregator_key=workspace_application_registry_metadata_aggregator_key,
                is_favorite=workspace_application_registry_metadata_is_favorite,
                key=workspace_application_registry_metadata_key,
                labels=workspace_application_registry_metadata_labels,
                registry_version=workspace_application_registry_metadata_registry_version,
            ),
            source_application_info=oci.data_integration.WorkspaceApplicationSourceApplicationInfoArgs(
                application_key=workspace_application_source_application_info_application_key,
                copy_type=workspace_application_source_application_info_copy_type,
                workspace_id=test_workspace["id"],
            ),
            state=workspace_application_state)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        WorkspaceApplications can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplication:WorkspaceApplication test_workspace_application "workspaces/{workspaceId}/applications/{applicationKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationRegistryMetadataArgs']]] = None,
                 source_application_info: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationSourceApplicationInfoArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceApplicationArgs.__new__(WorkspaceApplicationArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["key"] = key
            if model_type is None and not opts.urn:
                raise TypeError("Missing required property 'model_type'")
            __props__.__dict__["model_type"] = model_type
            __props__.__dict__["model_version"] = model_version
            __props__.__dict__["name"] = name
            __props__.__dict__["object_status"] = object_status
            __props__.__dict__["registry_metadata"] = registry_metadata
            __props__.__dict__["source_application_info"] = source_application_info
            __props__.__dict__["state"] = state
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["application_version"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["dependent_object_metadatas"] = None
            __props__.__dict__["key_map"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["object_version"] = None
            __props__.__dict__["parent_reves"] = None
            __props__.__dict__["published_object_metadatas"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_patched"] = None
            __props__.__dict__["time_updated"] = None
        super(WorkspaceApplication, __self__).__init__(
            'oci:DataIntegration/workspaceApplication:WorkspaceApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_version: Optional[pulumi.Input[int]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            dependent_object_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationDependentObjectMetadataArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            key_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationMetadataArgs']]]]] = None,
            model_type: Optional[pulumi.Input[str]] = None,
            model_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            object_status: Optional[pulumi.Input[int]] = None,
            object_version: Optional[pulumi.Input[int]] = None,
            parent_reves: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationParentRefArgs']]]]] = None,
            published_object_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPublishedObjectMetadataArgs']]]]] = None,
            registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationRegistryMetadataArgs']]] = None,
            source_application_info: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationSourceApplicationInfoArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_patched: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            workspace_id: Optional[pulumi.Input[str]] = None) -> 'WorkspaceApplication':
        """
        Get an existing WorkspaceApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] application_version: The source application version of the application.
        :param pulumi.Input[str] compartment_id: OCID of the compartment that this resource belongs to. Defaults to compartment of the Workspace.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationDependentObjectMetadataArgs']]]] dependent_object_metadatas: A list of dependent objects in this patch.
        :param pulumi.Input[str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[str] display_name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] key: The identifying key for the object.
        :param pulumi.Input[Mapping[str, Any]] key_map: A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationMetadataArgs']]]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[str] model_type: (Updatable) The type of the application.
        :param pulumi.Input[str] model_version: (Updatable) The object's model version.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: The object version.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationParentRefArgs']]]] parent_reves: A reference to the object's parent.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPublishedObjectMetadataArgs']]]] published_object_metadatas: A list of objects that are published or unpublished in this patch.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationRegistryMetadataArgs']] registry_metadata: Information about the object and its parent.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationSourceApplicationInfoArgs']] source_application_info: The information about the application.
        :param pulumi.Input[str] state: (Updatable) The current state of the workspace.
        :param pulumi.Input[str] time_created: The date and time the application was created, in the timestamp format defined by RFC3339.
        :param pulumi.Input[str] time_patched: The date and time the application was patched, in the timestamp format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The date and time the application was updated, in the timestamp format defined by RFC3339. example: 2019-08-25T21:10:29.41Z
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceApplicationState.__new__(_WorkspaceApplicationState)

        __props__.__dict__["application_version"] = application_version
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["dependent_object_metadatas"] = dependent_object_metadatas
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["key"] = key
        __props__.__dict__["key_map"] = key_map
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["name"] = name
        __props__.__dict__["object_status"] = object_status
        __props__.__dict__["object_version"] = object_version
        __props__.__dict__["parent_reves"] = parent_reves
        __props__.__dict__["published_object_metadatas"] = published_object_metadatas
        __props__.__dict__["registry_metadata"] = registry_metadata
        __props__.__dict__["source_application_info"] = source_application_info
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_patched"] = time_patched
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> pulumi.Output[int]:
        """
        The source application version of the application.
        """
        return pulumi.get(self, "application_version")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        OCID of the compartment that this resource belongs to. Defaults to compartment of the Workspace.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="dependentObjectMetadatas")
    def dependent_object_metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationDependentObjectMetadata']]:
        """
        A list of dependent objects in this patch.
        """
        return pulumi.get(self, "dependent_object_metadatas")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The identifying key for the object.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationMetadata']]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of the application.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[str]:
        """
        (Updatable) The object's model version.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> pulumi.Output[int]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> pulumi.Output[int]:
        """
        The object version.
        """
        return pulumi.get(self, "object_version")

    @property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationParentRef']]:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @property
    @pulumi.getter(name="publishedObjectMetadatas")
    def published_object_metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationPublishedObjectMetadata']]:
        """
        A list of objects that are published or unpublished in this patch.
        """
        return pulumi.get(self, "published_object_metadatas")

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> pulumi.Output['outputs.WorkspaceApplicationRegistryMetadata']:
        """
        Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @property
    @pulumi.getter(name="sourceApplicationInfo")
    def source_application_info(self) -> pulumi.Output['outputs.WorkspaceApplicationSourceApplicationInfo']:
        """
        The information about the application.
        """
        return pulumi.get(self, "source_application_info")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Updatable) The current state of the workspace.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the application was created, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timePatched")
    def time_patched(self) -> pulumi.Output[str]:
        """
        The date and time the application was patched, in the timestamp format defined by RFC3339.
        """
        return pulumi.get(self, "time_patched")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the application was updated, in the timestamp format defined by RFC3339. example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

