# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCompatibleFormatsForSensitiveTypeResult',
    'AwaitableGetCompatibleFormatsForSensitiveTypeResult',
    'get_compatible_formats_for_sensitive_type',
    'get_compatible_formats_for_sensitive_type_output',
]

@pulumi.output_type
class GetCompatibleFormatsForSensitiveTypeResult:
    """
    A collection of values returned by getCompatibleFormatsForSensitiveType.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, formats_for_sensitive_types=None, id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if formats_for_sensitive_types and not isinstance(formats_for_sensitive_types, list):
            raise TypeError("Expected argument 'formats_for_sensitive_types' to be a list")
        pulumi.set(__self__, "formats_for_sensitive_types", formats_for_sensitive_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="formatsForSensitiveTypes")
    def formats_for_sensitive_types(self) -> Sequence['outputs.GetCompatibleFormatsForSensitiveTypeFormatsForSensitiveTypeResult']:
        """
        An array of library masking formats compatible with the existing sensitive types.
        """
        return pulumi.get(self, "formats_for_sensitive_types")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetCompatibleFormatsForSensitiveTypeResult(GetCompatibleFormatsForSensitiveTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCompatibleFormatsForSensitiveTypeResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            formats_for_sensitive_types=self.formats_for_sensitive_types,
            id=self.id)


def get_compatible_formats_for_sensitive_type(access_level: Optional[str] = None,
                                              compartment_id: Optional[str] = None,
                                              compartment_id_in_subtree: Optional[bool] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCompatibleFormatsForSensitiveTypeResult:
    """
    This data source provides details about a specific Compatible Formats For Sensitive Type resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of library masking formats compatible with the existing sensitive types.
    For each sensitive type, it returns the assigned default masking format as well as
    the other library masking formats that have the sensitiveTypeIds attribute containing
    the OCID of the sensitive type.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_compatible_formats_for_sensitive_type = oci.DataSafe.get_compatible_formats_for_sensitive_type(compartment_id=compartment_id,
        access_level=compatible_formats_for_sensitive_type_access_level,
        compartment_id_in_subtree=compatible_formats_for_sensitive_type_compartment_id_in_subtree)
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getCompatibleFormatsForSensitiveType:getCompatibleFormatsForSensitiveType', __args__, opts=opts, typ=GetCompatibleFormatsForSensitiveTypeResult).value

    return AwaitableGetCompatibleFormatsForSensitiveTypeResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        formats_for_sensitive_types=pulumi.get(__ret__, 'formats_for_sensitive_types'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_compatible_formats_for_sensitive_type)
def get_compatible_formats_for_sensitive_type_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                                     compartment_id: Optional[pulumi.Input[str]] = None,
                                                     compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCompatibleFormatsForSensitiveTypeResult]:
    """
    This data source provides details about a specific Compatible Formats For Sensitive Type resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of library masking formats compatible with the existing sensitive types.
    For each sensitive type, it returns the assigned default masking format as well as
    the other library masking formats that have the sensitiveTypeIds attribute containing
    the OCID of the sensitive type.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_compatible_formats_for_sensitive_type = oci.DataSafe.get_compatible_formats_for_sensitive_type(compartment_id=compartment_id,
        access_level=compatible_formats_for_sensitive_type_access_level,
        compartment_id_in_subtree=compatible_formats_for_sensitive_type_compartment_id_in_subtree)
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    """
    ...
