# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityAssessmentFindingAnalyticsResult',
    'AwaitableGetSecurityAssessmentFindingAnalyticsResult',
    'get_security_assessment_finding_analytics',
    'get_security_assessment_finding_analytics_output',
]

@pulumi.output_type
class GetSecurityAssessmentFindingAnalyticsResult:
    """
    A collection of values returned by getSecurityAssessmentFindingAnalytics.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, finding_analytics_collections=None, finding_key=None, group_by=None, id=None, is_top_finding=None, severity=None, top_finding_status=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if finding_analytics_collections and not isinstance(finding_analytics_collections, list):
            raise TypeError("Expected argument 'finding_analytics_collections' to be a list")
        pulumi.set(__self__, "finding_analytics_collections", finding_analytics_collections)
        if finding_key and not isinstance(finding_key, str):
            raise TypeError("Expected argument 'finding_key' to be a str")
        pulumi.set(__self__, "finding_key", finding_key)
        if group_by and not isinstance(group_by, str):
            raise TypeError("Expected argument 'group_by' to be a str")
        pulumi.set(__self__, "group_by", group_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_top_finding and not isinstance(is_top_finding, bool):
            raise TypeError("Expected argument 'is_top_finding' to be a bool")
        pulumi.set(__self__, "is_top_finding", is_top_finding)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if top_finding_status and not isinstance(top_finding_status, str):
            raise TypeError("Expected argument 'top_finding_status' to be a str")
        pulumi.set(__self__, "top_finding_status", top_finding_status)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityAssessmentFindingAnalyticsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="findingAnalyticsCollections")
    def finding_analytics_collections(self) -> Sequence['outputs.GetSecurityAssessmentFindingAnalyticsFindingAnalyticsCollectionResult']:
        """
        The list of finding_analytics_collection.
        """
        return pulumi.get(self, "finding_analytics_collections")

    @property
    @pulumi.getter(name="findingKey")
    def finding_key(self) -> Optional[str]:
        return pulumi.get(self, "finding_key")

    @property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> Optional[str]:
        return pulumi.get(self, "group_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isTopFinding")
    def is_top_finding(self) -> Optional[bool]:
        return pulumi.get(self, "is_top_finding")

    @property
    @pulumi.getter
    def severity(self) -> Optional[str]:
        """
        The severity (risk level) of the finding.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="topFindingStatus")
    def top_finding_status(self) -> Optional[str]:
        """
        The status of the top finding.  All findings will have "severity" to indicate the risk level, but only top findings will have "status".  Possible status: Pass / Risk (Low, Medium, High)/ Evaluate / Advisory / Deferred Instead of having "Low, Medium, High" in severity, "Risk" will include these three situations in status.
        """
        return pulumi.get(self, "top_finding_status")


class AwaitableGetSecurityAssessmentFindingAnalyticsResult(GetSecurityAssessmentFindingAnalyticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAssessmentFindingAnalyticsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            finding_analytics_collections=self.finding_analytics_collections,
            finding_key=self.finding_key,
            group_by=self.group_by,
            id=self.id,
            is_top_finding=self.is_top_finding,
            severity=self.severity,
            top_finding_status=self.top_finding_status)


def get_security_assessment_finding_analytics(access_level: Optional[str] = None,
                                              compartment_id: Optional[str] = None,
                                              compartment_id_in_subtree: Optional[bool] = None,
                                              filters: Optional[Sequence[pulumi.InputType['GetSecurityAssessmentFindingAnalyticsFilterArgs']]] = None,
                                              finding_key: Optional[str] = None,
                                              group_by: Optional[str] = None,
                                              is_top_finding: Optional[bool] = None,
                                              severity: Optional[str] = None,
                                              top_finding_status: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAssessmentFindingAnalyticsResult:
    """
    This data source provides the list of Security Assessment Finding Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of findings aggregated details in the specified compartment. This provides information about the overall state
    of security assessment findings. You can use groupBy to get the count of findings under a certain risk level and with a certain findingKey,
    and as well as get the list of the targets that match the condition.
    This data is especially useful content for the statistic chart or to support analytics.

    When you perform the ListFindingAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns statistics from the compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_finding_analytics = oci.DataSafe.get_security_assessment_finding_analytics(compartment_id=compartment_id,
        access_level=security_assessment_finding_analytic_access_level,
        compartment_id_in_subtree=security_assessment_finding_analytic_compartment_id_in_subtree,
        finding_key=security_assessment_finding_analytic_finding_key,
        group_by=security_assessment_finding_analytic_group_by,
        is_top_finding=security_assessment_finding_analytic_is_top_finding,
        severity=security_assessment_finding_analytic_severity,
        top_finding_status=security_assessment_finding_analytic_top_finding_status)
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str finding_key: The unique key that identifies the finding. It is a string and unique within a security assessment.
    :param str group_by: Attribute by which the finding analytics data should be grouped.
    :param bool is_top_finding: A filter to return only the findings that are marked as top findings.
    :param str severity: A filter to return only findings of a particular risk level.
    :param str top_finding_status: An optional filter to return only the top finding that match the specified status.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['findingKey'] = finding_key
    __args__['groupBy'] = group_by
    __args__['isTopFinding'] = is_top_finding
    __args__['severity'] = severity
    __args__['topFindingStatus'] = top_finding_status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityAssessmentFindingAnalytics:getSecurityAssessmentFindingAnalytics', __args__, opts=opts, typ=GetSecurityAssessmentFindingAnalyticsResult).value

    return AwaitableGetSecurityAssessmentFindingAnalyticsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        finding_analytics_collections=pulumi.get(__ret__, 'finding_analytics_collections'),
        finding_key=pulumi.get(__ret__, 'finding_key'),
        group_by=pulumi.get(__ret__, 'group_by'),
        id=pulumi.get(__ret__, 'id'),
        is_top_finding=pulumi.get(__ret__, 'is_top_finding'),
        severity=pulumi.get(__ret__, 'severity'),
        top_finding_status=pulumi.get(__ret__, 'top_finding_status'))


@_utilities.lift_output_func(get_security_assessment_finding_analytics)
def get_security_assessment_finding_analytics_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                                     compartment_id: Optional[pulumi.Input[str]] = None,
                                                     compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSecurityAssessmentFindingAnalyticsFilterArgs']]]]] = None,
                                                     finding_key: Optional[pulumi.Input[Optional[str]]] = None,
                                                     group_by: Optional[pulumi.Input[Optional[str]]] = None,
                                                     is_top_finding: Optional[pulumi.Input[Optional[bool]]] = None,
                                                     severity: Optional[pulumi.Input[Optional[str]]] = None,
                                                     top_finding_status: Optional[pulumi.Input[Optional[str]]] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityAssessmentFindingAnalyticsResult]:
    """
    This data source provides the list of Security Assessment Finding Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of findings aggregated details in the specified compartment. This provides information about the overall state
    of security assessment findings. You can use groupBy to get the count of findings under a certain risk level and with a certain findingKey,
    and as well as get the list of the targets that match the condition.
    This data is especially useful content for the statistic chart or to support analytics.

    When you perform the ListFindingAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns statistics from the compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_finding_analytics = oci.DataSafe.get_security_assessment_finding_analytics(compartment_id=compartment_id,
        access_level=security_assessment_finding_analytic_access_level,
        compartment_id_in_subtree=security_assessment_finding_analytic_compartment_id_in_subtree,
        finding_key=security_assessment_finding_analytic_finding_key,
        group_by=security_assessment_finding_analytic_group_by,
        is_top_finding=security_assessment_finding_analytic_is_top_finding,
        severity=security_assessment_finding_analytic_severity,
        top_finding_status=security_assessment_finding_analytic_top_finding_status)
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str finding_key: The unique key that identifies the finding. It is a string and unique within a security assessment.
    :param str group_by: Attribute by which the finding analytics data should be grouped.
    :param bool is_top_finding: A filter to return only the findings that are marked as top findings.
    :param str severity: A filter to return only findings of a particular risk level.
    :param str top_finding_status: An optional filter to return only the top finding that match the specified status.
    """
    ...
