# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTargetDatabaseResult',
    'AwaitableGetTargetDatabaseResult',
    'get_target_database',
    'get_target_database_output',
]

@pulumi.output_type
class GetTargetDatabaseResult:
    """
    A collection of values returned by getTargetDatabase.
    """
    def __init__(__self__, associated_resource_ids=None, compartment_id=None, connection_options=None, credentials=None, database_details=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, peer_target_database_details=None, peer_target_databases=None, state=None, system_tags=None, target_database_id=None, time_created=None, time_updated=None, tls_configs=None):
        if associated_resource_ids and not isinstance(associated_resource_ids, list):
            raise TypeError("Expected argument 'associated_resource_ids' to be a list")
        pulumi.set(__self__, "associated_resource_ids", associated_resource_ids)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_options and not isinstance(connection_options, list):
            raise TypeError("Expected argument 'connection_options' to be a list")
        pulumi.set(__self__, "connection_options", connection_options)
        if credentials and not isinstance(credentials, list):
            raise TypeError("Expected argument 'credentials' to be a list")
        pulumi.set(__self__, "credentials", credentials)
        if database_details and not isinstance(database_details, list):
            raise TypeError("Expected argument 'database_details' to be a list")
        pulumi.set(__self__, "database_details", database_details)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if peer_target_database_details and not isinstance(peer_target_database_details, list):
            raise TypeError("Expected argument 'peer_target_database_details' to be a list")
        pulumi.set(__self__, "peer_target_database_details", peer_target_database_details)
        if peer_target_databases and not isinstance(peer_target_databases, list):
            raise TypeError("Expected argument 'peer_target_databases' to be a list")
        pulumi.set(__self__, "peer_target_databases", peer_target_databases)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_database_id and not isinstance(target_database_id, str):
            raise TypeError("Expected argument 'target_database_id' to be a str")
        pulumi.set(__self__, "target_database_id", target_database_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if tls_configs and not isinstance(tls_configs, list):
            raise TypeError("Expected argument 'tls_configs' to be a list")
        pulumi.set(__self__, "tls_configs", tls_configs)

    @property
    @pulumi.getter(name="associatedResourceIds")
    def associated_resource_ids(self) -> Sequence[str]:
        """
        The OCIDs of associated resources like database, Data Safe private endpoint etc.
        """
        return pulumi.get(self, "associated_resource_ids")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment which contains the Data Safe target database.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionOptions")
    def connection_options(self) -> Sequence['outputs.GetTargetDatabaseConnectionOptionResult']:
        """
        Types of connection supported by Data Safe.
        """
        return pulumi.get(self, "connection_options")

    @property
    @pulumi.getter
    def credentials(self) -> Sequence['outputs.GetTargetDatabaseCredentialResult']:
        """
        The database credentials required for Data Safe to connect to the database.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="databaseDetails")
    def database_details(self) -> Sequence['outputs.GetTargetDatabaseDatabaseDetailResult']:
        """
        Details of the database for the registration in Data Safe.
        """
        return pulumi.get(self, "database_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the peer target database in Data Safe.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the peer target database in Data Safe.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the Data Safe target database.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the current state of the peer target database in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="peerTargetDatabaseDetails")
    def peer_target_database_details(self) -> Sequence['outputs.GetTargetDatabasePeerTargetDatabaseDetailResult']:
        return pulumi.get(self, "peer_target_database_details")

    @property
    @pulumi.getter(name="peerTargetDatabases")
    def peer_target_databases(self) -> Sequence['outputs.GetTargetDatabasePeerTargetDatabaseResult']:
        """
        The OCIDs of associated resources like Database, Data Safe private endpoint etc.
        """
        return pulumi.get(self, "peer_target_databases")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the target database in Data Safe.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetDatabaseId")
    def target_database_id(self) -> str:
        return pulumi.get(self, "target_database_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the database was registered in Data Safe and created as a target database in Data Safe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time of the target database update in Data Safe.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="tlsConfigs")
    def tls_configs(self) -> Sequence['outputs.GetTargetDatabaseTlsConfigResult']:
        """
        The details required to establish a TLS enabled connection.
        """
        return pulumi.get(self, "tls_configs")


class AwaitableGetTargetDatabaseResult(GetTargetDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetDatabaseResult(
            associated_resource_ids=self.associated_resource_ids,
            compartment_id=self.compartment_id,
            connection_options=self.connection_options,
            credentials=self.credentials,
            database_details=self.database_details,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            peer_target_database_details=self.peer_target_database_details,
            peer_target_databases=self.peer_target_databases,
            state=self.state,
            system_tags=self.system_tags,
            target_database_id=self.target_database_id,
            time_created=self.time_created,
            time_updated=self.time_updated,
            tls_configs=self.tls_configs)


def get_target_database(target_database_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetDatabaseResult:
    """
    This data source provides details about a specific Target Database resource in Oracle Cloud Infrastructure Data Safe service.

    Returns the details of the specified Data Safe target database.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_database = oci.DataSafe.get_target_database(target_database_id=test_target_database_oci_data_safe_target_database["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str target_database_id: The OCID of the Data Safe target database.
    """
    __args__ = dict()
    __args__['targetDatabaseId'] = target_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getTargetDatabase:getTargetDatabase', __args__, opts=opts, typ=GetTargetDatabaseResult).value

    return AwaitableGetTargetDatabaseResult(
        associated_resource_ids=pulumi.get(__ret__, 'associated_resource_ids'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_options=pulumi.get(__ret__, 'connection_options'),
        credentials=pulumi.get(__ret__, 'credentials'),
        database_details=pulumi.get(__ret__, 'database_details'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        peer_target_database_details=pulumi.get(__ret__, 'peer_target_database_details'),
        peer_target_databases=pulumi.get(__ret__, 'peer_target_databases'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_database_id=pulumi.get(__ret__, 'target_database_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        tls_configs=pulumi.get(__ret__, 'tls_configs'))


@_utilities.lift_output_func(get_target_database)
def get_target_database_output(target_database_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTargetDatabaseResult]:
    """
    This data source provides details about a specific Target Database resource in Oracle Cloud Infrastructure Data Safe service.

    Returns the details of the specified Data Safe target database.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_database = oci.DataSafe.get_target_database(target_database_id=test_target_database_oci_data_safe_target_database["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str target_database_id: The OCID of the Data Safe target database.
    """
    ...
