# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUserAssessmentProfileAnalyticsResult',
    'AwaitableGetUserAssessmentProfileAnalyticsResult',
    'get_user_assessment_profile_analytics',
    'get_user_assessment_profile_analytics_output',
]

@pulumi.output_type
class GetUserAssessmentProfileAnalyticsResult:
    """
    A collection of values returned by getUserAssessmentProfileAnalytics.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, profile_aggregations=None, profile_name=None, target_id=None, user_assessment_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if profile_aggregations and not isinstance(profile_aggregations, list):
            raise TypeError("Expected argument 'profile_aggregations' to be a list")
        pulumi.set(__self__, "profile_aggregations", profile_aggregations)
        if profile_name and not isinstance(profile_name, str):
            raise TypeError("Expected argument 'profile_name' to be a str")
        pulumi.set(__self__, "profile_name", profile_name)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if user_assessment_id and not isinstance(user_assessment_id, str):
            raise TypeError("Expected argument 'user_assessment_id' to be a str")
        pulumi.set(__self__, "user_assessment_id", user_assessment_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUserAssessmentProfileAnalyticsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="profileAggregations")
    def profile_aggregations(self) -> Sequence['outputs.GetUserAssessmentProfileAnalyticsProfileAggregationResult']:
        """
        The list of profile_aggregations.
        """
        return pulumi.get(self, "profile_aggregations")

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[str]:
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="userAssessmentId")
    def user_assessment_id(self) -> str:
        return pulumi.get(self, "user_assessment_id")


class AwaitableGetUserAssessmentProfileAnalyticsResult(GetUserAssessmentProfileAnalyticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserAssessmentProfileAnalyticsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            profile_aggregations=self.profile_aggregations,
            profile_name=self.profile_name,
            target_id=self.target_id,
            user_assessment_id=self.user_assessment_id)


def get_user_assessment_profile_analytics(access_level: Optional[str] = None,
                                          compartment_id: Optional[str] = None,
                                          compartment_id_in_subtree: Optional[bool] = None,
                                          filters: Optional[Sequence[pulumi.InputType['GetUserAssessmentProfileAnalyticsFilterArgs']]] = None,
                                          profile_name: Optional[str] = None,
                                          target_id: Optional[str] = None,
                                          user_assessment_id: Optional[str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserAssessmentProfileAnalyticsResult:
    """
    This data source provides the list of User Assessment Profile Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of aggregated user profile details in the specified compartment. This provides information about the
    overall profiles available. For example, the user profile details include how many users have the profile assigned
    and do how many use password verification function. This data is especially useful content for dashboards or to support analytics.

    When you perform the ListProfileAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    The parameter compartmentIdInSubtree applies when you perform ListProfileAnalytics on the compartmentId passed and when it is
    set to true, the entire hierarchy of compartments can be returned.

    To use ListProfileAnalytics to get a full list of all compartments and subcompartments in the tenancy from the root compartment,
    set the parameter compartmentIdInSubtree to true and accessLevel to ACCESSIBLE.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessment_profile_analytics = oci.DataSafe.get_user_assessment_profile_analytics(compartment_id=compartment_id,
        user_assessment_id=test_user_assessment["id"],
        access_level=user_assessment_profile_analytic_access_level,
        compartment_id_in_subtree=user_assessment_profile_analytic_compartment_id_in_subtree,
        profile_name=test_profile["name"],
        target_id=test_target["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str profile_name: A filter to return only items that match the specified profile name.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str user_assessment_id: The OCID of the user assessment.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['profileName'] = profile_name
    __args__['targetId'] = target_id
    __args__['userAssessmentId'] = user_assessment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getUserAssessmentProfileAnalytics:getUserAssessmentProfileAnalytics', __args__, opts=opts, typ=GetUserAssessmentProfileAnalyticsResult).value

    return AwaitableGetUserAssessmentProfileAnalyticsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        profile_aggregations=pulumi.get(__ret__, 'profile_aggregations'),
        profile_name=pulumi.get(__ret__, 'profile_name'),
        target_id=pulumi.get(__ret__, 'target_id'),
        user_assessment_id=pulumi.get(__ret__, 'user_assessment_id'))


@_utilities.lift_output_func(get_user_assessment_profile_analytics)
def get_user_assessment_profile_analytics_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                                 compartment_id: Optional[pulumi.Input[str]] = None,
                                                 compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetUserAssessmentProfileAnalyticsFilterArgs']]]]] = None,
                                                 profile_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                 target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                 user_assessment_id: Optional[pulumi.Input[str]] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserAssessmentProfileAnalyticsResult]:
    """
    This data source provides the list of User Assessment Profile Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of aggregated user profile details in the specified compartment. This provides information about the
    overall profiles available. For example, the user profile details include how many users have the profile assigned
    and do how many use password verification function. This data is especially useful content for dashboards or to support analytics.

    When you perform the ListProfileAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    The parameter compartmentIdInSubtree applies when you perform ListProfileAnalytics on the compartmentId passed and when it is
    set to true, the entire hierarchy of compartments can be returned.

    To use ListProfileAnalytics to get a full list of all compartments and subcompartments in the tenancy from the root compartment,
    set the parameter compartmentIdInSubtree to true and accessLevel to ACCESSIBLE.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_user_assessment_profile_analytics = oci.DataSafe.get_user_assessment_profile_analytics(compartment_id=compartment_id,
        user_assessment_id=test_user_assessment["id"],
        access_level=user_assessment_profile_analytic_access_level,
        compartment_id_in_subtree=user_assessment_profile_analytic_compartment_id_in_subtree,
        profile_name=test_profile["name"],
        target_id=test_target["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str profile_name: A filter to return only items that match the specified profile name.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str user_assessment_id: The OCID of the user assessment.
    """
    ...
