# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReportDefinitionArgs', 'ReportDefinition']

@pulumi.input_type
class ReportDefinitionArgs:
    def __init__(__self__, *,
                 column_filters: pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnFilterArgs']]],
                 column_infos: pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnInfoArgs']]],
                 column_sortings: pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnSortingArgs']]],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 parent_id: pulumi.Input[str],
                 summaries: pulumi.Input[Sequence[pulumi.Input['ReportDefinitionSummaryArgs']]],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ReportDefinition resource.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnFilterArgs']]] column_filters: (Updatable) An array of column filter objects. A column Filter object stores all information about a column filter including field name, an operator, one or more expressions, if the filter is enabled, or if the filter is hidden.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnInfoArgs']]] column_infos: (Updatable) An array of column objects in the order (left to right) displayed in the report. A column object stores all information about a column, including the name displayed on the UI, corresponding field name in the data source, data type of the column, and column visibility (if the column is visible to the user).
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnSortingArgs']]] column_sortings: (Updatable) An array of column sorting objects. Each column sorting object stores the column name to be sorted and if the sorting is in ascending order; sorting is done by the first column in the array, then by the second column in the array, etc.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the report definition.
        :param pulumi.Input[str] display_name: (Updatable) Specifies the name of the report definition.
        :param pulumi.Input[str] parent_id: The OCID of the parent report definition.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionSummaryArgs']]] summaries: (Updatable) An array of report summary objects in the order (left to right)  displayed in the report.  A  report summary object stores all information about summary of report to be displayed, including the name displayed on UI, the display order, corresponding group by and count of values, summary visibility (if the summary is visible to user).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the report definition.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "column_filters", column_filters)
        pulumi.set(__self__, "column_infos", column_infos)
        pulumi.set(__self__, "column_sortings", column_sortings)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "parent_id", parent_id)
        pulumi.set(__self__, "summaries", summaries)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="columnFilters")
    def column_filters(self) -> pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnFilterArgs']]]:
        """
        (Updatable) An array of column filter objects. A column Filter object stores all information about a column filter including field name, an operator, one or more expressions, if the filter is enabled, or if the filter is hidden.
        """
        return pulumi.get(self, "column_filters")

    @column_filters.setter
    def column_filters(self, value: pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnFilterArgs']]]):
        pulumi.set(self, "column_filters", value)

    @property
    @pulumi.getter(name="columnInfos")
    def column_infos(self) -> pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnInfoArgs']]]:
        """
        (Updatable) An array of column objects in the order (left to right) displayed in the report. A column object stores all information about a column, including the name displayed on the UI, corresponding field name in the data source, data type of the column, and column visibility (if the column is visible to the user).
        """
        return pulumi.get(self, "column_infos")

    @column_infos.setter
    def column_infos(self, value: pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnInfoArgs']]]):
        pulumi.set(self, "column_infos", value)

    @property
    @pulumi.getter(name="columnSortings")
    def column_sortings(self) -> pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnSortingArgs']]]:
        """
        (Updatable) An array of column sorting objects. Each column sorting object stores the column name to be sorted and if the sorting is in ascending order; sorting is done by the first column in the array, then by the second column in the array, etc.
        """
        return pulumi.get(self, "column_sortings")

    @column_sortings.setter
    def column_sortings(self, value: pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnSortingArgs']]]):
        pulumi.set(self, "column_sortings", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment containing the report definition.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Specifies the name of the report definition.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Input[str]:
        """
        The OCID of the parent report definition.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter
    def summaries(self) -> pulumi.Input[Sequence[pulumi.Input['ReportDefinitionSummaryArgs']]]:
        """
        (Updatable) An array of report summary objects in the order (left to right)  displayed in the report.  A  report summary object stores all information about summary of report to be displayed, including the name displayed on UI, the display order, corresponding group by and count of values, summary visibility (if the summary is visible to user).
        """
        return pulumi.get(self, "summaries")

    @summaries.setter
    def summaries(self, value: pulumi.Input[Sequence[pulumi.Input['ReportDefinitionSummaryArgs']]]):
        pulumi.set(self, "summaries", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the report definition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ReportDefinitionState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 column_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnFilterArgs']]]] = None,
                 column_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnInfoArgs']]]] = None,
                 column_sortings: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnSortingArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compliance_standards: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_source: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 display_order: Optional[pulumi.Input[int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_seeded: Optional[pulumi.Input[bool]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 record_time_span: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 scheduled_report_compartment_id: Optional[pulumi.Input[str]] = None,
                 scheduled_report_mime_type: Optional[pulumi.Input[str]] = None,
                 scheduled_report_name: Optional[pulumi.Input[str]] = None,
                 scheduled_report_row_limit: Optional[pulumi.Input[int]] = None,
                 scim_filter: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 summaries: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionSummaryArgs']]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ReportDefinition resources.
        :param pulumi.Input[str] category: Specifies the name of the category that this report belongs to.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnFilterArgs']]] column_filters: (Updatable) An array of column filter objects. A column Filter object stores all information about a column filter including field name, an operator, one or more expressions, if the filter is enabled, or if the filter is hidden.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnInfoArgs']]] column_infos: (Updatable) An array of column objects in the order (left to right) displayed in the report. A column object stores all information about a column, including the name displayed on the UI, corresponding field name in the data source, data type of the column, and column visibility (if the column is visible to the user).
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnSortingArgs']]] column_sortings: (Updatable) An array of column sorting objects. Each column sorting object stores the column name to be sorted and if the sorting is in ascending order; sorting is done by the first column in the array, then by the second column in the array, etc.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the report definition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_standards: The list of the data protection regulations/standards used in the report that will help demonstrate compliance.
        :param pulumi.Input[str] data_source: Specifies the name of a resource that provides data for the report. For example alerts, events.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the report definition.
        :param pulumi.Input[str] display_name: (Updatable) Specifies the name of the report definition.
        :param pulumi.Input[int] display_order: (Updatable) Specifies the order in which the summary must be displayed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_seeded: Signifies whether the definition is seeded or user defined. Values can either be 'true' or 'false'.
        :param pulumi.Input[str] parent_id: The OCID of the parent report definition.
        :param pulumi.Input[str] record_time_span: The time span for the records in the report to be scheduled. <period-value><period> Allowed period strings - "H","D","M","Y" Each of the above fields potentially introduce constraints. A workRequest is created only when period-value satisfies all the constraints. Constraints introduced: 1. period = H (The allowed range for period-value is [1, 23]) 2. period = D (The allowed range for period-value is [1, 30]) 3. period = M (The allowed range for period-value is [1, 11]) 4. period = Y (The minimum period-value is 1)
        :param pulumi.Input[str] schedule: The schedule to generate the report periodically in the specified format: <version-string>;<version-specific-schedule>
        :param pulumi.Input[str] scheduled_report_compartment_id: The OCID of the compartment in which the scheduled resource will be created.
        :param pulumi.Input[str] scheduled_report_mime_type: Specifies the format of the report ( either .xls or .pdf )
        :param pulumi.Input[str] scheduled_report_name: The name of the report to be scheduled.
        :param pulumi.Input[int] scheduled_report_row_limit: Specifies the limit on the number of rows in the report.
        :param pulumi.Input[str] scim_filter: (Updatable) Additional scim filters used to get the specific summary.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the report.
        :param pulumi.Input[Sequence[pulumi.Input['ReportDefinitionSummaryArgs']]] summaries: (Updatable) An array of report summary objects in the order (left to right)  displayed in the report.  A  report summary object stores all information about summary of report to be displayed, including the name displayed on UI, the display order, corresponding group by and count of values, summary visibility (if the summary is visible to user).
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Specifies the date and time the report definition was created.
        :param pulumi.Input[str] time_updated: The date and time the report definition was updated.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if column_filters is not None:
            pulumi.set(__self__, "column_filters", column_filters)
        if column_infos is not None:
            pulumi.set(__self__, "column_infos", column_infos)
        if column_sortings is not None:
            pulumi.set(__self__, "column_sortings", column_sortings)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compliance_standards is not None:
            pulumi.set(__self__, "compliance_standards", compliance_standards)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if display_order is not None:
            pulumi.set(__self__, "display_order", display_order)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_seeded is not None:
            pulumi.set(__self__, "is_seeded", is_seeded)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if record_time_span is not None:
            pulumi.set(__self__, "record_time_span", record_time_span)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if scheduled_report_compartment_id is not None:
            pulumi.set(__self__, "scheduled_report_compartment_id", scheduled_report_compartment_id)
        if scheduled_report_mime_type is not None:
            pulumi.set(__self__, "scheduled_report_mime_type", scheduled_report_mime_type)
        if scheduled_report_name is not None:
            pulumi.set(__self__, "scheduled_report_name", scheduled_report_name)
        if scheduled_report_row_limit is not None:
            pulumi.set(__self__, "scheduled_report_row_limit", scheduled_report_row_limit)
        if scim_filter is not None:
            pulumi.set(__self__, "scim_filter", scim_filter)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if summaries is not None:
            pulumi.set(__self__, "summaries", summaries)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the category that this report belongs to.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="columnFilters")
    def column_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnFilterArgs']]]]:
        """
        (Updatable) An array of column filter objects. A column Filter object stores all information about a column filter including field name, an operator, one or more expressions, if the filter is enabled, or if the filter is hidden.
        """
        return pulumi.get(self, "column_filters")

    @column_filters.setter
    def column_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnFilterArgs']]]]):
        pulumi.set(self, "column_filters", value)

    @property
    @pulumi.getter(name="columnInfos")
    def column_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnInfoArgs']]]]:
        """
        (Updatable) An array of column objects in the order (left to right) displayed in the report. A column object stores all information about a column, including the name displayed on the UI, corresponding field name in the data source, data type of the column, and column visibility (if the column is visible to the user).
        """
        return pulumi.get(self, "column_infos")

    @column_infos.setter
    def column_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnInfoArgs']]]]):
        pulumi.set(self, "column_infos", value)

    @property
    @pulumi.getter(name="columnSortings")
    def column_sortings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnSortingArgs']]]]:
        """
        (Updatable) An array of column sorting objects. Each column sorting object stores the column name to be sorted and if the sorting is in ascending order; sorting is done by the first column in the array, then by the second column in the array, etc.
        """
        return pulumi.get(self, "column_sortings")

    @column_sortings.setter
    def column_sortings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionColumnSortingArgs']]]]):
        pulumi.set(self, "column_sortings", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment containing the report definition.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="complianceStandards")
    def compliance_standards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the data protection regulations/standards used in the report that will help demonstrate compliance.
        """
        return pulumi.get(self, "compliance_standards")

    @compliance_standards.setter
    def compliance_standards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compliance_standards", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a resource that provides data for the report. For example alerts, events.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the report definition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the name of the report definition.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="displayOrder")
    def display_order(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Specifies the order in which the summary must be displayed.
        """
        return pulumi.get(self, "display_order")

    @display_order.setter
    def display_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "display_order", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> Optional[pulumi.Input[bool]]:
        """
        Signifies whether the definition is seeded or user defined. Values can either be 'true' or 'false'.
        """
        return pulumi.get(self, "is_seeded")

    @is_seeded.setter
    def is_seeded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_seeded", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the parent report definition.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="recordTimeSpan")
    def record_time_span(self) -> Optional[pulumi.Input[str]]:
        """
        The time span for the records in the report to be scheduled. <period-value><period> Allowed period strings - "H","D","M","Y" Each of the above fields potentially introduce constraints. A workRequest is created only when period-value satisfies all the constraints. Constraints introduced: 1. period = H (The allowed range for period-value is [1, 23]) 2. period = D (The allowed range for period-value is [1, 30]) 3. period = M (The allowed range for period-value is [1, 11]) 4. period = Y (The minimum period-value is 1)
        """
        return pulumi.get(self, "record_time_span")

    @record_time_span.setter
    def record_time_span(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record_time_span", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        The schedule to generate the report periodically in the specified format: <version-string>;<version-specific-schedule>
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="scheduledReportCompartmentId")
    def scheduled_report_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment in which the scheduled resource will be created.
        """
        return pulumi.get(self, "scheduled_report_compartment_id")

    @scheduled_report_compartment_id.setter
    def scheduled_report_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_report_compartment_id", value)

    @property
    @pulumi.getter(name="scheduledReportMimeType")
    def scheduled_report_mime_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the format of the report ( either .xls or .pdf )
        """
        return pulumi.get(self, "scheduled_report_mime_type")

    @scheduled_report_mime_type.setter
    def scheduled_report_mime_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_report_mime_type", value)

    @property
    @pulumi.getter(name="scheduledReportName")
    def scheduled_report_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the report to be scheduled.
        """
        return pulumi.get(self, "scheduled_report_name")

    @scheduled_report_name.setter
    def scheduled_report_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_report_name", value)

    @property
    @pulumi.getter(name="scheduledReportRowLimit")
    def scheduled_report_row_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the limit on the number of rows in the report.
        """
        return pulumi.get(self, "scheduled_report_row_limit")

    @scheduled_report_row_limit.setter
    def scheduled_report_row_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scheduled_report_row_limit", value)

    @property
    @pulumi.getter(name="scimFilter")
    def scim_filter(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Additional scim filters used to get the specific summary.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scim_filter")

    @scim_filter.setter
    def scim_filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scim_filter", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the report.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionSummaryArgs']]]]:
        """
        (Updatable) An array of report summary objects in the order (left to right)  displayed in the report.  A  report summary object stores all information about summary of report to be displayed, including the name displayed on UI, the display order, corresponding group by and count of values, summary visibility (if the summary is visible to user).
        """
        return pulumi.get(self, "summaries")

    @summaries.setter
    def summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReportDefinitionSummaryArgs']]]]):
        pulumi.set(self, "summaries", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the date and time the report definition was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the report definition was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class ReportDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnFilterArgs']]]]] = None,
                 column_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnInfoArgs']]]]] = None,
                 column_sortings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnSortingArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 summaries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionSummaryArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Report Definition resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new report definition with parameters specified in the body. The report definition is stored in the specified compartment.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_report_definition = oci.data_safe.ReportDefinition("test_report_definition",
            column_filters=[oci.data_safe.ReportDefinitionColumnFilterArgs(
                expressions=report_definition_column_filters_expressions,
                field_name=report_definition_column_filters_field_name,
                is_enabled=report_definition_column_filters_is_enabled,
                is_hidden=report_definition_column_filters_is_hidden,
                operator=report_definition_column_filters_operator,
            )],
            column_infos=[oci.data_safe.ReportDefinitionColumnInfoArgs(
                display_name=report_definition_column_info_display_name,
                display_order=report_definition_column_info_display_order,
                field_name=report_definition_column_info_field_name,
                is_hidden=report_definition_column_info_is_hidden,
                data_type=report_definition_column_info_data_type,
            )],
            column_sortings=[oci.data_safe.ReportDefinitionColumnSortingArgs(
                field_name=report_definition_column_sortings_field_name,
                is_ascending=report_definition_column_sortings_is_ascending,
                sorting_order=report_definition_column_sortings_sorting_order,
            )],
            compartment_id=compartment_id,
            display_name=report_definition_display_name,
            parent_id=test_parent["id"],
            summaries=[oci.data_safe.ReportDefinitionSummaryArgs(
                display_order=report_definition_summary_display_order,
                name=report_definition_summary_name,
                count_of=report_definition_summary_count_of,
                group_by_field_name=report_definition_summary_group_by_field_name,
                is_hidden=report_definition_summary_is_hidden,
                scim_filter=report_definition_summary_scim_filter,
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=report_definition_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ReportDefinitions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/reportDefinition:ReportDefinition test_report_definition "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnFilterArgs']]]] column_filters: (Updatable) An array of column filter objects. A column Filter object stores all information about a column filter including field name, an operator, one or more expressions, if the filter is enabled, or if the filter is hidden.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnInfoArgs']]]] column_infos: (Updatable) An array of column objects in the order (left to right) displayed in the report. A column object stores all information about a column, including the name displayed on the UI, corresponding field name in the data source, data type of the column, and column visibility (if the column is visible to the user).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnSortingArgs']]]] column_sortings: (Updatable) An array of column sorting objects. Each column sorting object stores the column name to be sorted and if the sorting is in ascending order; sorting is done by the first column in the array, then by the second column in the array, etc.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the report definition.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the report definition.
        :param pulumi.Input[str] display_name: (Updatable) Specifies the name of the report definition.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] parent_id: The OCID of the parent report definition.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionSummaryArgs']]]] summaries: (Updatable) An array of report summary objects in the order (left to right)  displayed in the report.  A  report summary object stores all information about summary of report to be displayed, including the name displayed on UI, the display order, corresponding group by and count of values, summary visibility (if the summary is visible to user).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReportDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Report Definition resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new report definition with parameters specified in the body. The report definition is stored in the specified compartment.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_report_definition = oci.data_safe.ReportDefinition("test_report_definition",
            column_filters=[oci.data_safe.ReportDefinitionColumnFilterArgs(
                expressions=report_definition_column_filters_expressions,
                field_name=report_definition_column_filters_field_name,
                is_enabled=report_definition_column_filters_is_enabled,
                is_hidden=report_definition_column_filters_is_hidden,
                operator=report_definition_column_filters_operator,
            )],
            column_infos=[oci.data_safe.ReportDefinitionColumnInfoArgs(
                display_name=report_definition_column_info_display_name,
                display_order=report_definition_column_info_display_order,
                field_name=report_definition_column_info_field_name,
                is_hidden=report_definition_column_info_is_hidden,
                data_type=report_definition_column_info_data_type,
            )],
            column_sortings=[oci.data_safe.ReportDefinitionColumnSortingArgs(
                field_name=report_definition_column_sortings_field_name,
                is_ascending=report_definition_column_sortings_is_ascending,
                sorting_order=report_definition_column_sortings_sorting_order,
            )],
            compartment_id=compartment_id,
            display_name=report_definition_display_name,
            parent_id=test_parent["id"],
            summaries=[oci.data_safe.ReportDefinitionSummaryArgs(
                display_order=report_definition_summary_display_order,
                name=report_definition_summary_name,
                count_of=report_definition_summary_count_of,
                group_by_field_name=report_definition_summary_group_by_field_name,
                is_hidden=report_definition_summary_is_hidden,
                scim_filter=report_definition_summary_scim_filter,
            )],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=report_definition_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ReportDefinitions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/reportDefinition:ReportDefinition test_report_definition "id"
        ```

        :param str resource_name: The name of the resource.
        :param ReportDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReportDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnFilterArgs']]]]] = None,
                 column_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnInfoArgs']]]]] = None,
                 column_sortings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnSortingArgs']]]]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 summaries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionSummaryArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReportDefinitionArgs.__new__(ReportDefinitionArgs)

            if column_filters is None and not opts.urn:
                raise TypeError("Missing required property 'column_filters'")
            __props__.__dict__["column_filters"] = column_filters
            if column_infos is None and not opts.urn:
                raise TypeError("Missing required property 'column_infos'")
            __props__.__dict__["column_infos"] = column_infos
            if column_sortings is None and not opts.urn:
                raise TypeError("Missing required property 'column_sortings'")
            __props__.__dict__["column_sortings"] = column_sortings
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if parent_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_id'")
            __props__.__dict__["parent_id"] = parent_id
            if summaries is None and not opts.urn:
                raise TypeError("Missing required property 'summaries'")
            __props__.__dict__["summaries"] = summaries
            __props__.__dict__["category"] = None
            __props__.__dict__["compliance_standards"] = None
            __props__.__dict__["data_source"] = None
            __props__.__dict__["display_order"] = None
            __props__.__dict__["is_seeded"] = None
            __props__.__dict__["record_time_span"] = None
            __props__.__dict__["schedule"] = None
            __props__.__dict__["scheduled_report_compartment_id"] = None
            __props__.__dict__["scheduled_report_mime_type"] = None
            __props__.__dict__["scheduled_report_name"] = None
            __props__.__dict__["scheduled_report_row_limit"] = None
            __props__.__dict__["scim_filter"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ReportDefinition, __self__).__init__(
            'oci:DataSafe/reportDefinition:ReportDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[str]] = None,
            column_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnFilterArgs']]]]] = None,
            column_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnInfoArgs']]]]] = None,
            column_sortings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnSortingArgs']]]]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compliance_standards: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            data_source: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            display_order: Optional[pulumi.Input[int]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_seeded: Optional[pulumi.Input[bool]] = None,
            parent_id: Optional[pulumi.Input[str]] = None,
            record_time_span: Optional[pulumi.Input[str]] = None,
            schedule: Optional[pulumi.Input[str]] = None,
            scheduled_report_compartment_id: Optional[pulumi.Input[str]] = None,
            scheduled_report_mime_type: Optional[pulumi.Input[str]] = None,
            scheduled_report_name: Optional[pulumi.Input[str]] = None,
            scheduled_report_row_limit: Optional[pulumi.Input[int]] = None,
            scim_filter: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            summaries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionSummaryArgs']]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'ReportDefinition':
        """
        Get an existing ReportDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: Specifies the name of the category that this report belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnFilterArgs']]]] column_filters: (Updatable) An array of column filter objects. A column Filter object stores all information about a column filter including field name, an operator, one or more expressions, if the filter is enabled, or if the filter is hidden.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnInfoArgs']]]] column_infos: (Updatable) An array of column objects in the order (left to right) displayed in the report. A column object stores all information about a column, including the name displayed on the UI, corresponding field name in the data source, data type of the column, and column visibility (if the column is visible to the user).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionColumnSortingArgs']]]] column_sortings: (Updatable) An array of column sorting objects. Each column sorting object stores the column name to be sorted and if the sorting is in ascending order; sorting is done by the first column in the array, then by the second column in the array, etc.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the report definition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_standards: The list of the data protection regulations/standards used in the report that will help demonstrate compliance.
        :param pulumi.Input[str] data_source: Specifies the name of a resource that provides data for the report. For example alerts, events.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the report definition.
        :param pulumi.Input[str] display_name: (Updatable) Specifies the name of the report definition.
        :param pulumi.Input[int] display_order: (Updatable) Specifies the order in which the summary must be displayed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_seeded: Signifies whether the definition is seeded or user defined. Values can either be 'true' or 'false'.
        :param pulumi.Input[str] parent_id: The OCID of the parent report definition.
        :param pulumi.Input[str] record_time_span: The time span for the records in the report to be scheduled. <period-value><period> Allowed period strings - "H","D","M","Y" Each of the above fields potentially introduce constraints. A workRequest is created only when period-value satisfies all the constraints. Constraints introduced: 1. period = H (The allowed range for period-value is [1, 23]) 2. period = D (The allowed range for period-value is [1, 30]) 3. period = M (The allowed range for period-value is [1, 11]) 4. period = Y (The minimum period-value is 1)
        :param pulumi.Input[str] schedule: The schedule to generate the report periodically in the specified format: <version-string>;<version-specific-schedule>
        :param pulumi.Input[str] scheduled_report_compartment_id: The OCID of the compartment in which the scheduled resource will be created.
        :param pulumi.Input[str] scheduled_report_mime_type: Specifies the format of the report ( either .xls or .pdf )
        :param pulumi.Input[str] scheduled_report_name: The name of the report to be scheduled.
        :param pulumi.Input[int] scheduled_report_row_limit: Specifies the limit on the number of rows in the report.
        :param pulumi.Input[str] scim_filter: (Updatable) Additional scim filters used to get the specific summary.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the report.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReportDefinitionSummaryArgs']]]] summaries: (Updatable) An array of report summary objects in the order (left to right)  displayed in the report.  A  report summary object stores all information about summary of report to be displayed, including the name displayed on UI, the display order, corresponding group by and count of values, summary visibility (if the summary is visible to user).
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Specifies the date and time the report definition was created.
        :param pulumi.Input[str] time_updated: The date and time the report definition was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReportDefinitionState.__new__(_ReportDefinitionState)

        __props__.__dict__["category"] = category
        __props__.__dict__["column_filters"] = column_filters
        __props__.__dict__["column_infos"] = column_infos
        __props__.__dict__["column_sortings"] = column_sortings
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compliance_standards"] = compliance_standards
        __props__.__dict__["data_source"] = data_source
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["display_order"] = display_order
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_seeded"] = is_seeded
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["record_time_span"] = record_time_span
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["scheduled_report_compartment_id"] = scheduled_report_compartment_id
        __props__.__dict__["scheduled_report_mime_type"] = scheduled_report_mime_type
        __props__.__dict__["scheduled_report_name"] = scheduled_report_name
        __props__.__dict__["scheduled_report_row_limit"] = scheduled_report_row_limit
        __props__.__dict__["scim_filter"] = scim_filter
        __props__.__dict__["state"] = state
        __props__.__dict__["summaries"] = summaries
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ReportDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[str]:
        """
        Specifies the name of the category that this report belongs to.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="columnFilters")
    def column_filters(self) -> pulumi.Output[Sequence['outputs.ReportDefinitionColumnFilter']]:
        """
        (Updatable) An array of column filter objects. A column Filter object stores all information about a column filter including field name, an operator, one or more expressions, if the filter is enabled, or if the filter is hidden.
        """
        return pulumi.get(self, "column_filters")

    @property
    @pulumi.getter(name="columnInfos")
    def column_infos(self) -> pulumi.Output[Sequence['outputs.ReportDefinitionColumnInfo']]:
        """
        (Updatable) An array of column objects in the order (left to right) displayed in the report. A column object stores all information about a column, including the name displayed on the UI, corresponding field name in the data source, data type of the column, and column visibility (if the column is visible to the user).
        """
        return pulumi.get(self, "column_infos")

    @property
    @pulumi.getter(name="columnSortings")
    def column_sortings(self) -> pulumi.Output[Sequence['outputs.ReportDefinitionColumnSorting']]:
        """
        (Updatable) An array of column sorting objects. Each column sorting object stores the column name to be sorted and if the sorting is in ascending order; sorting is done by the first column in the array, then by the second column in the array, etc.
        """
        return pulumi.get(self, "column_sortings")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment containing the report definition.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="complianceStandards")
    def compliance_standards(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of the data protection regulations/standards used in the report that will help demonstrate compliance.
        """
        return pulumi.get(self, "compliance_standards")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output[str]:
        """
        Specifies the name of a resource that provides data for the report. For example alerts, events.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the report definition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Specifies the name of the report definition.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayOrder")
    def display_order(self) -> pulumi.Output[int]:
        """
        (Updatable) Specifies the order in which the summary must be displayed.
        """
        return pulumi.get(self, "display_order")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isSeeded")
    def is_seeded(self) -> pulumi.Output[bool]:
        """
        Signifies whether the definition is seeded or user defined. Values can either be 'true' or 'false'.
        """
        return pulumi.get(self, "is_seeded")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[str]:
        """
        The OCID of the parent report definition.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="recordTimeSpan")
    def record_time_span(self) -> pulumi.Output[str]:
        """
        The time span for the records in the report to be scheduled. <period-value><period> Allowed period strings - "H","D","M","Y" Each of the above fields potentially introduce constraints. A workRequest is created only when period-value satisfies all the constraints. Constraints introduced: 1. period = H (The allowed range for period-value is [1, 23]) 2. period = D (The allowed range for period-value is [1, 30]) 3. period = M (The allowed range for period-value is [1, 11]) 4. period = Y (The minimum period-value is 1)
        """
        return pulumi.get(self, "record_time_span")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[str]:
        """
        The schedule to generate the report periodically in the specified format: <version-string>;<version-specific-schedule>
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="scheduledReportCompartmentId")
    def scheduled_report_compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment in which the scheduled resource will be created.
        """
        return pulumi.get(self, "scheduled_report_compartment_id")

    @property
    @pulumi.getter(name="scheduledReportMimeType")
    def scheduled_report_mime_type(self) -> pulumi.Output[str]:
        """
        Specifies the format of the report ( either .xls or .pdf )
        """
        return pulumi.get(self, "scheduled_report_mime_type")

    @property
    @pulumi.getter(name="scheduledReportName")
    def scheduled_report_name(self) -> pulumi.Output[str]:
        """
        The name of the report to be scheduled.
        """
        return pulumi.get(self, "scheduled_report_name")

    @property
    @pulumi.getter(name="scheduledReportRowLimit")
    def scheduled_report_row_limit(self) -> pulumi.Output[int]:
        """
        Specifies the limit on the number of rows in the report.
        """
        return pulumi.get(self, "scheduled_report_row_limit")

    @property
    @pulumi.getter(name="scimFilter")
    def scim_filter(self) -> pulumi.Output[str]:
        """
        (Updatable) Additional scim filters used to get the specific summary.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "scim_filter")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def summaries(self) -> pulumi.Output[Sequence['outputs.ReportDefinitionSummary']]:
        """
        (Updatable) An array of report summary objects in the order (left to right)  displayed in the report.  A  report summary object stores all information about summary of report to be displayed, including the name displayed on UI, the display order, corresponding group by and count of values, summary visibility (if the summary is visible to user).
        """
        return pulumi.get(self, "summaries")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Specifies the date and time the report definition was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the report definition was updated.
        """
        return pulumi.get(self, "time_updated")

