# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 connection_type: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 access_token: Optional[pulumi.Input[str]] = None,
                 app_password: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tls_verify_config: Optional[pulumi.Input['ConnectionTlsVerifyConfigArgs']] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[str] connection_type: (Updatable) The type of connection.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[str] access_token: (Updatable) The OCID of personal access token saved in secret store.
        :param pulumi.Input[str] app_password: (Updatable) OCID of personal Bitbucket Cloud AppPassword saved in secret store
        :param pulumi.Input[str] base_url: (Updatable) The Base URL of the hosted BitbucketServer.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Optional description about the connection.
        :param pulumi.Input[str] display_name: (Updatable) Optional connection display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input['ConnectionTlsVerifyConfigArgs'] tls_verify_config: (Updatable) TLS configuration used by build service to verify TLS connection.
        :param pulumi.Input[str] username: (Updatable) Public Bitbucket Cloud Username in plain text(not more than 30 characters)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "project_id", project_id)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if app_password is not None:
            pulumi.set(__self__, "app_password", app_password)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if tls_verify_config is not None:
            pulumi.set(__self__, "tls_verify_config", tls_verify_config)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of connection.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of personal access token saved in secret store.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="appPassword")
    def app_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of personal Bitbucket Cloud AppPassword saved in secret store
        """
        return pulumi.get(self, "app_password")

    @app_password.setter
    def app_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_password", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Base URL of the hosted BitbucketServer.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional description about the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional connection display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="tlsVerifyConfig")
    def tls_verify_config(self) -> Optional[pulumi.Input['ConnectionTlsVerifyConfigArgs']]:
        """
        (Updatable) TLS configuration used by build service to verify TLS connection.
        """
        return pulumi.get(self, "tls_verify_config")

    @tls_verify_config.setter
    def tls_verify_config(self, value: Optional[pulumi.Input['ConnectionTlsVerifyConfigArgs']]):
        pulumi.set(self, "tls_verify_config", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Public Bitbucket Cloud Username in plain text(not more than 30 characters)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[str]] = None,
                 app_password: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 last_connection_validation_results: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionLastConnectionValidationResultArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 tls_verify_config: Optional[pulumi.Input['ConnectionTlsVerifyConfigArgs']] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[str] access_token: (Updatable) The OCID of personal access token saved in secret store.
        :param pulumi.Input[str] app_password: (Updatable) OCID of personal Bitbucket Cloud AppPassword saved in secret store
        :param pulumi.Input[str] base_url: (Updatable) The Base URL of the hosted BitbucketServer.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment containing the connection.
        :param pulumi.Input[str] connection_type: (Updatable) The type of connection.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Optional description about the connection.
        :param pulumi.Input[str] display_name: (Updatable) Optional connection display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionLastConnectionValidationResultArgs']]] last_connection_validation_results: The result of validating the credentials of a connection.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[str] state: The current state of the connection.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the connection was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: The time the connection was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input['ConnectionTlsVerifyConfigArgs'] tls_verify_config: (Updatable) TLS configuration used by build service to verify TLS connection.
        :param pulumi.Input[str] username: (Updatable) Public Bitbucket Cloud Username in plain text(not more than 30 characters)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if app_password is not None:
            pulumi.set(__self__, "app_password", app_password)
        if base_url is not None:
            pulumi.set(__self__, "base_url", base_url)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if last_connection_validation_results is not None:
            pulumi.set(__self__, "last_connection_validation_results", last_connection_validation_results)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if tls_verify_config is not None:
            pulumi.set(__self__, "tls_verify_config", tls_verify_config)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of personal access token saved in secret store.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="appPassword")
    def app_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) OCID of personal Bitbucket Cloud AppPassword saved in secret store
        """
        return pulumi.get(self, "app_password")

    @app_password.setter
    def app_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_password", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Base URL of the hosted BitbucketServer.
        """
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment containing the connection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of connection.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional description about the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional connection display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lastConnectionValidationResults")
    def last_connection_validation_results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionLastConnectionValidationResultArgs']]]]:
        """
        The result of validating the credentials of a connection.
        """
        return pulumi.get(self, "last_connection_validation_results")

    @last_connection_validation_results.setter
    def last_connection_validation_results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionLastConnectionValidationResultArgs']]]]):
        pulumi.set(self, "last_connection_validation_results", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the connection was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the connection was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="tlsVerifyConfig")
    def tls_verify_config(self) -> Optional[pulumi.Input['ConnectionTlsVerifyConfigArgs']]:
        """
        (Updatable) TLS configuration used by build service to verify TLS connection.
        """
        return pulumi.get(self, "tls_verify_config")

    @tls_verify_config.setter
    def tls_verify_config(self, value: Optional[pulumi.Input['ConnectionTlsVerifyConfigArgs']]):
        pulumi.set(self, "tls_verify_config", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Public Bitbucket Cloud Username in plain text(not more than 30 characters)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 app_password: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tls_verify_config: Optional[pulumi.Input[pulumi.InputType['ConnectionTlsVerifyConfigArgs']]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Connection resource in Oracle Cloud Infrastructure Devops service.

        Creates a new connection.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.dev_ops.Connection("test_connection",
            connection_type=connection_connection_type,
            project_id=test_project["id"],
            access_token=connection_access_token,
            app_password=connection_app_password,
            base_url=connection_base_url,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=connection_description,
            display_name=connection_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            tls_verify_config=oci.dev_ops.ConnectionTlsVerifyConfigArgs(
                ca_certificate_bundle_id=test_ca_certificate_bundle["id"],
                tls_verify_mode=connection_tls_verify_config_tls_verify_mode,
            ),
            username=connection_username)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/connection:Connection test_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: (Updatable) The OCID of personal access token saved in secret store.
        :param pulumi.Input[str] app_password: (Updatable) OCID of personal Bitbucket Cloud AppPassword saved in secret store
        :param pulumi.Input[str] base_url: (Updatable) The Base URL of the hosted BitbucketServer.
        :param pulumi.Input[str] connection_type: (Updatable) The type of connection.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Optional description about the connection.
        :param pulumi.Input[str] display_name: (Updatable) Optional connection display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[pulumi.InputType['ConnectionTlsVerifyConfigArgs']] tls_verify_config: (Updatable) TLS configuration used by build service to verify TLS connection.
        :param pulumi.Input[str] username: (Updatable) Public Bitbucket Cloud Username in plain text(not more than 30 characters)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Connection resource in Oracle Cloud Infrastructure Devops service.

        Creates a new connection.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.dev_ops.Connection("test_connection",
            connection_type=connection_connection_type,
            project_id=test_project["id"],
            access_token=connection_access_token,
            app_password=connection_app_password,
            base_url=connection_base_url,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=connection_description,
            display_name=connection_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            tls_verify_config=oci.dev_ops.ConnectionTlsVerifyConfigArgs(
                ca_certificate_bundle_id=test_ca_certificate_bundle["id"],
                tls_verify_mode=connection_tls_verify_config_tls_verify_mode,
            ),
            username=connection_username)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/connection:Connection test_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[str]] = None,
                 app_password: Optional[pulumi.Input[str]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tls_verify_config: Optional[pulumi.Input[pulumi.InputType['ConnectionTlsVerifyConfigArgs']]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["access_token"] = access_token
            __props__.__dict__["app_password"] = None if app_password is None else pulumi.Output.secret(app_password)
            __props__.__dict__["base_url"] = base_url
            if connection_type is None and not opts.urn:
                raise TypeError("Missing required property 'connection_type'")
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tls_verify_config"] = tls_verify_config
            __props__.__dict__["username"] = username
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["last_connection_validation_results"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["appPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Connection, __self__).__init__(
            'oci:DevOps/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[str]] = None,
            app_password: Optional[pulumi.Input[str]] = None,
            base_url: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connection_type: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            last_connection_validation_results: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionLastConnectionValidationResultArgs']]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            tls_verify_config: Optional[pulumi.Input[pulumi.InputType['ConnectionTlsVerifyConfigArgs']]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_token: (Updatable) The OCID of personal access token saved in secret store.
        :param pulumi.Input[str] app_password: (Updatable) OCID of personal Bitbucket Cloud AppPassword saved in secret store
        :param pulumi.Input[str] base_url: (Updatable) The Base URL of the hosted BitbucketServer.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment containing the connection.
        :param pulumi.Input[str] connection_type: (Updatable) The type of connection.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) Optional description about the connection.
        :param pulumi.Input[str] display_name: (Updatable) Optional connection display name. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionLastConnectionValidationResultArgs']]]] last_connection_validation_results: The result of validating the credentials of a connection.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[str] state: The current state of the connection.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the connection was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: The time the connection was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[pulumi.InputType['ConnectionTlsVerifyConfigArgs']] tls_verify_config: (Updatable) TLS configuration used by build service to verify TLS connection.
        :param pulumi.Input[str] username: (Updatable) Public Bitbucket Cloud Username in plain text(not more than 30 characters)
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["app_password"] = app_password
        __props__.__dict__["base_url"] = base_url
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["last_connection_validation_results"] = last_connection_validation_results
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["tls_verify_config"] = tls_verify_config
        __props__.__dict__["username"] = username
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of personal access token saved in secret store.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter(name="appPassword")
    def app_password(self) -> pulumi.Output[str]:
        """
        (Updatable) OCID of personal Bitbucket Cloud AppPassword saved in secret store
        """
        return pulumi.get(self, "app_password")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[str]:
        """
        (Updatable) The Base URL of the hosted BitbucketServer.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment containing the connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of connection.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Optional description about the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Optional connection display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lastConnectionValidationResults")
    def last_connection_validation_results(self) -> pulumi.Output[Sequence['outputs.ConnectionLastConnectionValidationResult']]:
        """
        The result of validating the credentials of a connection.
        """
        return pulumi.get(self, "last_connection_validation_results")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the connection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the connection was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the connection was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="tlsVerifyConfig")
    def tls_verify_config(self) -> pulumi.Output['outputs.ConnectionTlsVerifyConfig']:
        """
        (Updatable) TLS configuration used by build service to verify TLS connection.
        """
        return pulumi.get(self, "tls_verify_config")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        (Updatable) Public Bitbucket Cloud Username in plain text(not more than 30 characters)


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "username")

