# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSteeringPoliciesResult',
    'AwaitableGetSteeringPoliciesResult',
    'get_steering_policies',
    'get_steering_policies_output',
]

@pulumi.output_type
class GetSteeringPoliciesResult:
    """
    A collection of values returned by getSteeringPolicies.
    """
    def __init__(__self__, compartment_id=None, display_name=None, display_name_contains=None, filters=None, health_check_monitor_id=None, id=None, state=None, steering_policies=None, template=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if health_check_monitor_id and not isinstance(health_check_monitor_id, str):
            raise TypeError("Expected argument 'health_check_monitor_id' to be a str")
        pulumi.set(__self__, "health_check_monitor_id", health_check_monitor_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if steering_policies and not isinstance(steering_policies, list):
            raise TypeError("Expected argument 'steering_policies' to be a list")
        pulumi.set(__self__, "steering_policies", steering_policies)
        if template and not isinstance(template, str):
            raise TypeError("Expected argument 'template' to be a str")
        pulumi.set(__self__, "template", template)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the steering policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name for the steering policy. Does not have to be unique and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSteeringPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="healthCheckMonitorId")
    def health_check_monitor_id(self) -> Optional[str]:
        """
        The OCID of the health check monitor providing health data about the answers of the steering policy. A steering policy answer with `rdata` matching a monitored endpoint will use the health data of that endpoint. A steering policy answer with `rdata` not matching any monitored endpoint will be assumed healthy.
        """
        return pulumi.get(self, "health_check_monitor_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="steeringPolicies")
    def steering_policies(self) -> Sequence['outputs.GetSteeringPoliciesSteeringPolicyResult']:
        """
        The list of steering_policies.
        """
        return pulumi.get(self, "steering_policies")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        A set of predefined rules based on the desired purpose of the steering policy. Each template utilizes Traffic Management's rules in a different order to produce the desired results when answering DNS queries.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetSteeringPoliciesResult(GetSteeringPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSteeringPoliciesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            health_check_monitor_id=self.health_check_monitor_id,
            id=self.id,
            state=self.state,
            steering_policies=self.steering_policies,
            template=self.template,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_steering_policies(compartment_id: Optional[str] = None,
                          display_name: Optional[str] = None,
                          display_name_contains: Optional[str] = None,
                          filters: Optional[Sequence[pulumi.InputType['GetSteeringPoliciesFilterArgs']]] = None,
                          health_check_monitor_id: Optional[str] = None,
                          id: Optional[str] = None,
                          state: Optional[str] = None,
                          template: Optional[str] = None,
                          time_created_greater_than_or_equal_to: Optional[str] = None,
                          time_created_less_than: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSteeringPoliciesResult:
    """
    This data source provides the list of Steering Policies in Oracle Cloud Infrastructure DNS service.

    Gets a list of all steering policies in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_steering_policies = oci.Dns.get_steering_policies(compartment_id=compartment_id,
        display_name=steering_policy_display_name,
        display_name_contains=steering_policy_display_name_contains,
        health_check_monitor_id=test_http_monitor["id"],
        id=steering_policy_id,
        state=steering_policy_state,
        template=steering_policy_template,
        time_created_greater_than_or_equal_to=steering_policy_time_created_greater_than_or_equal_to,
        time_created_less_than=steering_policy_time_created_less_than)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment the resource belongs to.
    :param str display_name: The displayName of a resource.
    :param str display_name_contains: The partial displayName of a resource. Will match any resource whose name (case-insensitive) contains the provided value.
    :param str health_check_monitor_id: Search by health check monitor OCID. Will match any resource whose health check monitor ID matches the provided value.
    :param str id: The OCID of a resource.
    :param str state: The state of a resource.
    :param str template: Search by steering template type. Will match any resource whose template type matches the provided value.
    :param str time_created_greater_than_or_equal_to: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created on or after the indicated time.
    :param str time_created_less_than: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created before the indicated time.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['healthCheckMonitorId'] = health_check_monitor_id
    __args__['id'] = id
    __args__['state'] = state
    __args__['template'] = template
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dns/getSteeringPolicies:getSteeringPolicies', __args__, opts=opts, typ=GetSteeringPoliciesResult).value

    return AwaitableGetSteeringPoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        health_check_monitor_id=pulumi.get(__ret__, 'health_check_monitor_id'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        steering_policies=pulumi.get(__ret__, 'steering_policies'),
        template=pulumi.get(__ret__, 'template'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))


@_utilities.lift_output_func(get_steering_policies)
def get_steering_policies_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSteeringPoliciesFilterArgs']]]]] = None,
                                 health_check_monitor_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 id: Optional[pulumi.Input[Optional[str]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 template: Optional[pulumi.Input[Optional[str]]] = None,
                                 time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                 time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSteeringPoliciesResult]:
    """
    This data source provides the list of Steering Policies in Oracle Cloud Infrastructure DNS service.

    Gets a list of all steering policies in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_steering_policies = oci.Dns.get_steering_policies(compartment_id=compartment_id,
        display_name=steering_policy_display_name,
        display_name_contains=steering_policy_display_name_contains,
        health_check_monitor_id=test_http_monitor["id"],
        id=steering_policy_id,
        state=steering_policy_state,
        template=steering_policy_template,
        time_created_greater_than_or_equal_to=steering_policy_time_created_greater_than_or_equal_to,
        time_created_less_than=steering_policy_time_created_less_than)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment the resource belongs to.
    :param str display_name: The displayName of a resource.
    :param str display_name_contains: The partial displayName of a resource. Will match any resource whose name (case-insensitive) contains the provided value.
    :param str health_check_monitor_id: Search by health check monitor OCID. Will match any resource whose health check monitor ID matches the provided value.
    :param str id: The OCID of a resource.
    :param str state: The state of a resource.
    :param str template: Search by steering template type. Will match any resource whose template type matches the provided value.
    :param str time_created_greater_than_or_equal_to: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created on or after the indicated time.
    :param str time_created_less_than: An [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) timestamp that states all returned resources were created before the indicated time.
    """
    ...
