# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEmWarehousesResult',
    'AwaitableGetEmWarehousesResult',
    'get_em_warehouses',
    'get_em_warehouses_output',
]

@pulumi.output_type
class GetEmWarehousesResult:
    """
    A collection of values returned by getEmWarehouses.
    """
    def __init__(__self__, compartment_id=None, display_name=None, em_warehouse_collections=None, filters=None, id=None, operations_insights_warehouse_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if em_warehouse_collections and not isinstance(em_warehouse_collections, list):
            raise TypeError("Expected argument 'em_warehouse_collections' to be a list")
        pulumi.set(__self__, "em_warehouse_collections", em_warehouse_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if operations_insights_warehouse_id and not isinstance(operations_insights_warehouse_id, str):
            raise TypeError("Expected argument 'operations_insights_warehouse_id' to be a str")
        pulumi.set(__self__, "operations_insights_warehouse_id", operations_insights_warehouse_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        EmWarehouse Identifier, can be renamed
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emWarehouseCollections")
    def em_warehouse_collections(self) -> Sequence['outputs.GetEmWarehousesEmWarehouseCollectionResult']:
        """
        The list of em_warehouse_collection.
        """
        return pulumi.get(self, "em_warehouse_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEmWarehousesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="operationsInsightsWarehouseId")
    def operations_insights_warehouse_id(self) -> Optional[str]:
        """
        operations Insights Warehouse Identifier
        """
        return pulumi.get(self, "operations_insights_warehouse_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the EmWarehouse.
        """
        return pulumi.get(self, "state")


class AwaitableGetEmWarehousesResult(GetEmWarehousesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmWarehousesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            em_warehouse_collections=self.em_warehouse_collections,
            filters=self.filters,
            id=self.id,
            operations_insights_warehouse_id=self.operations_insights_warehouse_id,
            state=self.state)


def get_em_warehouses(compartment_id: Optional[str] = None,
                      display_name: Optional[str] = None,
                      filters: Optional[Sequence[pulumi.InputType['GetEmWarehousesFilterArgs']]] = None,
                      id: Optional[str] = None,
                      operations_insights_warehouse_id: Optional[str] = None,
                      state: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmWarehousesResult:
    """
    This data source provides the list of Em Warehouses in Oracle Cloud Infrastructure Em Warehouse service.

    Returns a list of EmWarehouses.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_em_warehouses = oci.EmWarehouse.get_em_warehouses(compartment_id=compartment_id,
        display_name=em_warehouse_display_name,
        id=em_warehouse_id,
        operations_insights_warehouse_id=test_operations_insights_warehouse["id"],
        state=em_warehouse_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique EmWarehouse identifier
    :param str operations_insights_warehouse_id: unique operationsInsightsWarehouseId identifier
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['operationsInsightsWarehouseId'] = operations_insights_warehouse_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:EmWarehouse/getEmWarehouses:getEmWarehouses', __args__, opts=opts, typ=GetEmWarehousesResult).value

    return AwaitableGetEmWarehousesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        em_warehouse_collections=pulumi.get(__ret__, 'em_warehouse_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        operations_insights_warehouse_id=pulumi.get(__ret__, 'operations_insights_warehouse_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_em_warehouses)
def get_em_warehouses_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                             display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetEmWarehousesFilterArgs']]]]] = None,
                             id: Optional[pulumi.Input[Optional[str]]] = None,
                             operations_insights_warehouse_id: Optional[pulumi.Input[Optional[str]]] = None,
                             state: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEmWarehousesResult]:
    """
    This data source provides the list of Em Warehouses in Oracle Cloud Infrastructure Em Warehouse service.

    Returns a list of EmWarehouses.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_em_warehouses = oci.EmWarehouse.get_em_warehouses(compartment_id=compartment_id,
        display_name=em_warehouse_display_name,
        id=em_warehouse_id,
        operations_insights_warehouse_id=test_operations_insights_warehouse["id"],
        state=em_warehouse_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: unique EmWarehouse identifier
    :param str operations_insights_warehouse_id: unique operationsInsightsWarehouseId identifier
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    ...
