# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetFusionEnvironmentStatusResult',
    'AwaitableGetFusionEnvironmentStatusResult',
    'get_fusion_environment_status',
    'get_fusion_environment_status_output',
]

@pulumi.output_type
class GetFusionEnvironmentStatusResult:
    """
    A collection of values returned by getFusionEnvironmentStatus.
    """
    def __init__(__self__, fusion_environment_id=None, id=None, status=None):
        if fusion_environment_id and not isinstance(fusion_environment_id, str):
            raise TypeError("Expected argument 'fusion_environment_id' to be a str")
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> str:
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The data plane status of FusionEnvironment.
        """
        return pulumi.get(self, "status")


class AwaitableGetFusionEnvironmentStatusResult(GetFusionEnvironmentStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFusionEnvironmentStatusResult(
            fusion_environment_id=self.fusion_environment_id,
            id=self.id,
            status=self.status)


def get_fusion_environment_status(fusion_environment_id: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFusionEnvironmentStatusResult:
    """
    This data source provides details about a specific Fusion Environment Status resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets the status of a Fusion environment identified by its OCID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_status = oci.Functions.get_fusion_environment_status(fusion_environment_id=test_fusion_environment["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str fusion_environment_id: unique FusionEnvironment identifier
    """
    __args__ = dict()
    __args__['fusionEnvironmentId'] = fusion_environment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getFusionEnvironmentStatus:getFusionEnvironmentStatus', __args__, opts=opts, typ=GetFusionEnvironmentStatusResult).value

    return AwaitableGetFusionEnvironmentStatusResult(
        fusion_environment_id=pulumi.get(__ret__, 'fusion_environment_id'),
        id=pulumi.get(__ret__, 'id'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_fusion_environment_status)
def get_fusion_environment_status_output(fusion_environment_id: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFusionEnvironmentStatusResult]:
    """
    This data source provides details about a specific Fusion Environment Status resource in Oracle Cloud Infrastructure Fusion Apps service.

    Gets the status of a Fusion environment identified by its OCID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_fusion_environment_status = oci.Functions.get_fusion_environment_status(fusion_environment_id=test_fusion_environment["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str fusion_environment_id: unique FusionEnvironment identifier
    """
    ...
