# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionEnvironmentRefreshActivityArgs', 'FusionEnvironmentRefreshActivity']

@pulumi.input_type
class FusionEnvironmentRefreshActivityArgs:
    def __init__(__self__, *,
                 fusion_environment_id: pulumi.Input[str],
                 source_fusion_environment_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a FusionEnvironmentRefreshActivity resource.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[str] source_fusion_environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source environment
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        pulumi.set(__self__, "source_fusion_environment_id", source_fusion_environment_id)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> pulumi.Input[str]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @fusion_environment_id.setter
    def fusion_environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "fusion_environment_id", value)

    @property
    @pulumi.getter(name="sourceFusionEnvironmentId")
    def source_fusion_environment_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source environment


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_fusion_environment_id")

    @source_fusion_environment_id.setter
    def source_fusion_environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_fusion_environment_id", value)


@pulumi.input_type
class _FusionEnvironmentRefreshActivityState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 refresh_activity_id: Optional[pulumi.Input[str]] = None,
                 refresh_issue_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRefreshActivityRefreshIssueDetailsListArgs']]]] = None,
                 service_availability: Optional[pulumi.Input[str]] = None,
                 source_fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_accepted: Optional[pulumi.Input[str]] = None,
                 time_expected_finish: Optional[pulumi.Input[str]] = None,
                 time_finished: Optional[pulumi.Input[str]] = None,
                 time_of_restoration_point: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionEnvironmentRefreshActivity resources.
        :param pulumi.Input[str] display_name: A friendly name for the refresh activity. Can be changed later.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRefreshActivityRefreshIssueDetailsListArgs']]] refresh_issue_details_lists: Details of refresh investigation information, each item represents a different issue.
        :param pulumi.Input[str] service_availability: Service availability / impact during refresh activity execution up down
        :param pulumi.Input[str] source_fusion_environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source environment
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the refreshActivity.
        :param pulumi.Input[str] time_accepted: The time the refresh activity record was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_expected_finish: The time the refresh activity is scheduled to end. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_finished: The time the refresh activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_of_restoration_point: The date and time of the most recent source environment backup used for the environment refresh.
        :param pulumi.Input[str] time_updated: The time the refresh activity record was updated. An RFC3339 formatted datetime string.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fusion_environment_id is not None:
            pulumi.set(__self__, "fusion_environment_id", fusion_environment_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if refresh_activity_id is not None:
            pulumi.set(__self__, "refresh_activity_id", refresh_activity_id)
        if refresh_issue_details_lists is not None:
            pulumi.set(__self__, "refresh_issue_details_lists", refresh_issue_details_lists)
        if service_availability is not None:
            pulumi.set(__self__, "service_availability", service_availability)
        if source_fusion_environment_id is not None:
            pulumi.set(__self__, "source_fusion_environment_id", source_fusion_environment_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_accepted is not None:
            pulumi.set(__self__, "time_accepted", time_accepted)
        if time_expected_finish is not None:
            pulumi.set(__self__, "time_expected_finish", time_expected_finish)
        if time_finished is not None:
            pulumi.set(__self__, "time_finished", time_finished)
        if time_of_restoration_point is not None:
            pulumi.set(__self__, "time_of_restoration_point", time_of_restoration_point)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the refresh activity. Can be changed later.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @fusion_environment_id.setter
    def fusion_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fusion_environment_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="refreshActivityId")
    def refresh_activity_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "refresh_activity_id")

    @refresh_activity_id.setter
    def refresh_activity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "refresh_activity_id", value)

    @property
    @pulumi.getter(name="refreshIssueDetailsLists")
    def refresh_issue_details_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRefreshActivityRefreshIssueDetailsListArgs']]]]:
        """
        Details of refresh investigation information, each item represents a different issue.
        """
        return pulumi.get(self, "refresh_issue_details_lists")

    @refresh_issue_details_lists.setter
    def refresh_issue_details_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionEnvironmentRefreshActivityRefreshIssueDetailsListArgs']]]]):
        pulumi.set(self, "refresh_issue_details_lists", value)

    @property
    @pulumi.getter(name="serviceAvailability")
    def service_availability(self) -> Optional[pulumi.Input[str]]:
        """
        Service availability / impact during refresh activity execution up down
        """
        return pulumi.get(self, "service_availability")

    @service_availability.setter
    def service_availability(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_availability", value)

    @property
    @pulumi.getter(name="sourceFusionEnvironmentId")
    def source_fusion_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source environment


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_fusion_environment_id")

    @source_fusion_environment_id.setter
    def source_fusion_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_fusion_environment_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the refreshActivity.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> Optional[pulumi.Input[str]]:
        """
        The time the refresh activity record was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_accepted")

    @time_accepted.setter
    def time_accepted(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_accepted", value)

    @property
    @pulumi.getter(name="timeExpectedFinish")
    def time_expected_finish(self) -> Optional[pulumi.Input[str]]:
        """
        The time the refresh activity is scheduled to end. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expected_finish")

    @time_expected_finish.setter
    def time_expected_finish(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_expected_finish", value)

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> Optional[pulumi.Input[str]]:
        """
        The time the refresh activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_finished")

    @time_finished.setter
    def time_finished(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_finished", value)

    @property
    @pulumi.getter(name="timeOfRestorationPoint")
    def time_of_restoration_point(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the most recent source environment backup used for the environment refresh.
        """
        return pulumi.get(self, "time_of_restoration_point")

    @time_of_restoration_point.setter
    def time_of_restoration_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_restoration_point", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the refresh activity record was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class FusionEnvironmentRefreshActivity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 source_fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Fusion Environment Refresh Activity resource in Oracle Cloud Infrastructure Fusion Apps service.

        Creates a new RefreshActivity.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_fusion_environment_refresh_activity = oci.fusion_apps.FusionEnvironmentRefreshActivity("test_fusion_environment_refresh_activity",
            fusion_environment_id=test_fusion_environment["id"],
            source_fusion_environment_id=test_fusion_environment["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        FusionEnvironmentRefreshActivities can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FusionApps/fusionEnvironmentRefreshActivity:FusionEnvironmentRefreshActivity test_fusion_environment_refresh_activity "fusionEnvironments/{fusionEnvironmentId}/refreshActivities/{refreshActivityId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[str] source_fusion_environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source environment
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionEnvironmentRefreshActivityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fusion Environment Refresh Activity resource in Oracle Cloud Infrastructure Fusion Apps service.

        Creates a new RefreshActivity.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_fusion_environment_refresh_activity = oci.fusion_apps.FusionEnvironmentRefreshActivity("test_fusion_environment_refresh_activity",
            fusion_environment_id=test_fusion_environment["id"],
            source_fusion_environment_id=test_fusion_environment["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        FusionEnvironmentRefreshActivities can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FusionApps/fusionEnvironmentRefreshActivity:FusionEnvironmentRefreshActivity test_fusion_environment_refresh_activity "fusionEnvironments/{fusionEnvironmentId}/refreshActivities/{refreshActivityId}"
        ```

        :param str resource_name: The name of the resource.
        :param FusionEnvironmentRefreshActivityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionEnvironmentRefreshActivityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 source_fusion_environment_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionEnvironmentRefreshActivityArgs.__new__(FusionEnvironmentRefreshActivityArgs)

            if fusion_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'fusion_environment_id'")
            __props__.__dict__["fusion_environment_id"] = fusion_environment_id
            if source_fusion_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_fusion_environment_id'")
            __props__.__dict__["source_fusion_environment_id"] = source_fusion_environment_id
            __props__.__dict__["display_name"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["refresh_activity_id"] = None
            __props__.__dict__["refresh_issue_details_lists"] = None
            __props__.__dict__["service_availability"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_accepted"] = None
            __props__.__dict__["time_expected_finish"] = None
            __props__.__dict__["time_finished"] = None
            __props__.__dict__["time_of_restoration_point"] = None
            __props__.__dict__["time_updated"] = None
        super(FusionEnvironmentRefreshActivity, __self__).__init__(
            'oci:FusionApps/fusionEnvironmentRefreshActivity:FusionEnvironmentRefreshActivity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            fusion_environment_id: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            refresh_activity_id: Optional[pulumi.Input[str]] = None,
            refresh_issue_details_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionEnvironmentRefreshActivityRefreshIssueDetailsListArgs']]]]] = None,
            service_availability: Optional[pulumi.Input[str]] = None,
            source_fusion_environment_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_accepted: Optional[pulumi.Input[str]] = None,
            time_expected_finish: Optional[pulumi.Input[str]] = None,
            time_finished: Optional[pulumi.Input[str]] = None,
            time_of_restoration_point: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'FusionEnvironmentRefreshActivity':
        """
        Get an existing FusionEnvironmentRefreshActivity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: A friendly name for the refresh activity. Can be changed later.
        :param pulumi.Input[str] fusion_environment_id: unique FusionEnvironment identifier
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionEnvironmentRefreshActivityRefreshIssueDetailsListArgs']]]] refresh_issue_details_lists: Details of refresh investigation information, each item represents a different issue.
        :param pulumi.Input[str] service_availability: Service availability / impact during refresh activity execution up down
        :param pulumi.Input[str] source_fusion_environment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source environment
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] state: The current state of the refreshActivity.
        :param pulumi.Input[str] time_accepted: The time the refresh activity record was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_expected_finish: The time the refresh activity is scheduled to end. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_finished: The time the refresh activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_of_restoration_point: The date and time of the most recent source environment backup used for the environment refresh.
        :param pulumi.Input[str] time_updated: The time the refresh activity record was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionEnvironmentRefreshActivityState.__new__(_FusionEnvironmentRefreshActivityState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fusion_environment_id"] = fusion_environment_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["refresh_activity_id"] = refresh_activity_id
        __props__.__dict__["refresh_issue_details_lists"] = refresh_issue_details_lists
        __props__.__dict__["service_availability"] = service_availability
        __props__.__dict__["source_fusion_environment_id"] = source_fusion_environment_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_accepted"] = time_accepted
        __props__.__dict__["time_expected_finish"] = time_expected_finish
        __props__.__dict__["time_finished"] = time_finished
        __props__.__dict__["time_of_restoration_point"] = time_of_restoration_point
        __props__.__dict__["time_updated"] = time_updated
        return FusionEnvironmentRefreshActivity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A friendly name for the refresh activity. Can be changed later.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fusionEnvironmentId")
    def fusion_environment_id(self) -> pulumi.Output[str]:
        """
        unique FusionEnvironment identifier
        """
        return pulumi.get(self, "fusion_environment_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="refreshActivityId")
    def refresh_activity_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "refresh_activity_id")

    @property
    @pulumi.getter(name="refreshIssueDetailsLists")
    def refresh_issue_details_lists(self) -> pulumi.Output[Sequence['outputs.FusionEnvironmentRefreshActivityRefreshIssueDetailsList']]:
        """
        Details of refresh investigation information, each item represents a different issue.
        """
        return pulumi.get(self, "refresh_issue_details_lists")

    @property
    @pulumi.getter(name="serviceAvailability")
    def service_availability(self) -> pulumi.Output[str]:
        """
        Service availability / impact during refresh activity execution up down
        """
        return pulumi.get(self, "service_availability")

    @property
    @pulumi.getter(name="sourceFusionEnvironmentId")
    def source_fusion_environment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source environment


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_fusion_environment_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the refreshActivity.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> pulumi.Output[str]:
        """
        The time the refresh activity record was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeExpectedFinish")
    def time_expected_finish(self) -> pulumi.Output[str]:
        """
        The time the refresh activity is scheduled to end. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_expected_finish")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> pulumi.Output[str]:
        """
        The time the refresh activity actually completed / cancelled / failed. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeOfRestorationPoint")
    def time_of_restoration_point(self) -> pulumi.Output[str]:
        """
        The date and time of the most recent source environment backup used for the environment refresh.
        """
        return pulumi.get(self, "time_of_restoration_point")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the refresh activity record was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

