# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDatabaseRegistrationResult',
    'AwaitableGetDatabaseRegistrationResult',
    'get_database_registration',
    'get_database_registration_output',
]

@pulumi.output_type
class GetDatabaseRegistrationResult:
    """
    A collection of values returned by getDatabaseRegistration.
    """
    def __init__(__self__, alias_name=None, compartment_id=None, connection_string=None, database_id=None, database_registration_id=None, defined_tags=None, description=None, display_name=None, fqdn=None, freeform_tags=None, id=None, ip_address=None, key_id=None, lifecycle_details=None, password=None, rce_private_ip=None, secret_compartment_id=None, secret_id=None, session_mode=None, state=None, subnet_id=None, system_tags=None, time_created=None, time_updated=None, username=None, vault_id=None, wallet=None):
        if alias_name and not isinstance(alias_name, str):
            raise TypeError("Expected argument 'alias_name' to be a str")
        pulumi.set(__self__, "alias_name", alias_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_string and not isinstance(connection_string, str):
            raise TypeError("Expected argument 'connection_string' to be a str")
        pulumi.set(__self__, "connection_string", connection_string)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if database_registration_id and not isinstance(database_registration_id, str):
            raise TypeError("Expected argument 'database_registration_id' to be a str")
        pulumi.set(__self__, "database_registration_id", database_registration_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if rce_private_ip and not isinstance(rce_private_ip, str):
            raise TypeError("Expected argument 'rce_private_ip' to be a str")
        pulumi.set(__self__, "rce_private_ip", rce_private_ip)
        if secret_compartment_id and not isinstance(secret_compartment_id, str):
            raise TypeError("Expected argument 'secret_compartment_id' to be a str")
        pulumi.set(__self__, "secret_compartment_id", secret_compartment_id)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if session_mode and not isinstance(session_mode, str):
            raise TypeError("Expected argument 'session_mode' to be a str")
        pulumi.set(__self__, "session_mode", session_mode)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)
        if wallet and not isinstance(wallet, str):
            raise TypeError("Expected argument 'wallet' to be a str")
        pulumi.set(__self__, "wallet", wallet)

    @property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> str:
        """
        Credential store alias.
        """
        return pulumi.get(self, "alias_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> str:
        """
        Connect descriptor or Easy Connect Naming method used to connect to a database.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database being referenced.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseRegistrationId")
    def database_registration_id(self) -> str:
        return pulumi.get(self, "database_registration_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        A three-label Fully Qualified Domain Name (FQDN) for a resource.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the databaseRegistration being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The private IP address in the customer's VCN of the customer's endpoint, typically a database.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="rcePrivateIp")
    def rce_private_ip(self) -> str:
        """
        A Private Endpoint IP address created in the customer's subnet.  A customer database can expect network traffic initiated by GoldenGate Service from this IP address.  It can also send network traffic to this IP address, typically in response to requests from GoldenGate Service.  The customer may use this IP address in Security Lists or Network Security Groups (NSG) as needed.
        """
        return pulumi.get(self, "rce_private_ip")

    @property
    @pulumi.getter(name="secretCompartmentId")
    def secret_compartment_id(self) -> str:
        """
        The OCID of the compartment where the GoldenGate Secret will be created.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        """
        return pulumi.get(self, "secret_compartment_id")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The OCID of the customer's GoldenGate Service Secret.  If provided, it references a key that customers will be required to ensure the policies are established  to permit GoldenGate to use this Secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="sessionMode")
    def session_mode(self) -> str:
        """
        The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        """
        return pulumi.get(self, "session_mode")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Possible lifecycle states.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target subnet of the dedicated connection.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter
    def wallet(self) -> str:
        return pulumi.get(self, "wallet")


class AwaitableGetDatabaseRegistrationResult(GetDatabaseRegistrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseRegistrationResult(
            alias_name=self.alias_name,
            compartment_id=self.compartment_id,
            connection_string=self.connection_string,
            database_id=self.database_id,
            database_registration_id=self.database_registration_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            fqdn=self.fqdn,
            freeform_tags=self.freeform_tags,
            id=self.id,
            ip_address=self.ip_address,
            key_id=self.key_id,
            lifecycle_details=self.lifecycle_details,
            password=self.password,
            rce_private_ip=self.rce_private_ip,
            secret_compartment_id=self.secret_compartment_id,
            secret_id=self.secret_id,
            session_mode=self.session_mode,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            username=self.username,
            vault_id=self.vault_id,
            wallet=self.wallet)


def get_database_registration(database_registration_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseRegistrationResult:
    """
    This data source provides details about a specific Database Registration resource in Oracle Cloud Infrastructure Golden Gate service.

    Note: Deprecated. Use the /connections API instead.
    Retrieves a DatabaseRegistration.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_registration = oci.GoldenGate.get_database_registration(database_registration_id=test_database_registration_oci_golden_gate_database_registration["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str database_registration_id: A unique DatabaseRegistration identifier.
    """
    __args__ = dict()
    __args__['databaseRegistrationId'] = database_registration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getDatabaseRegistration:getDatabaseRegistration', __args__, opts=opts, typ=GetDatabaseRegistrationResult).value

    return AwaitableGetDatabaseRegistrationResult(
        alias_name=pulumi.get(__ret__, 'alias_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_string=pulumi.get(__ret__, 'connection_string'),
        database_id=pulumi.get(__ret__, 'database_id'),
        database_registration_id=pulumi.get(__ret__, 'database_registration_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        key_id=pulumi.get(__ret__, 'key_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        password=pulumi.get(__ret__, 'password'),
        rce_private_ip=pulumi.get(__ret__, 'rce_private_ip'),
        secret_compartment_id=pulumi.get(__ret__, 'secret_compartment_id'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        session_mode=pulumi.get(__ret__, 'session_mode'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        username=pulumi.get(__ret__, 'username'),
        vault_id=pulumi.get(__ret__, 'vault_id'),
        wallet=pulumi.get(__ret__, 'wallet'))


@_utilities.lift_output_func(get_database_registration)
def get_database_registration_output(database_registration_id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseRegistrationResult]:
    """
    This data source provides details about a specific Database Registration resource in Oracle Cloud Infrastructure Golden Gate service.

    Note: Deprecated. Use the /connections API instead.
    Retrieves a DatabaseRegistration.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_registration = oci.GoldenGate.get_database_registration(database_registration_id=test_database_registration_oci_golden_gate_database_registration["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str database_registration_id: A unique DatabaseRegistration identifier.
    """
    ...
