# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIamWorkRequestLogsResult',
    'AwaitableGetIamWorkRequestLogsResult',
    'get_iam_work_request_logs',
    'get_iam_work_request_logs_output',
]

@pulumi.output_type
class GetIamWorkRequestLogsResult:
    """
    A collection of values returned by getIamWorkRequestLogs.
    """
    def __init__(__self__, filters=None, iam_work_request_id=None, iam_work_request_logs=None, id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if iam_work_request_id and not isinstance(iam_work_request_id, str):
            raise TypeError("Expected argument 'iam_work_request_id' to be a str")
        pulumi.set(__self__, "iam_work_request_id", iam_work_request_id)
        if iam_work_request_logs and not isinstance(iam_work_request_logs, list):
            raise TypeError("Expected argument 'iam_work_request_logs' to be a list")
        pulumi.set(__self__, "iam_work_request_logs", iam_work_request_logs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIamWorkRequestLogsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="iamWorkRequestId")
    def iam_work_request_id(self) -> str:
        return pulumi.get(self, "iam_work_request_id")

    @property
    @pulumi.getter(name="iamWorkRequestLogs")
    def iam_work_request_logs(self) -> Sequence['outputs.GetIamWorkRequestLogsIamWorkRequestLogResult']:
        """
        The list of iam_work_request_logs.
        """
        return pulumi.get(self, "iam_work_request_logs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetIamWorkRequestLogsResult(GetIamWorkRequestLogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIamWorkRequestLogsResult(
            filters=self.filters,
            iam_work_request_id=self.iam_work_request_id,
            iam_work_request_logs=self.iam_work_request_logs,
            id=self.id)


def get_iam_work_request_logs(filters: Optional[Sequence[pulumi.InputType['GetIamWorkRequestLogsFilterArgs']]] = None,
                              iam_work_request_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIamWorkRequestLogsResult:
    """
    This data source provides the list of Iam Work Request Logs in Oracle Cloud Infrastructure Identity service.

    Gets logs for a specified IAM work request. For asynchronous operations in Identity and Access Management service, opc-work-request-id header values contains
    iam work request id that can be provided in this API to track the current status of the operation.

    - If workrequest exists, returns 202 ACCEPTED
    - If workrequest does not exist, returns 404 NOT FOUND

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_iam_work_request_logs = oci.Identity.get_iam_work_request_logs(iam_work_request_id=test_iam_work_request["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str iam_work_request_id: The OCID of the IAM work request.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['iamWorkRequestId'] = iam_work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getIamWorkRequestLogs:getIamWorkRequestLogs', __args__, opts=opts, typ=GetIamWorkRequestLogsResult).value

    return AwaitableGetIamWorkRequestLogsResult(
        filters=pulumi.get(__ret__, 'filters'),
        iam_work_request_id=pulumi.get(__ret__, 'iam_work_request_id'),
        iam_work_request_logs=pulumi.get(__ret__, 'iam_work_request_logs'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_iam_work_request_logs)
def get_iam_work_request_logs_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetIamWorkRequestLogsFilterArgs']]]]] = None,
                                     iam_work_request_id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIamWorkRequestLogsResult]:
    """
    This data source provides the list of Iam Work Request Logs in Oracle Cloud Infrastructure Identity service.

    Gets logs for a specified IAM work request. For asynchronous operations in Identity and Access Management service, opc-work-request-id header values contains
    iam work request id that can be provided in this API to track the current status of the operation.

    - If workrequest exists, returns 202 ACCEPTED
    - If workrequest does not exist, returns 404 NOT FOUND

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_iam_work_request_logs = oci.Identity.get_iam_work_request_logs(iam_work_request_id=test_iam_work_request["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str iam_work_request_id: The OCID of the IAM work request.
    """
    ...
