# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkSourceResult',
    'AwaitableGetNetworkSourceResult',
    'get_network_source',
    'get_network_source_output',
]

@pulumi.output_type
class GetNetworkSourceResult:
    """
    A collection of values returned by getNetworkSource.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, freeform_tags=None, id=None, inactive_state=None, name=None, network_source_id=None, public_source_lists=None, services=None, state=None, time_created=None, virtual_source_lists=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inactive_state and not isinstance(inactive_state, str):
            raise TypeError("Expected argument 'inactive_state' to be a str")
        pulumi.set(__self__, "inactive_state", inactive_state)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_source_id and not isinstance(network_source_id, str):
            raise TypeError("Expected argument 'network_source_id' to be a str")
        pulumi.set(__self__, "network_source_id", network_source_id)
        if public_source_lists and not isinstance(public_source_lists, list):
            raise TypeError("Expected argument 'public_source_lists' to be a list")
        pulumi.set(__self__, "public_source_lists", public_source_lists)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if virtual_source_lists and not isinstance(virtual_source_lists, list):
            raise TypeError("Expected argument 'virtual_source_lists' to be a list")
        pulumi.set(__self__, "virtual_source_lists", virtual_source_lists)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the tenancy containing the network source. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description you assign to the network source. Does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the network source.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inactiveState")
    def inactive_state(self) -> str:
        """
        The detailed status of INACTIVE lifecycleState.
        """
        return pulumi.get(self, "inactive_state")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name you assign to the network source during creation. The name must be unique across the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSourceId")
    def network_source_id(self) -> str:
        return pulumi.get(self, "network_source_id")

    @property
    @pulumi.getter(name="publicSourceLists")
    def public_source_lists(self) -> Sequence[str]:
        """
        A list of allowed public IP addresses and CIDR ranges.
        """
        return pulumi.get(self, "public_source_lists")

    @property
    @pulumi.getter
    def services(self) -> Sequence[str]:
        """
        A list of services allowed to make on-behalf-of requests. These requests can have different source IPs than those specified in the network source. Currently, only `all` and `none` are supported. The default is `all`.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The network source object's current state. After creating a network source, make sure its `lifecycleState` changes from CREATING to ACTIVE before using it.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the group was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="virtualSourceLists")
    def virtual_source_lists(self) -> Sequence['outputs.GetNetworkSourceVirtualSourceListResult']:
        """
        A list of allowed VCN OCID and IP range pairs. Example:`"vcnId": "ocid1.vcn.oc1.iad.aaaaaaaaexampleuniqueID", "ipRanges": [ "129.213.39.0/24" ]`
        """
        return pulumi.get(self, "virtual_source_lists")


class AwaitableGetNetworkSourceResult(GetNetworkSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkSourceResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            inactive_state=self.inactive_state,
            name=self.name,
            network_source_id=self.network_source_id,
            public_source_lists=self.public_source_lists,
            services=self.services,
            state=self.state,
            time_created=self.time_created,
            virtual_source_lists=self.virtual_source_lists)


def get_network_source(network_source_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkSourceResult:
    """
    This data source provides details about a specific Network Source resource in Oracle Cloud Infrastructure Identity service.

    Gets the specified network source's information.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_source = oci.Identity.get_network_source(network_source_id=test_network_source_oci_identity_network_source["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str network_source_id: The OCID of the network source.
    """
    __args__ = dict()
    __args__['networkSourceId'] = network_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getNetworkSource:getNetworkSource', __args__, opts=opts, typ=GetNetworkSourceResult).value

    return AwaitableGetNetworkSourceResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        inactive_state=pulumi.get(__ret__, 'inactive_state'),
        name=pulumi.get(__ret__, 'name'),
        network_source_id=pulumi.get(__ret__, 'network_source_id'),
        public_source_lists=pulumi.get(__ret__, 'public_source_lists'),
        services=pulumi.get(__ret__, 'services'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        virtual_source_lists=pulumi.get(__ret__, 'virtual_source_lists'))


@_utilities.lift_output_func(get_network_source)
def get_network_source_output(network_source_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkSourceResult]:
    """
    This data source provides details about a specific Network Source resource in Oracle Cloud Infrastructure Identity service.

    Gets the specified network source's information.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_source = oci.Identity.get_network_source(network_source_id=test_network_source_oci_identity_network_source["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str network_source_id: The OCID of the network source.
    """
    ...
