# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTagDefaultsResult',
    'AwaitableGetTagDefaultsResult',
    'get_tag_defaults',
    'get_tag_defaults_output',
]

@pulumi.output_type
class GetTagDefaultsResult:
    """
    A collection of values returned by getTagDefaults.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, state=None, tag_defaults=None, tag_definition_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tag_defaults and not isinstance(tag_defaults, list):
            raise TypeError("Expected argument 'tag_defaults' to be a list")
        pulumi.set(__self__, "tag_defaults", tag_defaults)
        if tag_definition_id and not isinstance(tag_definition_id, str):
            raise TypeError("Expected argument 'tag_definition_id' to be a str")
        pulumi.set(__self__, "tag_definition_id", tag_definition_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment. The tag default applies to all new resources that get created in the compartment. Resources that existed before the tag default was created are not tagged.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTagDefaultsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the tag default.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The tag default's current state. After creating a `TagDefault`, make sure its `lifecycleState` is ACTIVE before using it.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tagDefaults")
    def tag_defaults(self) -> Sequence['outputs.GetTagDefaultsTagDefaultResult']:
        """
        The list of tag_defaults.
        """
        return pulumi.get(self, "tag_defaults")

    @property
    @pulumi.getter(name="tagDefinitionId")
    def tag_definition_id(self) -> Optional[str]:
        """
        The OCID of the tag definition. The tag default will always assign a default value for this tag definition.
        """
        return pulumi.get(self, "tag_definition_id")


class AwaitableGetTagDefaultsResult(GetTagDefaultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagDefaultsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            state=self.state,
            tag_defaults=self.tag_defaults,
            tag_definition_id=self.tag_definition_id)


def get_tag_defaults(compartment_id: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetTagDefaultsFilterArgs']]] = None,
                     id: Optional[str] = None,
                     state: Optional[str] = None,
                     tag_definition_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagDefaultsResult:
    """
    This data source provides the list of Tag Defaults in Oracle Cloud Infrastructure Identity service.

    Lists the tag defaults for tag definitions in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_tag_defaults = oci.Identity.get_tag_defaults(compartment_id=compartment_id,
        id=tag_default_id,
        state=tag_default_state,
        tag_definition_id=test_tag_definition["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str id: A filter to only return resources that match the specified OCID exactly.
    :param str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    :param str tag_definition_id: The OCID of the tag definition.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    __args__['tagDefinitionId'] = tag_definition_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getTagDefaults:getTagDefaults', __args__, opts=opts, typ=GetTagDefaultsResult).value

    return AwaitableGetTagDefaultsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        tag_defaults=pulumi.get(__ret__, 'tag_defaults'),
        tag_definition_id=pulumi.get(__ret__, 'tag_definition_id'))


@_utilities.lift_output_func(get_tag_defaults)
def get_tag_defaults_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetTagDefaultsFilterArgs']]]]] = None,
                            id: Optional[pulumi.Input[Optional[str]]] = None,
                            state: Optional[pulumi.Input[Optional[str]]] = None,
                            tag_definition_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTagDefaultsResult]:
    """
    This data source provides the list of Tag Defaults in Oracle Cloud Infrastructure Identity service.

    Lists the tag defaults for tag definitions in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_tag_defaults = oci.Identity.get_tag_defaults(compartment_id=compartment_id,
        id=tag_default_id,
        state=tag_default_state,
        tag_definition_id=test_tag_definition["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str id: A filter to only return resources that match the specified OCID exactly.
    :param str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    :param str tag_definition_id: The OCID of the tag definition.
    """
    ...
