# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAnnouncementsResult',
    'AwaitableGetAnnouncementsResult',
    'get_announcements',
    'get_announcements_output',
]

@pulumi.output_type
class GetAnnouncementsResult:
    """
    A collection of values returned by getAnnouncements.
    """
    def __init__(__self__, announcement_collections=None, filters=None, id=None, summary_contains=None, time_end=None, time_start=None):
        if announcement_collections and not isinstance(announcement_collections, list):
            raise TypeError("Expected argument 'announcement_collections' to be a list")
        pulumi.set(__self__, "announcement_collections", announcement_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if summary_contains and not isinstance(summary_contains, str):
            raise TypeError("Expected argument 'summary_contains' to be a str")
        pulumi.set(__self__, "summary_contains", summary_contains)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="announcementCollections")
    def announcement_collections(self) -> Sequence['outputs.GetAnnouncementsAnnouncementCollectionResult']:
        """
        The list of announcement_collection.
        """
        return pulumi.get(self, "announcement_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAnnouncementsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="summaryContains")
    def summary_contains(self) -> Optional[str]:
        return pulumi.get(self, "summary_contains")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[str]:
        return pulumi.get(self, "time_start")


class AwaitableGetAnnouncementsResult(GetAnnouncementsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnnouncementsResult(
            announcement_collections=self.announcement_collections,
            filters=self.filters,
            id=self.id,
            summary_contains=self.summary_contains,
            time_end=self.time_end,
            time_start=self.time_start)


def get_announcements(filters: Optional[Sequence[pulumi.InputType['GetAnnouncementsFilterArgs']]] = None,
                      summary_contains: Optional[str] = None,
                      time_end: Optional[str] = None,
                      time_start: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnnouncementsResult:
    """
    This data source provides the list of Announcements in Oracle Cloud Infrastructure Jms service.

    Return a list of AnnouncementSummary items

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_announcements = oci.Jms.get_announcements(summary_contains=announcement_summary_contains,
        time_end=announcement_time_end,
        time_start=announcement_time_start)
    ```
    <!--End PulumiCodeChooser -->


    :param str summary_contains: Filter the list with summary contains the given value.
    :param str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['summaryContains'] = summary_contains
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getAnnouncements:getAnnouncements', __args__, opts=opts, typ=GetAnnouncementsResult).value

    return AwaitableGetAnnouncementsResult(
        announcement_collections=pulumi.get(__ret__, 'announcement_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        summary_contains=pulumi.get(__ret__, 'summary_contains'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_announcements)
def get_announcements_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAnnouncementsFilterArgs']]]]] = None,
                             summary_contains: Optional[pulumi.Input[Optional[str]]] = None,
                             time_end: Optional[pulumi.Input[Optional[str]]] = None,
                             time_start: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAnnouncementsResult]:
    """
    This data source provides the list of Announcements in Oracle Cloud Infrastructure Jms service.

    Return a list of AnnouncementSummary items

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_announcements = oci.Jms.get_announcements(summary_contains=announcement_summary_contains,
        time_end=announcement_time_end,
        time_start=announcement_time_start)
    ```
    <!--End PulumiCodeChooser -->


    :param str summary_contains: Filter the list with summary contains the given value.
    :param str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    ...
