# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVaultReplicasResult',
    'AwaitableGetVaultReplicasResult',
    'get_vault_replicas',
    'get_vault_replicas_output',
]

@pulumi.output_type
class GetVaultReplicasResult:
    """
    A collection of values returned by getVaultReplicas.
    """
    def __init__(__self__, filters=None, id=None, vault_id=None, vault_replicas=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)
        if vault_replicas and not isinstance(vault_replicas, list):
            raise TypeError("Expected argument 'vault_replicas' to be a list")
        pulumi.set(__self__, "vault_replicas", vault_replicas)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVaultReplicasFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="vaultReplicas")
    def vault_replicas(self) -> Sequence['outputs.GetVaultReplicasVaultReplicaResult']:
        """
        The list of vault_replicas.
        """
        return pulumi.get(self, "vault_replicas")


class AwaitableGetVaultReplicasResult(GetVaultReplicasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVaultReplicasResult(
            filters=self.filters,
            id=self.id,
            vault_id=self.vault_id,
            vault_replicas=self.vault_replicas)


def get_vault_replicas(filters: Optional[Sequence[pulumi.InputType['GetVaultReplicasFilterArgs']]] = None,
                       vault_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVaultReplicasResult:
    """
    This data source provides the list of Vault Replicas in Oracle Cloud Infrastructure Kms service.

    Lists the replicas for a vault

    As a provisioning operation, this call is subject to a Key Management limit that applies to
    the total number of requests across all provisioning write operations. Key Management might
    throttle this call to reject an otherwise valid request when the total rate of provisioning
    write operations exceeds 10 requests per second for a given tenancy.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_vault_replicas = oci.Kms.get_vault_replicas(vault_id=test_vault["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str vault_id: The OCID of the vault.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getVaultReplicas:getVaultReplicas', __args__, opts=opts, typ=GetVaultReplicasResult).value

    return AwaitableGetVaultReplicasResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        vault_id=pulumi.get(__ret__, 'vault_id'),
        vault_replicas=pulumi.get(__ret__, 'vault_replicas'))


@_utilities.lift_output_func(get_vault_replicas)
def get_vault_replicas_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVaultReplicasFilterArgs']]]]] = None,
                              vault_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVaultReplicasResult]:
    """
    This data source provides the list of Vault Replicas in Oracle Cloud Infrastructure Kms service.

    Lists the replicas for a vault

    As a provisioning operation, this call is subject to a Key Management limit that applies to
    the total number of requests across all provisioning write operations. Key Management might
    throttle this call to reject an otherwise valid request when the total rate of provisioning
    write operations exceeds 10 requests per second for a given tenancy.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_vault_replicas = oci.Kms.get_vault_replicas(vault_id=test_vault["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str vault_id: The OCID of the vault.
    """
    ...
