# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBackendSetsResult',
    'AwaitableGetBackendSetsResult',
    'get_backend_sets',
    'get_backend_sets_output',
]

@pulumi.output_type
class GetBackendSetsResult:
    """
    A collection of values returned by getBackendSets.
    """
    def __init__(__self__, backendsets=None, filters=None, id=None, load_balancer_id=None):
        if backendsets and not isinstance(backendsets, list):
            raise TypeError("Expected argument 'backendsets' to be a list")
        pulumi.set(__self__, "backendsets", backendsets)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)

    @property
    @pulumi.getter
    def backendsets(self) -> Sequence['outputs.GetBackendSetsBackendsetResult']:
        """
        The list of backendsets.
        """
        return pulumi.get(self, "backendsets")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBackendSetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        return pulumi.get(self, "load_balancer_id")


class AwaitableGetBackendSetsResult(GetBackendSetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackendSetsResult(
            backendsets=self.backendsets,
            filters=self.filters,
            id=self.id,
            load_balancer_id=self.load_balancer_id)


def get_backend_sets(filters: Optional[Sequence[pulumi.InputType['GetBackendSetsFilterArgs']]] = None,
                     load_balancer_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackendSetsResult:
    """
    This data source provides the list of Backend Sets in Oracle Cloud Infrastructure Load Balancer service.

    Lists all backend sets associated with a given load balancer.

    ## Supported Aliases

    * `oci_load_balancer_backendsets`

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_backend_sets = oci.LoadBalancer.get_backend_sets(load_balancer_id=test_load_balancer["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend sets to retrieve.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getBackendSets:getBackendSets', __args__, opts=opts, typ=GetBackendSetsResult).value

    return AwaitableGetBackendSetsResult(
        backendsets=pulumi.get(__ret__, 'backendsets'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'))


@_utilities.lift_output_func(get_backend_sets)
def get_backend_sets_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetBackendSetsFilterArgs']]]]] = None,
                            load_balancer_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackendSetsResult]:
    """
    This data source provides the list of Backend Sets in Oracle Cloud Infrastructure Load Balancer service.

    Lists all backend sets associated with a given load balancer.

    ## Supported Aliases

    * `oci_load_balancer_backendsets`

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_backend_sets = oci.LoadBalancer.get_backend_sets(load_balancer_id=test_load_balancer["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend sets to retrieve.
    """
    ...
