# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHostnamesResult',
    'AwaitableGetHostnamesResult',
    'get_hostnames',
    'get_hostnames_output',
]

@pulumi.output_type
class GetHostnamesResult:
    """
    A collection of values returned by getHostnames.
    """
    def __init__(__self__, filters=None, hostnames=None, id=None, load_balancer_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if hostnames and not isinstance(hostnames, list):
            raise TypeError("Expected argument 'hostnames' to be a list")
        pulumi.set(__self__, "hostnames", hostnames)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetHostnamesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def hostnames(self) -> Sequence['outputs.GetHostnamesHostnameResult']:
        """
        The list of hostnames.
        """
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        return pulumi.get(self, "load_balancer_id")


class AwaitableGetHostnamesResult(GetHostnamesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostnamesResult(
            filters=self.filters,
            hostnames=self.hostnames,
            id=self.id,
            load_balancer_id=self.load_balancer_id)


def get_hostnames(filters: Optional[Sequence[pulumi.InputType['GetHostnamesFilterArgs']]] = None,
                  load_balancer_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostnamesResult:
    """
    This data source provides the list of Hostnames in Oracle Cloud Infrastructure Load Balancer service.

    Lists all hostname resources associated with the specified load balancer.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_hostnames = oci.LoadBalancer.get_hostnames(load_balancer_id=test_load_balancer["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the hostnames to retrieve.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getHostnames:getHostnames', __args__, opts=opts, typ=GetHostnamesResult).value

    return AwaitableGetHostnamesResult(
        filters=pulumi.get(__ret__, 'filters'),
        hostnames=pulumi.get(__ret__, 'hostnames'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'))


@_utilities.lift_output_func(get_hostnames)
def get_hostnames_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetHostnamesFilterArgs']]]]] = None,
                         load_balancer_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHostnamesResult]:
    """
    This data source provides the list of Hostnames in Oracle Cloud Infrastructure Load Balancer service.

    Lists all hostname resources associated with the specified load balancer.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_hostnames = oci.LoadBalancer.get_hostnames(load_balancer_id=test_load_balancer["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the hostnames to retrieve.
    """
    ...
