# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogAnalyticsObjectCollectionRuleResult',
    'AwaitableGetLogAnalyticsObjectCollectionRuleResult',
    'get_log_analytics_object_collection_rule',
    'get_log_analytics_object_collection_rule_output',
]

@pulumi.output_type
class GetLogAnalyticsObjectCollectionRuleResult:
    """
    A collection of values returned by getLogAnalyticsObjectCollectionRule.
    """
    def __init__(__self__, char_encoding=None, collection_type=None, compartment_id=None, defined_tags=None, description=None, entity_id=None, freeform_tags=None, id=None, is_enabled=None, is_force_historic_collection=None, lifecycle_details=None, log_analytics_object_collection_rule_id=None, log_group_id=None, log_set=None, log_set_ext_regex=None, log_set_key=None, log_source_name=None, log_type=None, name=None, namespace=None, object_name_filters=None, os_bucket_name=None, os_namespace=None, overrides=None, poll_since=None, poll_till=None, state=None, time_created=None, time_updated=None, timezone=None):
        if char_encoding and not isinstance(char_encoding, str):
            raise TypeError("Expected argument 'char_encoding' to be a str")
        pulumi.set(__self__, "char_encoding", char_encoding)
        if collection_type and not isinstance(collection_type, str):
            raise TypeError("Expected argument 'collection_type' to be a str")
        pulumi.set(__self__, "collection_type", collection_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entity_id and not isinstance(entity_id, str):
            raise TypeError("Expected argument 'entity_id' to be a str")
        pulumi.set(__self__, "entity_id", entity_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_enabled and not isinstance(is_enabled, bool):
            raise TypeError("Expected argument 'is_enabled' to be a bool")
        pulumi.set(__self__, "is_enabled", is_enabled)
        if is_force_historic_collection and not isinstance(is_force_historic_collection, bool):
            raise TypeError("Expected argument 'is_force_historic_collection' to be a bool")
        pulumi.set(__self__, "is_force_historic_collection", is_force_historic_collection)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if log_analytics_object_collection_rule_id and not isinstance(log_analytics_object_collection_rule_id, str):
            raise TypeError("Expected argument 'log_analytics_object_collection_rule_id' to be a str")
        pulumi.set(__self__, "log_analytics_object_collection_rule_id", log_analytics_object_collection_rule_id)
        if log_group_id and not isinstance(log_group_id, str):
            raise TypeError("Expected argument 'log_group_id' to be a str")
        pulumi.set(__self__, "log_group_id", log_group_id)
        if log_set and not isinstance(log_set, str):
            raise TypeError("Expected argument 'log_set' to be a str")
        pulumi.set(__self__, "log_set", log_set)
        if log_set_ext_regex and not isinstance(log_set_ext_regex, str):
            raise TypeError("Expected argument 'log_set_ext_regex' to be a str")
        pulumi.set(__self__, "log_set_ext_regex", log_set_ext_regex)
        if log_set_key and not isinstance(log_set_key, str):
            raise TypeError("Expected argument 'log_set_key' to be a str")
        pulumi.set(__self__, "log_set_key", log_set_key)
        if log_source_name and not isinstance(log_source_name, str):
            raise TypeError("Expected argument 'log_source_name' to be a str")
        pulumi.set(__self__, "log_source_name", log_source_name)
        if log_type and not isinstance(log_type, str):
            raise TypeError("Expected argument 'log_type' to be a str")
        pulumi.set(__self__, "log_type", log_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if object_name_filters and not isinstance(object_name_filters, list):
            raise TypeError("Expected argument 'object_name_filters' to be a list")
        pulumi.set(__self__, "object_name_filters", object_name_filters)
        if os_bucket_name and not isinstance(os_bucket_name, str):
            raise TypeError("Expected argument 'os_bucket_name' to be a str")
        pulumi.set(__self__, "os_bucket_name", os_bucket_name)
        if os_namespace and not isinstance(os_namespace, str):
            raise TypeError("Expected argument 'os_namespace' to be a str")
        pulumi.set(__self__, "os_namespace", os_namespace)
        if overrides and not isinstance(overrides, list):
            raise TypeError("Expected argument 'overrides' to be a list")
        pulumi.set(__self__, "overrides", overrides)
        if poll_since and not isinstance(poll_since, str):
            raise TypeError("Expected argument 'poll_since' to be a str")
        pulumi.set(__self__, "poll_since", poll_since)
        if poll_till and not isinstance(poll_till, str):
            raise TypeError("Expected argument 'poll_till' to be a str")
        pulumi.set(__self__, "poll_till", poll_till)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if timezone and not isinstance(timezone, str):
            raise TypeError("Expected argument 'timezone' to be a str")
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="charEncoding")
    def char_encoding(self) -> str:
        """
        An optional character encoding to aid in detecting the character encoding of the contents of the objects while processing. It is recommended to set this value as ISO_8589_1 when configuring content of the objects having more numeric characters, and very few alphabets. For e.g. this applies when configuring VCN Flow Logs.
        """
        return pulumi.get(self, "char_encoding")

    @property
    @pulumi.getter(name="collectionType")
    def collection_type(self) -> str:
        """
        The type of collection. Supported collection types: LIVE, HISTORIC, HISTORIC_LIVE
        """
        return pulumi.get(self, "collection_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to which this rule belongs.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A string that describes the details of the rule. It does not have to be unique, and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        Logging Analytics entity OCID to associate the processed logs with.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        Whether or not this rule is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter(name="isForceHistoricCollection")
    def is_force_historic_collection(self) -> bool:
        """
        Flag to allow historic collection if poll period overlaps with existing ACTIVE collection rule
        """
        return pulumi.get(self, "is_force_historic_collection")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A detailed status of the life cycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logAnalyticsObjectCollectionRuleId")
    def log_analytics_object_collection_rule_id(self) -> str:
        return pulumi.get(self, "log_analytics_object_collection_rule_id")

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> str:
        """
        Logging Analytics Log group OCID to associate the processed logs with.
        """
        return pulumi.get(self, "log_group_id")

    @property
    @pulumi.getter(name="logSet")
    def log_set(self) -> str:
        """
        The logSet to be associated with the processed logs. The logSet feature can be used by customers with high volume of data  and this feature has to be enabled for a given tenancy prior to its usage. When logSetExtRegex value is provided, it will take precedence over this logSet value and logSet will be computed dynamically  using logSetKey and logSetExtRegex.
        """
        return pulumi.get(self, "log_set")

    @property
    @pulumi.getter(name="logSetExtRegex")
    def log_set_ext_regex(self) -> str:
        """
        The regex to be applied against given logSetKey. Regex has to be in string escaped format.
        """
        return pulumi.get(self, "log_set_ext_regex")

    @property
    @pulumi.getter(name="logSetKey")
    def log_set_key(self) -> str:
        """
        An optional parameter to indicate from where the logSet to be extracted using logSetExtRegex. Default value is OBJECT_PATH (e.g. /n/<namespace>/b/<bucketname>/o/<objectname>).
        """
        return pulumi.get(self, "log_set_key")

    @property
    @pulumi.getter(name="logSourceName")
    def log_source_name(self) -> str:
        """
        Name of the Logging Analytics Source to use for the processing.
        """
        return pulumi.get(self, "log_source_name")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        Type of files/objects in this object collection rule.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to the rule. The name must be unique, within the tenancy, and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNameFilters")
    def object_name_filters(self) -> Sequence[str]:
        """
        When the filters are provided, only the objects matching the filters are picked up for processing. The matchType supported is exact match and accommodates wildcard "*". For more information on filters, see [Event Filters](https://docs.oracle.com/en-us/iaas/Content/Events/Concepts/filterevents.htm).
        """
        return pulumi.get(self, "object_name_filters")

    @property
    @pulumi.getter(name="osBucketName")
    def os_bucket_name(self) -> str:
        """
        Name of the Object Storage bucket.
        """
        return pulumi.get(self, "os_bucket_name")

    @property
    @pulumi.getter(name="osNamespace")
    def os_namespace(self) -> str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "os_namespace")

    @property
    @pulumi.getter
    def overrides(self) -> Sequence['outputs.GetLogAnalyticsObjectCollectionRuleOverrideResult']:
        """
        Use this to override some property values which are defined at bucket level to the scope of object. Supported propeties for override are, logSourceName, charEncoding. Supported matchType for override are "contains".
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="pollSince")
    def poll_since(self) -> str:
        """
        The oldest time of the file in the bucket to consider for collection. Accepted values are: BEGINNING or CURRENT_TIME or RFC3339 formatted datetime string. When collectionType is LIVE, specifying pollSince value other than CURRENT_TIME will result in error.
        """
        return pulumi.get(self, "poll_since")

    @property
    @pulumi.getter(name="pollTill")
    def poll_till(self) -> str:
        """
        The oldest time of the file in the bucket to consider for collection. Accepted values are: CURRENT_TIME or RFC3339 formatted datetime string. When collectionType is LIVE, specifying pollTill will result in error.
        """
        return pulumi.get(self, "poll_till")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when this rule was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when this rule was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        Timezone to be used when processing log entries whose timestamps do not include an explicit timezone.  When this property is not specified, the timezone of the entity specified is used.  If the entity is also not specified or do not have a valid timezone then UTC is used.
        """
        return pulumi.get(self, "timezone")


class AwaitableGetLogAnalyticsObjectCollectionRuleResult(GetLogAnalyticsObjectCollectionRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsObjectCollectionRuleResult(
            char_encoding=self.char_encoding,
            collection_type=self.collection_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            entity_id=self.entity_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_enabled=self.is_enabled,
            is_force_historic_collection=self.is_force_historic_collection,
            lifecycle_details=self.lifecycle_details,
            log_analytics_object_collection_rule_id=self.log_analytics_object_collection_rule_id,
            log_group_id=self.log_group_id,
            log_set=self.log_set,
            log_set_ext_regex=self.log_set_ext_regex,
            log_set_key=self.log_set_key,
            log_source_name=self.log_source_name,
            log_type=self.log_type,
            name=self.name,
            namespace=self.namespace,
            object_name_filters=self.object_name_filters,
            os_bucket_name=self.os_bucket_name,
            os_namespace=self.os_namespace,
            overrides=self.overrides,
            poll_since=self.poll_since,
            poll_till=self.poll_till,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            timezone=self.timezone)


def get_log_analytics_object_collection_rule(log_analytics_object_collection_rule_id: Optional[str] = None,
                                             namespace: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsObjectCollectionRuleResult:
    """
    This data source provides details about a specific Log Analytics Object Collection Rule resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets a configured object storage based collection rule by given id

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_object_collection_rule = oci.LogAnalytics.get_log_analytics_object_collection_rule(log_analytics_object_collection_rule_id=test_log_analytics_object_collection_rule_oci_log_analytics_log_analytics_object_collection_rule["id"],
        namespace=log_analytics_object_collection_rule_namespace)
    ```
    <!--End PulumiCodeChooser -->


    :param str log_analytics_object_collection_rule_id: The Logging Analytics Object Collection Rule [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['logAnalyticsObjectCollectionRuleId'] = log_analytics_object_collection_rule_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsObjectCollectionRule:getLogAnalyticsObjectCollectionRule', __args__, opts=opts, typ=GetLogAnalyticsObjectCollectionRuleResult).value

    return AwaitableGetLogAnalyticsObjectCollectionRuleResult(
        char_encoding=pulumi.get(__ret__, 'char_encoding'),
        collection_type=pulumi.get(__ret__, 'collection_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        entity_id=pulumi.get(__ret__, 'entity_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_enabled=pulumi.get(__ret__, 'is_enabled'),
        is_force_historic_collection=pulumi.get(__ret__, 'is_force_historic_collection'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        log_analytics_object_collection_rule_id=pulumi.get(__ret__, 'log_analytics_object_collection_rule_id'),
        log_group_id=pulumi.get(__ret__, 'log_group_id'),
        log_set=pulumi.get(__ret__, 'log_set'),
        log_set_ext_regex=pulumi.get(__ret__, 'log_set_ext_regex'),
        log_set_key=pulumi.get(__ret__, 'log_set_key'),
        log_source_name=pulumi.get(__ret__, 'log_source_name'),
        log_type=pulumi.get(__ret__, 'log_type'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        object_name_filters=pulumi.get(__ret__, 'object_name_filters'),
        os_bucket_name=pulumi.get(__ret__, 'os_bucket_name'),
        os_namespace=pulumi.get(__ret__, 'os_namespace'),
        overrides=pulumi.get(__ret__, 'overrides'),
        poll_since=pulumi.get(__ret__, 'poll_since'),
        poll_till=pulumi.get(__ret__, 'poll_till'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        timezone=pulumi.get(__ret__, 'timezone'))


@_utilities.lift_output_func(get_log_analytics_object_collection_rule)
def get_log_analytics_object_collection_rule_output(log_analytics_object_collection_rule_id: Optional[pulumi.Input[str]] = None,
                                                    namespace: Optional[pulumi.Input[str]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogAnalyticsObjectCollectionRuleResult]:
    """
    This data source provides details about a specific Log Analytics Object Collection Rule resource in Oracle Cloud Infrastructure Log Analytics service.

    Gets a configured object storage based collection rule by given id

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_object_collection_rule = oci.LogAnalytics.get_log_analytics_object_collection_rule(log_analytics_object_collection_rule_id=test_log_analytics_object_collection_rule_oci_log_analytics_log_analytics_object_collection_rule["id"],
        namespace=log_analytics_object_collection_rule_namespace)
    ```
    <!--End PulumiCodeChooser -->


    :param str log_analytics_object_collection_rule_id: The Logging Analytics Object Collection Rule [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
    :param str namespace: The Logging Analytics namespace used for the request.
    """
    ...
