# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPublicationsResult',
    'AwaitableGetPublicationsResult',
    'get_publications',
    'get_publications_output',
]

@pulumi.output_type
class GetPublicationsResult:
    """
    A collection of values returned by getPublications.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, listing_type=None, names=None, operating_systems=None, publication_id=None, publications=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listing_type and not isinstance(listing_type, str):
            raise TypeError("Expected argument 'listing_type' to be a str")
        pulumi.set(__self__, "listing_type", listing_type)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if operating_systems and not isinstance(operating_systems, list):
            raise TypeError("Expected argument 'operating_systems' to be a list")
        pulumi.set(__self__, "operating_systems", operating_systems)
        if publication_id and not isinstance(publication_id, str):
            raise TypeError("Expected argument 'publication_id' to be a str")
        pulumi.set(__self__, "publication_id", publication_id)
        if publications and not isinstance(publications, list):
            raise TypeError("Expected argument 'publications' to be a list")
        pulumi.set(__self__, "publications", publications)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where the publication exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPublicationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> str:
        """
        The publisher category to which the publication belongs. The publisher category informs where the listing appears for use.
        """
        return pulumi.get(self, "listing_type")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        """
        The name of the operating system.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "operating_systems")

    @property
    @pulumi.getter(name="publicationId")
    def publication_id(self) -> Optional[str]:
        return pulumi.get(self, "publication_id")

    @property
    @pulumi.getter
    def publications(self) -> Sequence['outputs.GetPublicationsPublicationResult']:
        """
        The list of publications.
        """
        return pulumi.get(self, "publications")


class AwaitableGetPublicationsResult(GetPublicationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicationsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            listing_type=self.listing_type,
            names=self.names,
            operating_systems=self.operating_systems,
            publication_id=self.publication_id,
            publications=self.publications)


def get_publications(compartment_id: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetPublicationsFilterArgs']]] = None,
                     listing_type: Optional[str] = None,
                     names: Optional[Sequence[str]] = None,
                     operating_systems: Optional[Sequence[str]] = None,
                     publication_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicationsResult:
    """
    This data source provides the list of Publications in Oracle Cloud Infrastructure Marketplace service.

    Lists the publications in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_publications = oci.Marketplace.get_publications(compartment_id=compartment_id,
        listing_type=publication_listing_type,
        names=publication_name,
        operating_systems=publication_operating_systems,
        publication_id=test_publication["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The unique identifier for the compartment.
    :param str listing_type: The type of the listing.
    :param Sequence[str] names: The name of the publication.
    :param Sequence[str] operating_systems: The operating system of the listing.
    :param str publication_id: The unique identifier for the publication.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['listingType'] = listing_type
    __args__['names'] = names
    __args__['operatingSystems'] = operating_systems
    __args__['publicationId'] = publication_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getPublications:getPublications', __args__, opts=opts, typ=GetPublicationsResult).value

    return AwaitableGetPublicationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        listing_type=pulumi.get(__ret__, 'listing_type'),
        names=pulumi.get(__ret__, 'names'),
        operating_systems=pulumi.get(__ret__, 'operating_systems'),
        publication_id=pulumi.get(__ret__, 'publication_id'),
        publications=pulumi.get(__ret__, 'publications'))


@_utilities.lift_output_func(get_publications)
def get_publications_output(compartment_id: Optional[pulumi.Input[str]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetPublicationsFilterArgs']]]]] = None,
                            listing_type: Optional[pulumi.Input[str]] = None,
                            names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            operating_systems: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            publication_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublicationsResult]:
    """
    This data source provides the list of Publications in Oracle Cloud Infrastructure Marketplace service.

    Lists the publications in the specified compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_publications = oci.Marketplace.get_publications(compartment_id=compartment_id,
        listing_type=publication_listing_type,
        names=publication_name,
        operating_systems=publication_operating_systems,
        publication_id=test_publication["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The unique identifier for the compartment.
    :param str listing_type: The type of the listing.
    :param Sequence[str] names: The name of the publication.
    :param Sequence[str] operating_systems: The operating system of the listing.
    :param str publication_id: The unique identifier for the publication.
    """
    ...
