# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetQueryResult',
    'AwaitableGetQueryResult',
    'get_query',
    'get_query_output',
]

@pulumi.output_type
class GetQueryResult:
    """
    A collection of values returned by getQuery.
    """
    def __init__(__self__, compartment_id=None, id=None, query_definitions=None, query_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if query_definitions and not isinstance(query_definitions, list):
            raise TypeError("Expected argument 'query_definitions' to be a list")
        pulumi.set(__self__, "query_definitions", query_definitions)
        if query_id and not isinstance(query_id, str):
            raise TypeError("Expected argument 'query_id' to be a str")
        pulumi.set(__self__, "query_id", query_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The query OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="queryDefinitions")
    def query_definitions(self) -> Sequence['outputs.GetQueryQueryDefinitionResult']:
        """
        The common fields for queries.
        """
        return pulumi.get(self, "query_definitions")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> str:
        return pulumi.get(self, "query_id")


class AwaitableGetQueryResult(GetQueryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueryResult(
            compartment_id=self.compartment_id,
            id=self.id,
            query_definitions=self.query_definitions,
            query_id=self.query_id)


def get_query(query_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueryResult:
    """
    This data source provides details about a specific Query resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved query.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_query = oci.MeteringComputation.get_query(query_id=test_query_oci_metering_computation_query["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str query_id: The query unique OCID.
    """
    __args__ = dict()
    __args__['queryId'] = query_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getQuery:getQuery', __args__, opts=opts, typ=GetQueryResult).value

    return AwaitableGetQueryResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        query_definitions=pulumi.get(__ret__, 'query_definitions'),
        query_id=pulumi.get(__ret__, 'query_id'))


@_utilities.lift_output_func(get_query)
def get_query_output(query_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQueryResult]:
    """
    This data source provides details about a specific Query resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the saved query.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_query = oci.MeteringComputation.get_query(query_id=test_query_oci_metering_computation_query["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str query_id: The query unique OCID.
    """
    ...
