# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetUsageCarbonEmissionsConfigResult',
    'AwaitableGetUsageCarbonEmissionsConfigResult',
    'get_usage_carbon_emissions_config',
    'get_usage_carbon_emissions_config_output',
]

@pulumi.output_type
class GetUsageCarbonEmissionsConfigResult:
    """
    A collection of values returned by getUsageCarbonEmissionsConfig.
    """
    def __init__(__self__, id=None, items=None, tenant_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetUsageCarbonEmissionsConfigItemResult']:
        """
        The list of available configurations.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        return pulumi.get(self, "tenant_id")


class AwaitableGetUsageCarbonEmissionsConfigResult(GetUsageCarbonEmissionsConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsageCarbonEmissionsConfigResult(
            id=self.id,
            items=self.items,
            tenant_id=self.tenant_id)


def get_usage_carbon_emissions_config(tenant_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsageCarbonEmissionsConfigResult:
    """
    This data source provides details about a specific Usage Carbon Emissions Config resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the configuration list for the UI drop-down list of carbon emission console.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_carbon_emissions_config = oci.MeteringComputation.get_usage_carbon_emissions_config(tenant_id=test_tenant["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str tenant_id: tenant id
    """
    __args__ = dict()
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getUsageCarbonEmissionsConfig:getUsageCarbonEmissionsConfig', __args__, opts=opts, typ=GetUsageCarbonEmissionsConfigResult).value

    return AwaitableGetUsageCarbonEmissionsConfigResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))


@_utilities.lift_output_func(get_usage_carbon_emissions_config)
def get_usage_carbon_emissions_config_output(tenant_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsageCarbonEmissionsConfigResult]:
    """
    This data source provides details about a specific Usage Carbon Emissions Config resource in Oracle Cloud Infrastructure Metering Computation service.

    Returns the configuration list for the UI drop-down list of carbon emission console.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_carbon_emissions_config = oci.MeteringComputation.get_usage_carbon_emissions_config(tenant_id=test_tenant["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str tenant_id: tenant id
    """
    ...
