# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUsageCarbonEmissionsQueriesResult',
    'AwaitableGetUsageCarbonEmissionsQueriesResult',
    'get_usage_carbon_emissions_queries',
    'get_usage_carbon_emissions_queries_output',
]

@pulumi.output_type
class GetUsageCarbonEmissionsQueriesResult:
    """
    A collection of values returned by getUsageCarbonEmissionsQueries.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, usage_carbon_emissions_query_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if usage_carbon_emissions_query_collections and not isinstance(usage_carbon_emissions_query_collections, list):
            raise TypeError("Expected argument 'usage_carbon_emissions_query_collections' to be a list")
        pulumi.set(__self__, "usage_carbon_emissions_query_collections", usage_carbon_emissions_query_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUsageCarbonEmissionsQueriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="usageCarbonEmissionsQueryCollections")
    def usage_carbon_emissions_query_collections(self) -> Sequence['outputs.GetUsageCarbonEmissionsQueriesUsageCarbonEmissionsQueryCollectionResult']:
        """
        The list of usage_carbon_emissions_query_collection.
        """
        return pulumi.get(self, "usage_carbon_emissions_query_collections")


class AwaitableGetUsageCarbonEmissionsQueriesResult(GetUsageCarbonEmissionsQueriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsageCarbonEmissionsQueriesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            usage_carbon_emissions_query_collections=self.usage_carbon_emissions_query_collections)


def get_usage_carbon_emissions_queries(compartment_id: Optional[str] = None,
                                       filters: Optional[Sequence[pulumi.InputType['GetUsageCarbonEmissionsQueriesFilterArgs']]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsageCarbonEmissionsQueriesResult:
    """
    This data source provides the list of Usage Carbon Emissions Queries in Oracle Cloud Infrastructure Metering Computation service.

    Returns the usage carbon emissions saved query list.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_carbon_emissions_queries = oci.MeteringComputation.get_usage_carbon_emissions_queries(compartment_id=compartment_id)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment ID in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MeteringComputation/getUsageCarbonEmissionsQueries:getUsageCarbonEmissionsQueries', __args__, opts=opts, typ=GetUsageCarbonEmissionsQueriesResult).value

    return AwaitableGetUsageCarbonEmissionsQueriesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        usage_carbon_emissions_query_collections=pulumi.get(__ret__, 'usage_carbon_emissions_query_collections'))


@_utilities.lift_output_func(get_usage_carbon_emissions_queries)
def get_usage_carbon_emissions_queries_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetUsageCarbonEmissionsQueriesFilterArgs']]]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsageCarbonEmissionsQueriesResult]:
    """
    This data source provides the list of Usage Carbon Emissions Queries in Oracle Cloud Infrastructure Metering Computation service.

    Returns the usage carbon emissions saved query list.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_usage_carbon_emissions_queries = oci.MeteringComputation.get_usage_carbon_emissions_queries(compartment_id=compartment_id)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The compartment ID in which to list resources.
    """
    ...
