# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetPreauthrequestResult',
    'AwaitableGetPreauthrequestResult',
    'get_preauthrequest',
    'get_preauthrequest_output',
]

@pulumi.output_type
class GetPreauthrequestResult:
    """
    A collection of values returned by getPreauthrequest.
    """
    def __init__(__self__, access_type=None, access_uri=None, bucket=None, bucket_listing_action=None, full_path=None, id=None, name=None, namespace=None, object=None, object_name=None, par_id=None, time_created=None, time_expires=None):
        if access_type and not isinstance(access_type, str):
            raise TypeError("Expected argument 'access_type' to be a str")
        pulumi.set(__self__, "access_type", access_type)
        if access_uri and not isinstance(access_uri, str):
            raise TypeError("Expected argument 'access_uri' to be a str")
        pulumi.set(__self__, "access_uri", access_uri)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if bucket_listing_action and not isinstance(bucket_listing_action, str):
            raise TypeError("Expected argument 'bucket_listing_action' to be a str")
        pulumi.set(__self__, "bucket_listing_action", bucket_listing_action)
        if full_path and not isinstance(full_path, str):
            raise TypeError("Expected argument 'full_path' to be a str")
        pulumi.set(__self__, "full_path", full_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if object and not isinstance(object, str):
            raise TypeError("Expected argument 'object' to be a str")
        pulumi.set(__self__, "object", object)
        if object_name and not isinstance(object_name, str):
            raise TypeError("Expected argument 'object_name' to be a str")
        pulumi.set(__self__, "object_name", object_name)
        if par_id and not isinstance(par_id, str):
            raise TypeError("Expected argument 'par_id' to be a str")
        pulumi.set(__self__, "par_id", par_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_expires and not isinstance(time_expires, str):
            raise TypeError("Expected argument 'time_expires' to be a str")
        pulumi.set(__self__, "time_expires", time_expires)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        The operation that can be performed on this resource.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="accessUri")
    def access_uri(self) -> str:
        """
        The URI to embed in the URL when using the pre-authenticated request.
        """
        return pulumi.get(self, "access_uri")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket.  Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bucketListingAction")
    def bucket_listing_action(self) -> str:
        """
        Specifies whether a list operation is allowed on a PAR with accessType "AnyObjectRead" or "AnyObjectReadWrite". Deny: Prevents the user from performing a list operation. ListObjects: Authorizes the user to perform a list operation.
        """
        return pulumi.get(self, "bucket_listing_action")

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> str:
        return pulumi.get(self, "full_path")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier to use when directly addressing the pre-authenticated request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The user-provided name of the pre-authenticated request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Deprecated. Instead use `object_name`.The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        """
        warnings.warn("""The 'object' field has been deprecated. Please use 'object_name' instead.""", DeprecationWarning)
        pulumi.log.warn("""object is deprecated: The 'object' field has been deprecated. Please use 'object_name' instead.""")

        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> str:
        """
        The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="parId")
    def par_id(self) -> str:
        return pulumi.get(self, "par_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date when the pre-authenticated request was created as per specification [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> str:
        """
        The expiration date for the pre-authenticated request as per [RFC 3339](https://tools.ietf.org/html/rfc3339). After this date the pre-authenticated request will no longer be valid.
        """
        return pulumi.get(self, "time_expires")


class AwaitableGetPreauthrequestResult(GetPreauthrequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPreauthrequestResult(
            access_type=self.access_type,
            access_uri=self.access_uri,
            bucket=self.bucket,
            bucket_listing_action=self.bucket_listing_action,
            full_path=self.full_path,
            id=self.id,
            name=self.name,
            namespace=self.namespace,
            object=self.object,
            object_name=self.object_name,
            par_id=self.par_id,
            time_created=self.time_created,
            time_expires=self.time_expires)


def get_preauthrequest(bucket: Optional[str] = None,
                       namespace: Optional[str] = None,
                       par_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPreauthrequestResult:
    """
    This data source provides details about a specific Preauthenticated Request resource in Oracle Cloud Infrastructure Object Storage service.

    Gets the pre-authenticated request for the bucket.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_preauthenticated_request = oci.ObjectStorage.get_preauthrequest(bucket=preauthenticated_request_bucket,
        namespace=preauthenticated_request_namespace,
        par_id=test_par["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param str namespace: The Object Storage namespace used for the request.
    :param str par_id: The unique identifier for the pre-authenticated request. This can be used to manage operations against the pre-authenticated request, such as GET or DELETE.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['namespace'] = namespace
    __args__['parId'] = par_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ObjectStorage/getPreauthrequest:getPreauthrequest', __args__, opts=opts, typ=GetPreauthrequestResult).value

    return AwaitableGetPreauthrequestResult(
        access_type=pulumi.get(__ret__, 'access_type'),
        access_uri=pulumi.get(__ret__, 'access_uri'),
        bucket=pulumi.get(__ret__, 'bucket'),
        bucket_listing_action=pulumi.get(__ret__, 'bucket_listing_action'),
        full_path=pulumi.get(__ret__, 'full_path'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        object=pulumi.get(__ret__, 'object'),
        object_name=pulumi.get(__ret__, 'object_name'),
        par_id=pulumi.get(__ret__, 'par_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_expires=pulumi.get(__ret__, 'time_expires'))


@_utilities.lift_output_func(get_preauthrequest)
def get_preauthrequest_output(bucket: Optional[pulumi.Input[str]] = None,
                              namespace: Optional[pulumi.Input[str]] = None,
                              par_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPreauthrequestResult]:
    """
    This data source provides details about a specific Preauthenticated Request resource in Oracle Cloud Infrastructure Object Storage service.

    Gets the pre-authenticated request for the bucket.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_preauthenticated_request = oci.ObjectStorage.get_preauthrequest(bucket=preauthenticated_request_bucket,
        namespace=preauthenticated_request_namespace,
        par_id=test_par["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param str namespace: The Object Storage namespace used for the request.
    :param str par_id: The unique identifier for the pre-authenticated request. This can be used to manage operations against the pre-authenticated request, such as GET or DELETE.
    """
    ...
