# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPreauthrequestsResult',
    'AwaitableGetPreauthrequestsResult',
    'get_preauthrequests',
    'get_preauthrequests_output',
]

@pulumi.output_type
class GetPreauthrequestsResult:
    """
    A collection of values returned by getPreauthrequests.
    """
    def __init__(__self__, bucket=None, filters=None, id=None, namespace=None, object_name_prefix=None, preauthenticated_requests=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if object_name_prefix and not isinstance(object_name_prefix, str):
            raise TypeError("Expected argument 'object_name_prefix' to be a str")
        pulumi.set(__self__, "object_name_prefix", object_name_prefix)
        if preauthenticated_requests and not isinstance(preauthenticated_requests, list):
            raise TypeError("Expected argument 'preauthenticated_requests' to be a list")
        pulumi.set(__self__, "preauthenticated_requests", preauthenticated_requests)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the bucket.  Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPreauthrequestsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNamePrefix")
    def object_name_prefix(self) -> Optional[str]:
        return pulumi.get(self, "object_name_prefix")

    @property
    @pulumi.getter(name="preauthenticatedRequests")
    def preauthenticated_requests(self) -> Sequence['outputs.GetPreauthrequestsPreauthenticatedRequestResult']:
        """
        The list of preauthenticated_requests.
        """
        return pulumi.get(self, "preauthenticated_requests")


class AwaitableGetPreauthrequestsResult(GetPreauthrequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPreauthrequestsResult(
            bucket=self.bucket,
            filters=self.filters,
            id=self.id,
            namespace=self.namespace,
            object_name_prefix=self.object_name_prefix,
            preauthenticated_requests=self.preauthenticated_requests)


def get_preauthrequests(bucket: Optional[str] = None,
                        filters: Optional[Sequence[pulumi.InputType['GetPreauthrequestsFilterArgs']]] = None,
                        namespace: Optional[str] = None,
                        object_name_prefix: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPreauthrequestsResult:
    """
    This data source provides the list of Preauthenticated Requests in Oracle Cloud Infrastructure Object Storage service.

    Lists pre-authenticated requests for the bucket.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_preauthenticated_requests = oci.ObjectStorage.get_preauthrequests(bucket=preauthenticated_request_bucket,
        namespace=preauthenticated_request_namespace,
        object_name_prefix=preauthenticated_request_object_name_prefix)
    ```
    <!--End PulumiCodeChooser -->


    :param str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param str namespace: The Object Storage namespace used for the request.
    :param str object_name_prefix: User-specified object name prefixes can be used to query and return a list of pre-authenticated requests.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    __args__['objectNamePrefix'] = object_name_prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ObjectStorage/getPreauthrequests:getPreauthrequests', __args__, opts=opts, typ=GetPreauthrequestsResult).value

    return AwaitableGetPreauthrequestsResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        object_name_prefix=pulumi.get(__ret__, 'object_name_prefix'),
        preauthenticated_requests=pulumi.get(__ret__, 'preauthenticated_requests'))


@_utilities.lift_output_func(get_preauthrequests)
def get_preauthrequests_output(bucket: Optional[pulumi.Input[str]] = None,
                               filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetPreauthrequestsFilterArgs']]]]] = None,
                               namespace: Optional[pulumi.Input[str]] = None,
                               object_name_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPreauthrequestsResult]:
    """
    This data source provides the list of Preauthenticated Requests in Oracle Cloud Infrastructure Object Storage service.

    Lists pre-authenticated requests for the bucket.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_preauthenticated_requests = oci.ObjectStorage.get_preauthrequests(bucket=preauthenticated_request_bucket,
        namespace=preauthenticated_request_namespace,
        object_name_prefix=preauthenticated_request_object_name_prefix)
    ```
    <!--End PulumiCodeChooser -->


    :param str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
    :param str namespace: The Object Storage namespace used for the request.
    :param str object_name_prefix: User-specified object name prefixes can be used to query and return a list of pre-authenticated requests.
    """
    ...
