# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCommitmentResult',
    'AwaitableGetCommitmentResult',
    'get_commitment',
    'get_commitment_output',
]

@pulumi.output_type
class GetCommitmentResult:
    """
    A collection of values returned by getCommitment.
    """
    def __init__(__self__, available_amount=None, commitment_id=None, funded_allocation_value=None, id=None, quantity=None, subscribed_service_id=None, time_end=None, time_start=None, used_amount=None):
        if available_amount and not isinstance(available_amount, str):
            raise TypeError("Expected argument 'available_amount' to be a str")
        pulumi.set(__self__, "available_amount", available_amount)
        if commitment_id and not isinstance(commitment_id, str):
            raise TypeError("Expected argument 'commitment_id' to be a str")
        pulumi.set(__self__, "commitment_id", commitment_id)
        if funded_allocation_value and not isinstance(funded_allocation_value, str):
            raise TypeError("Expected argument 'funded_allocation_value' to be a str")
        pulumi.set(__self__, "funded_allocation_value", funded_allocation_value)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if quantity and not isinstance(quantity, str):
            raise TypeError("Expected argument 'quantity' to be a str")
        pulumi.set(__self__, "quantity", quantity)
        if subscribed_service_id and not isinstance(subscribed_service_id, str):
            raise TypeError("Expected argument 'subscribed_service_id' to be a str")
        pulumi.set(__self__, "subscribed_service_id", subscribed_service_id)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)
        if used_amount and not isinstance(used_amount, str):
            raise TypeError("Expected argument 'used_amount' to be a str")
        pulumi.set(__self__, "used_amount", used_amount)

    @property
    @pulumi.getter(name="availableAmount")
    def available_amount(self) -> str:
        """
        Commitment available amount
        """
        return pulumi.get(self, "available_amount")

    @property
    @pulumi.getter(name="commitmentId")
    def commitment_id(self) -> str:
        return pulumi.get(self, "commitment_id")

    @property
    @pulumi.getter(name="fundedAllocationValue")
    def funded_allocation_value(self) -> str:
        """
        Funded Allocation line value example: 12000.00
        """
        return pulumi.get(self, "funded_allocation_value")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def quantity(self) -> str:
        """
        Commitment quantity
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="subscribedServiceId")
    def subscribed_service_id(self) -> str:
        """
        SPM internal Subscribed Service ID
        """
        return pulumi.get(self, "subscribed_service_id")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> str:
        """
        Commitment end date
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> str:
        """
        Commitment start date
        """
        return pulumi.get(self, "time_start")

    @property
    @pulumi.getter(name="usedAmount")
    def used_amount(self) -> str:
        """
        Commitment used amount
        """
        return pulumi.get(self, "used_amount")


class AwaitableGetCommitmentResult(GetCommitmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCommitmentResult(
            available_amount=self.available_amount,
            commitment_id=self.commitment_id,
            funded_allocation_value=self.funded_allocation_value,
            id=self.id,
            quantity=self.quantity,
            subscribed_service_id=self.subscribed_service_id,
            time_end=self.time_end,
            time_start=self.time_start,
            used_amount=self.used_amount)


def get_commitment(commitment_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCommitmentResult:
    """
    This data source provides details about a specific Commitment resource in Oracle Cloud Infrastructure Onesubscription service.

    This API returns the commitment details corresponding to the id provided

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_commitment = oci.OneSubsription.get_commitment(commitment_id=test_commitment_oci_onesubscription_commitment["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str commitment_id: The Commitment Id
    """
    __args__ = dict()
    __args__['commitmentId'] = commitment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OneSubsription/getCommitment:getCommitment', __args__, opts=opts, typ=GetCommitmentResult).value

    return AwaitableGetCommitmentResult(
        available_amount=pulumi.get(__ret__, 'available_amount'),
        commitment_id=pulumi.get(__ret__, 'commitment_id'),
        funded_allocation_value=pulumi.get(__ret__, 'funded_allocation_value'),
        id=pulumi.get(__ret__, 'id'),
        quantity=pulumi.get(__ret__, 'quantity'),
        subscribed_service_id=pulumi.get(__ret__, 'subscribed_service_id'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'),
        used_amount=pulumi.get(__ret__, 'used_amount'))


@_utilities.lift_output_func(get_commitment)
def get_commitment_output(commitment_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCommitmentResult]:
    """
    This data source provides details about a specific Commitment resource in Oracle Cloud Infrastructure Onesubscription service.

    This API returns the commitment details corresponding to the id provided

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_commitment = oci.OneSubsription.get_commitment(commitment_id=test_commitment_oci_onesubscription_commitment["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str commitment_id: The Commitment Id
    """
    ...
