# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    """
    A collection of values returned by getSubscription.
    """
    def __init__(__self__, compartment_id=None, created_time=None, defined_tags=None, delivery_policy=None, endpoint=None, etag=None, freeform_tags=None, id=None, protocol=None, state=None, subscription_id=None, topic_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_time and not isinstance(created_time, str):
            raise TypeError("Expected argument 'created_time' to be a str")
        pulumi.set(__self__, "created_time", created_time)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if delivery_policy and not isinstance(delivery_policy, str):
            raise TypeError("Expected argument 'delivery_policy' to be a str")
        pulumi.set(__self__, "delivery_policy", delivery_policy)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if topic_id and not isinstance(topic_id, str):
            raise TypeError("Expected argument 'topic_id' to be a str")
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment for the subscription.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The time when this suscription was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> str:
        """
        The delivery policy of the subscription. Stored as a JSON string.
        """
        return pulumi.get(self, "delivery_policy")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        A locator that corresponds to the subscription protocol. For example, an email address for a subscription that uses the `EMAIL` protocol, or a URL for a subscription that uses an HTTP-based protocol.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        For optimistic concurrency control. See `if-match`.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for the subscription.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the subscription. The status of a new subscription is PENDING; when confirmed, the subscription status changes to ACTIVE.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated topic.
        """
        return pulumi.get(self, "topic_id")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            compartment_id=self.compartment_id,
            created_time=self.created_time,
            defined_tags=self.defined_tags,
            delivery_policy=self.delivery_policy,
            endpoint=self.endpoint,
            etag=self.etag,
            freeform_tags=self.freeform_tags,
            id=self.id,
            protocol=self.protocol,
            state=self.state,
            subscription_id=self.subscription_id,
            topic_id=self.topic_id)


def get_subscription(subscription_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    This data source provides details about a specific Subscription resource in Oracle Cloud Infrastructure Notifications service.

    Gets the specified subscription's configuration information.

    Transactions Per Minute (TPM) per-tenancy limit for this operation: 60.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription = oci.Ons.get_subscription(subscription_id=test_subscription_oci_ons_subscription["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription to retrieve.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ons/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_time=pulumi.get(__ret__, 'created_time'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        delivery_policy=pulumi.get(__ret__, 'delivery_policy'),
        endpoint=pulumi.get(__ret__, 'endpoint'),
        etag=pulumi.get(__ret__, 'etag'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        state=pulumi.get(__ret__, 'state'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        topic_id=pulumi.get(__ret__, 'topic_id'))


@_utilities.lift_output_func(get_subscription)
def get_subscription_output(subscription_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    This data source provides details about a specific Subscription resource in Oracle Cloud Infrastructure Notifications service.

    Gets the specified subscription's configuration information.

    Transactions Per Minute (TPM) per-tenancy limit for this operation: 60.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription = oci.Ons.get_subscription(subscription_id=test_subscription_oci_ons_subscription["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription to retrieve.
    """
    ...
