# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAwrHubAwrSnapshotsResult',
    'AwaitableGetAwrHubAwrSnapshotsResult',
    'get_awr_hub_awr_snapshots',
    'get_awr_hub_awr_snapshots_output',
]

@pulumi.output_type
class GetAwrHubAwrSnapshotsResult:
    """
    A collection of values returned by getAwrHubAwrSnapshots.
    """
    def __init__(__self__, awr_hub_id=None, awr_snapshot_collections=None, awr_source_database_identifier=None, filters=None, id=None, time_greater_than_or_equal_to=None, time_less_than_or_equal_to=None):
        if awr_hub_id and not isinstance(awr_hub_id, str):
            raise TypeError("Expected argument 'awr_hub_id' to be a str")
        pulumi.set(__self__, "awr_hub_id", awr_hub_id)
        if awr_snapshot_collections and not isinstance(awr_snapshot_collections, list):
            raise TypeError("Expected argument 'awr_snapshot_collections' to be a list")
        pulumi.set(__self__, "awr_snapshot_collections", awr_snapshot_collections)
        if awr_source_database_identifier and not isinstance(awr_source_database_identifier, str):
            raise TypeError("Expected argument 'awr_source_database_identifier' to be a str")
        pulumi.set(__self__, "awr_source_database_identifier", awr_source_database_identifier)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if time_greater_than_or_equal_to and not isinstance(time_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_greater_than_or_equal_to", time_greater_than_or_equal_to)
        if time_less_than_or_equal_to and not isinstance(time_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_less_than_or_equal_to", time_less_than_or_equal_to)

    @property
    @pulumi.getter(name="awrHubId")
    def awr_hub_id(self) -> str:
        return pulumi.get(self, "awr_hub_id")

    @property
    @pulumi.getter(name="awrSnapshotCollections")
    def awr_snapshot_collections(self) -> Sequence['outputs.GetAwrHubAwrSnapshotsAwrSnapshotCollectionResult']:
        """
        The list of awr_snapshot_collection.
        """
        return pulumi.get(self, "awr_snapshot_collections")

    @property
    @pulumi.getter(name="awrSourceDatabaseIdentifier")
    def awr_source_database_identifier(self) -> str:
        return pulumi.get(self, "awr_source_database_identifier")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAwrHubAwrSnapshotsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="timeGreaterThanOrEqualTo")
    def time_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeLessThanOrEqualTo")
    def time_less_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_less_than_or_equal_to")


class AwaitableGetAwrHubAwrSnapshotsResult(GetAwrHubAwrSnapshotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwrHubAwrSnapshotsResult(
            awr_hub_id=self.awr_hub_id,
            awr_snapshot_collections=self.awr_snapshot_collections,
            awr_source_database_identifier=self.awr_source_database_identifier,
            filters=self.filters,
            id=self.id,
            time_greater_than_or_equal_to=self.time_greater_than_or_equal_to,
            time_less_than_or_equal_to=self.time_less_than_or_equal_to)


def get_awr_hub_awr_snapshots(awr_hub_id: Optional[str] = None,
                              awr_source_database_identifier: Optional[str] = None,
                              filters: Optional[Sequence[pulumi.InputType['GetAwrHubAwrSnapshotsFilterArgs']]] = None,
                              time_greater_than_or_equal_to: Optional[str] = None,
                              time_less_than_or_equal_to: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwrHubAwrSnapshotsResult:
    """
    This data source provides the list of Awr Hub Awr Snapshots in Oracle Cloud Infrastructure Opsi service.

    Lists AWR snapshots for the specified source database in the AWR hub. The difference between the timeGreaterThanOrEqualTo and timeLessThanOrEqualTo should not exceed an elapsed range of 1 day.
    The timeGreaterThanOrEqualTo & timeLessThanOrEqualTo params are optional. If these params are not provided, by default last 1 day snapshots will be returned.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_awr_hub_awr_snapshots = oci.Opsi.get_awr_hub_awr_snapshots(awr_hub_id=test_awr_hub["id"],
        awr_source_database_identifier=awr_hub_awr_snapshot_awr_source_database_identifier,
        time_greater_than_or_equal_to=awr_hub_awr_snapshot_time_greater_than_or_equal_to,
        time_less_than_or_equal_to=awr_hub_awr_snapshot_time_less_than_or_equal_to)
    ```
    <!--End PulumiCodeChooser -->


    :param str awr_hub_id: Unique Awr Hub identifier
    :param str awr_source_database_identifier: AWR source database identifier.
    :param str time_greater_than_or_equal_to: The optional greater than or equal to query parameter to filter the timestamp. The timestamp format to be followed is: YYYY-MM-DDTHH:MM:SSZ, example 2020-12-03T19:00:53Z
    :param str time_less_than_or_equal_to: The optional less than or equal to query parameter to filter the timestamp. The timestamp format to be followed is: YYYY-MM-DDTHH:MM:SSZ, example 2020-12-03T19:00:53Z
    """
    __args__ = dict()
    __args__['awrHubId'] = awr_hub_id
    __args__['awrSourceDatabaseIdentifier'] = awr_source_database_identifier
    __args__['filters'] = filters
    __args__['timeGreaterThanOrEqualTo'] = time_greater_than_or_equal_to
    __args__['timeLessThanOrEqualTo'] = time_less_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getAwrHubAwrSnapshots:getAwrHubAwrSnapshots', __args__, opts=opts, typ=GetAwrHubAwrSnapshotsResult).value

    return AwaitableGetAwrHubAwrSnapshotsResult(
        awr_hub_id=pulumi.get(__ret__, 'awr_hub_id'),
        awr_snapshot_collections=pulumi.get(__ret__, 'awr_snapshot_collections'),
        awr_source_database_identifier=pulumi.get(__ret__, 'awr_source_database_identifier'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        time_greater_than_or_equal_to=pulumi.get(__ret__, 'time_greater_than_or_equal_to'),
        time_less_than_or_equal_to=pulumi.get(__ret__, 'time_less_than_or_equal_to'))


@_utilities.lift_output_func(get_awr_hub_awr_snapshots)
def get_awr_hub_awr_snapshots_output(awr_hub_id: Optional[pulumi.Input[str]] = None,
                                     awr_source_database_identifier: Optional[pulumi.Input[str]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAwrHubAwrSnapshotsFilterArgs']]]]] = None,
                                     time_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                     time_less_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAwrHubAwrSnapshotsResult]:
    """
    This data source provides the list of Awr Hub Awr Snapshots in Oracle Cloud Infrastructure Opsi service.

    Lists AWR snapshots for the specified source database in the AWR hub. The difference between the timeGreaterThanOrEqualTo and timeLessThanOrEqualTo should not exceed an elapsed range of 1 day.
    The timeGreaterThanOrEqualTo & timeLessThanOrEqualTo params are optional. If these params are not provided, by default last 1 day snapshots will be returned.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_awr_hub_awr_snapshots = oci.Opsi.get_awr_hub_awr_snapshots(awr_hub_id=test_awr_hub["id"],
        awr_source_database_identifier=awr_hub_awr_snapshot_awr_source_database_identifier,
        time_greater_than_or_equal_to=awr_hub_awr_snapshot_time_greater_than_or_equal_to,
        time_less_than_or_equal_to=awr_hub_awr_snapshot_time_less_than_or_equal_to)
    ```
    <!--End PulumiCodeChooser -->


    :param str awr_hub_id: Unique Awr Hub identifier
    :param str awr_source_database_identifier: AWR source database identifier.
    :param str time_greater_than_or_equal_to: The optional greater than or equal to query parameter to filter the timestamp. The timestamp format to be followed is: YYYY-MM-DDTHH:MM:SSZ, example 2020-12-03T19:00:53Z
    :param str time_less_than_or_equal_to: The optional less than or equal to query parameter to filter the timestamp. The timestamp format to be followed is: YYYY-MM-DDTHH:MM:SSZ, example 2020-12-03T19:00:53Z
    """
    ...
