# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetProfileLevelResult',
    'AwaitableGetProfileLevelResult',
    'get_profile_level',
    'get_profile_level_output',
]

@pulumi.output_type
class GetProfileLevelResult:
    """
    A collection of values returned by getProfileLevel.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, id=None, items=None, name=None, recommendation_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recommendation_name and not isinstance(recommendation_name, str):
            raise TypeError("Expected argument 'recommendation_name' to be a str")
        pulumi.set(__self__, "recommendation_name", recommendation_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> bool:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProfileLevelItemResult']:
        """
        A collection of profile levels.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A unique name for the profile level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> Optional[str]:
        """
        The name of the recommendation this profile level applies to.
        """
        return pulumi.get(self, "recommendation_name")


class AwaitableGetProfileLevelResult(GetProfileLevelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProfileLevelResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            id=self.id,
            items=self.items,
            name=self.name,
            recommendation_name=self.recommendation_name)


def get_profile_level(compartment_id: Optional[str] = None,
                      compartment_id_in_subtree: Optional[bool] = None,
                      name: Optional[str] = None,
                      recommendation_name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProfileLevelResult:
    """
    This data source provides details about a specific Profile Level resource in Oracle Cloud Infrastructure Optimizer service.

    Lists the existing profile levels.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_profile_level = oci.Optimizer.get_profile_level(compartment_id=compartment_id,
        compartment_id_in_subtree=profile_level_compartment_id_in_subtree,
        name=profile_level_name,
        recommendation_name=test_recommendation["name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment.
    :param bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
           
           Can only be set to true when performing ListCompartments on the tenancy (root compartment).
    :param str name: Optional. A filter that returns results that match the name specified.
    :param str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['name'] = name
    __args__['recommendationName'] = recommendation_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getProfileLevel:getProfileLevel', __args__, opts=opts, typ=GetProfileLevelResult).value

    return AwaitableGetProfileLevelResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        name=pulumi.get(__ret__, 'name'),
        recommendation_name=pulumi.get(__ret__, 'recommendation_name'))


@_utilities.lift_output_func(get_profile_level)
def get_profile_level_output(compartment_id: Optional[pulumi.Input[str]] = None,
                             compartment_id_in_subtree: Optional[pulumi.Input[bool]] = None,
                             name: Optional[pulumi.Input[Optional[str]]] = None,
                             recommendation_name: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProfileLevelResult]:
    """
    This data source provides details about a specific Profile Level resource in Oracle Cloud Infrastructure Optimizer service.

    Lists the existing profile levels.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_profile_level = oci.Optimizer.get_profile_level(compartment_id=compartment_id,
        compartment_id_in_subtree=profile_level_compartment_id_in_subtree,
        name=profile_level_name,
        recommendation_name=test_recommendation["name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment.
    :param bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
           
           Can only be set to true when performing ListCompartments on the tenancy (root compartment).
    :param str name: Optional. A filter that returns results that match the name specified.
    :param str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
    """
    ...
