# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRecommendationResult',
    'AwaitableGetRecommendationResult',
    'get_recommendation',
    'get_recommendation_output',
]

@pulumi.output_type
class GetRecommendationResult:
    """
    A collection of values returned by getRecommendation.
    """
    def __init__(__self__, category_id=None, compartment_id=None, description=None, estimated_cost_saving=None, extended_metadata=None, id=None, importance=None, name=None, recommendation_id=None, resource_counts=None, state=None, status=None, supported_levels=None, time_created=None, time_status_begin=None, time_status_end=None, time_updated=None):
        if category_id and not isinstance(category_id, str):
            raise TypeError("Expected argument 'category_id' to be a str")
        pulumi.set(__self__, "category_id", category_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if estimated_cost_saving and not isinstance(estimated_cost_saving, float):
            raise TypeError("Expected argument 'estimated_cost_saving' to be a float")
        pulumi.set(__self__, "estimated_cost_saving", estimated_cost_saving)
        if extended_metadata and not isinstance(extended_metadata, dict):
            raise TypeError("Expected argument 'extended_metadata' to be a dict")
        pulumi.set(__self__, "extended_metadata", extended_metadata)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if importance and not isinstance(importance, str):
            raise TypeError("Expected argument 'importance' to be a str")
        pulumi.set(__self__, "importance", importance)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recommendation_id and not isinstance(recommendation_id, str):
            raise TypeError("Expected argument 'recommendation_id' to be a str")
        pulumi.set(__self__, "recommendation_id", recommendation_id)
        if resource_counts and not isinstance(resource_counts, list):
            raise TypeError("Expected argument 'resource_counts' to be a list")
        pulumi.set(__self__, "resource_counts", resource_counts)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if supported_levels and not isinstance(supported_levels, list):
            raise TypeError("Expected argument 'supported_levels' to be a list")
        pulumi.set(__self__, "supported_levels", supported_levels)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_status_begin and not isinstance(time_status_begin, str):
            raise TypeError("Expected argument 'time_status_begin' to be a str")
        pulumi.set(__self__, "time_status_begin", time_status_begin)
        if time_status_end and not isinstance(time_status_end, str):
            raise TypeError("Expected argument 'time_status_end' to be a str")
        pulumi.set(__self__, "time_status_end", time_status_end)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> str:
        """
        The unique OCID associated with the category.
        """
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the tenancy. The tenancy is the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Text describing the recommendation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="estimatedCostSaving")
    def estimated_cost_saving(self) -> float:
        """
        The estimated cost savings, in dollars, for the recommendation.
        """
        return pulumi.get(self, "estimated_cost_saving")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Mapping[str, Any]:
        """
        Additional metadata key/value pairs for the recommendation.
        """
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique OCID associated with the recommendation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def importance(self) -> str:
        """
        The level of importance assigned to the recommendation.
        """
        return pulumi.get(self, "importance")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the profile level.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationId")
    def recommendation_id(self) -> str:
        return pulumi.get(self, "recommendation_id")

    @property
    @pulumi.getter(name="resourceCounts")
    def resource_counts(self) -> Sequence['outputs.GetRecommendationResourceCountResult']:
        """
        An array of `ResourceCount` objects grouped by the status of the resource actions.
        """
        return pulumi.get(self, "resource_counts")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The recommendation's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the recommendation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportedLevels")
    def supported_levels(self) -> Sequence['outputs.GetRecommendationSupportedLevelResult']:
        """
        Optional. The profile levels supported by a recommendation. For example, profile level values could be `Low`, `Medium`, and `High`. Not all recommendations support this field.
        """
        return pulumi.get(self, "supported_levels")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the recommendation details were created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStatusBegin")
    def time_status_begin(self) -> str:
        """
        The date and time that the recommendation entered its current status. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_begin")

    @property
    @pulumi.getter(name="timeStatusEnd")
    def time_status_end(self) -> str:
        """
        The date and time the current status will change. The format is defined by RFC3339.
        """
        return pulumi.get(self, "time_status_end")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the recommendation details were last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetRecommendationResult(GetRecommendationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecommendationResult(
            category_id=self.category_id,
            compartment_id=self.compartment_id,
            description=self.description,
            estimated_cost_saving=self.estimated_cost_saving,
            extended_metadata=self.extended_metadata,
            id=self.id,
            importance=self.importance,
            name=self.name,
            recommendation_id=self.recommendation_id,
            resource_counts=self.resource_counts,
            state=self.state,
            status=self.status,
            supported_levels=self.supported_levels,
            time_created=self.time_created,
            time_status_begin=self.time_status_begin,
            time_status_end=self.time_status_end,
            time_updated=self.time_updated)


def get_recommendation(recommendation_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecommendationResult:
    """
    This data source provides details about a specific Recommendation resource in Oracle Cloud Infrastructure Optimizer service.

    Gets the recommendation for the specified OCID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_recommendation = oci.Optimizer.get_recommendation(recommendation_id=test_recommendation_oci_optimizer_recommendation["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str recommendation_id: The unique OCID associated with the recommendation.
    """
    __args__ = dict()
    __args__['recommendationId'] = recommendation_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getRecommendation:getRecommendation', __args__, opts=opts, typ=GetRecommendationResult).value

    return AwaitableGetRecommendationResult(
        category_id=pulumi.get(__ret__, 'category_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        description=pulumi.get(__ret__, 'description'),
        estimated_cost_saving=pulumi.get(__ret__, 'estimated_cost_saving'),
        extended_metadata=pulumi.get(__ret__, 'extended_metadata'),
        id=pulumi.get(__ret__, 'id'),
        importance=pulumi.get(__ret__, 'importance'),
        name=pulumi.get(__ret__, 'name'),
        recommendation_id=pulumi.get(__ret__, 'recommendation_id'),
        resource_counts=pulumi.get(__ret__, 'resource_counts'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        supported_levels=pulumi.get(__ret__, 'supported_levels'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_status_begin=pulumi.get(__ret__, 'time_status_begin'),
        time_status_end=pulumi.get(__ret__, 'time_status_end'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_recommendation)
def get_recommendation_output(recommendation_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRecommendationResult]:
    """
    This data source provides details about a specific Recommendation resource in Oracle Cloud Infrastructure Optimizer service.

    Gets the recommendation for the specified OCID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_recommendation = oci.Optimizer.get_recommendation(recommendation_id=test_recommendation_oci_optimizer_recommendation["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str recommendation_id: The unique OCID associated with the recommendation.
    """
    ...
