# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRecommendationStrategiesResult',
    'AwaitableGetRecommendationStrategiesResult',
    'get_recommendation_strategies',
    'get_recommendation_strategies_output',
]

@pulumi.output_type
class GetRecommendationStrategiesResult:
    """
    A collection of values returned by getRecommendationStrategies.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, name=None, recommendation_name=None, recommendation_strategy_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if recommendation_name and not isinstance(recommendation_name, str):
            raise TypeError("Expected argument 'recommendation_name' to be a str")
        pulumi.set(__self__, "recommendation_name", recommendation_name)
        if recommendation_strategy_collections and not isinstance(recommendation_strategy_collections, list):
            raise TypeError("Expected argument 'recommendation_strategy_collections' to be a list")
        pulumi.set(__self__, "recommendation_strategy_collections", recommendation_strategy_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> bool:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRecommendationStrategiesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the strategy parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recommendationName")
    def recommendation_name(self) -> Optional[str]:
        return pulumi.get(self, "recommendation_name")

    @property
    @pulumi.getter(name="recommendationStrategyCollections")
    def recommendation_strategy_collections(self) -> Sequence['outputs.GetRecommendationStrategiesRecommendationStrategyCollectionResult']:
        """
        The list of recommendation_strategy_collection.
        """
        return pulumi.get(self, "recommendation_strategy_collections")


class AwaitableGetRecommendationStrategiesResult(GetRecommendationStrategiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecommendationStrategiesResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            name=self.name,
            recommendation_name=self.recommendation_name,
            recommendation_strategy_collections=self.recommendation_strategy_collections)


def get_recommendation_strategies(compartment_id: Optional[str] = None,
                                  compartment_id_in_subtree: Optional[bool] = None,
                                  filters: Optional[Sequence[pulumi.InputType['GetRecommendationStrategiesFilterArgs']]] = None,
                                  name: Optional[str] = None,
                                  recommendation_name: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecommendationStrategiesResult:
    """
    This data source provides the list of Recommendation Strategies in Oracle Cloud Infrastructure Optimizer service.

    Lists the existing strategies.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_recommendation_strategies = oci.Optimizer.get_recommendation_strategies(compartment_id=compartment_id,
        compartment_id_in_subtree=recommendation_strategy_compartment_id_in_subtree,
        name=recommendation_strategy_name,
        recommendation_name=test_recommendation["name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment.
    :param bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
           
           Can only be set to true when performing ListCompartments on the tenancy (root compartment).
    :param str name: Optional. A filter that returns results that match the name specified.
    :param str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['recommendationName'] = recommendation_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Optimizer/getRecommendationStrategies:getRecommendationStrategies', __args__, opts=opts, typ=GetRecommendationStrategiesResult).value

    return AwaitableGetRecommendationStrategiesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        recommendation_name=pulumi.get(__ret__, 'recommendation_name'),
        recommendation_strategy_collections=pulumi.get(__ret__, 'recommendation_strategy_collections'))


@_utilities.lift_output_func(get_recommendation_strategies)
def get_recommendation_strategies_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                         compartment_id_in_subtree: Optional[pulumi.Input[bool]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetRecommendationStrategiesFilterArgs']]]]] = None,
                                         name: Optional[pulumi.Input[Optional[str]]] = None,
                                         recommendation_name: Optional[pulumi.Input[Optional[str]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRecommendationStrategiesResult]:
    """
    This data source provides the list of Recommendation Strategies in Oracle Cloud Infrastructure Optimizer service.

    Lists the existing strategies.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_recommendation_strategies = oci.Optimizer.get_recommendation_strategies(compartment_id=compartment_id,
        compartment_id_in_subtree=recommendation_strategy_compartment_id_in_subtree,
        name=recommendation_strategy_name,
        recommendation_name=test_recommendation["name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment.
    :param bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned depending on the the setting of `accessLevel`.
           
           Can only be set to true when performing ListCompartments on the tenancy (root compartment).
    :param str name: Optional. A filter that returns results that match the name specified.
    :param str recommendation_name: Optional. A filter that returns results that match the recommendation name specified.
    """
    ...
