# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LifecycleEnvironmentArgs', 'LifecycleEnvironment']

@pulumi.input_type
class LifecycleEnvironmentArgs:
    def __init__(__self__, *,
                 arch_type: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 os_family: pulumi.Input[str],
                 stages: pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageArgs']]],
                 vendor_name: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a LifecycleEnvironment resource.
        :param pulumi.Input[str] arch_type: The CPU architecture of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the lifecycle environment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] os_family: The operating system type of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageArgs']]] stages: (Updatable) User specified list of ranked lifecycle stages to be created for the lifecycle environment.
        :param pulumi.Input[str] vendor_name: The software source vendor name.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) User specified information about the lifecycle environment.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "arch_type", arch_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "os_family", os_family)
        pulumi.set(__self__, "stages", stages)
        pulumi.set(__self__, "vendor_name", vendor_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Input[str]:
        """
        The CPU architecture of the managed instance(s) in the lifecycle environment.
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the tenancy containing the lifecycle environment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Input[str]:
        """
        The operating system type of the managed instance(s) in the lifecycle environment.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageArgs']]]:
        """
        (Updatable) User specified list of ranked lifecycle stages to be created for the lifecycle environment.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageArgs']]]):
        pulumi.set(self, "stages", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> pulumi.Input[str]:
        """
        The software source vendor name.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vendor_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User specified information about the lifecycle environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _LifecycleEnvironmentState:
    def __init__(__self__, *,
                 arch_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentManagedInstanceIdArgs']]]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_modified: Optional[pulumi.Input[str]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LifecycleEnvironment resources.
        :param pulumi.Input[str] arch_type: The CPU architecture of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the lifecycle environment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) User specified information about the lifecycle environment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentManagedInstanceIdArgs']]] managed_instance_ids: The list of managed instances specified lifecycle stage.
        :param pulumi.Input[str] os_family: The operating system type of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageArgs']]] stages: (Updatable) User specified list of ranked lifecycle stages to be created for the lifecycle environment.
        :param pulumi.Input[str] state: The current state of the lifecycle environment.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the lifecycle environment was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_modified: The time the lifecycle environment was last modified. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] vendor_name: The software source vendor name.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if managed_instance_ids is not None:
            pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_modified is not None:
            pulumi.set(__self__, "time_modified", time_modified)
        if vendor_name is not None:
            pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The CPU architecture of the managed instance(s) in the lifecycle environment.
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the tenancy containing the lifecycle environment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User specified information about the lifecycle environment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentManagedInstanceIdArgs']]]]:
        """
        The list of managed instances specified lifecycle stage.
        """
        return pulumi.get(self, "managed_instance_ids")

    @managed_instance_ids.setter
    def managed_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentManagedInstanceIdArgs']]]]):
        pulumi.set(self, "managed_instance_ids", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system type of the managed instance(s) in the lifecycle environment.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageArgs']]]]:
        """
        (Updatable) User specified list of ranked lifecycle stages to be created for the lifecycle environment.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LifecycleEnvironmentStageArgs']]]]):
        pulumi.set(self, "stages", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the lifecycle environment.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the lifecycle environment was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> Optional[pulumi.Input[str]]:
        """
        The time the lifecycle environment was last modified. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_modified")

    @time_modified.setter
    def time_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_modified", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The software source vendor name.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_name", value)


class LifecycleEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arch_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LifecycleEnvironmentStageArgs']]]]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Lifecycle Environment resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a new lifecycle environment.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_lifecycle_environment = oci.os_management_hub.LifecycleEnvironment("test_lifecycle_environment",
            arch_type=lifecycle_environment_arch_type,
            compartment_id=compartment_id,
            display_name=lifecycle_environment_display_name,
            os_family=lifecycle_environment_os_family,
            stages=[oci.os_management_hub.LifecycleEnvironmentStageArgs(
                display_name=lifecycle_environment_stages_display_name,
                rank=lifecycle_environment_stages_rank,
                defined_tags={
                    "Operations.CostCenter": "42",
                },
                freeform_tags={
                    "Department": "Finance",
                },
            )],
            vendor_name=lifecycle_environment_vendor_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=lifecycle_environment_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        LifecycleEnvironments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/lifecycleEnvironment:LifecycleEnvironment test_lifecycle_environment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arch_type: The CPU architecture of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the lifecycle environment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) User specified information about the lifecycle environment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] os_family: The operating system type of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LifecycleEnvironmentStageArgs']]]] stages: (Updatable) User specified list of ranked lifecycle stages to be created for the lifecycle environment.
        :param pulumi.Input[str] vendor_name: The software source vendor name.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LifecycleEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Lifecycle Environment resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a new lifecycle environment.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_lifecycle_environment = oci.os_management_hub.LifecycleEnvironment("test_lifecycle_environment",
            arch_type=lifecycle_environment_arch_type,
            compartment_id=compartment_id,
            display_name=lifecycle_environment_display_name,
            os_family=lifecycle_environment_os_family,
            stages=[oci.os_management_hub.LifecycleEnvironmentStageArgs(
                display_name=lifecycle_environment_stages_display_name,
                rank=lifecycle_environment_stages_rank,
                defined_tags={
                    "Operations.CostCenter": "42",
                },
                freeform_tags={
                    "Department": "Finance",
                },
            )],
            vendor_name=lifecycle_environment_vendor_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=lifecycle_environment_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        LifecycleEnvironments can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/lifecycleEnvironment:LifecycleEnvironment test_lifecycle_environment "id"
        ```

        :param str resource_name: The name of the resource.
        :param LifecycleEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LifecycleEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arch_type: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 os_family: Optional[pulumi.Input[str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LifecycleEnvironmentStageArgs']]]]] = None,
                 vendor_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LifecycleEnvironmentArgs.__new__(LifecycleEnvironmentArgs)

            if arch_type is None and not opts.urn:
                raise TypeError("Missing required property 'arch_type'")
            __props__.__dict__["arch_type"] = arch_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if os_family is None and not opts.urn:
                raise TypeError("Missing required property 'os_family'")
            __props__.__dict__["os_family"] = os_family
            if stages is None and not opts.urn:
                raise TypeError("Missing required property 'stages'")
            __props__.__dict__["stages"] = stages
            if vendor_name is None and not opts.urn:
                raise TypeError("Missing required property 'vendor_name'")
            __props__.__dict__["vendor_name"] = vendor_name
            __props__.__dict__["managed_instance_ids"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_modified"] = None
        super(LifecycleEnvironment, __self__).__init__(
            'oci:OsManagementHub/lifecycleEnvironment:LifecycleEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arch_type: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LifecycleEnvironmentManagedInstanceIdArgs']]]]] = None,
            os_family: Optional[pulumi.Input[str]] = None,
            stages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LifecycleEnvironmentStageArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_modified: Optional[pulumi.Input[str]] = None,
            vendor_name: Optional[pulumi.Input[str]] = None) -> 'LifecycleEnvironment':
        """
        Get an existing LifecycleEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arch_type: The CPU architecture of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the lifecycle environment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) User specified information about the lifecycle environment.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LifecycleEnvironmentManagedInstanceIdArgs']]]] managed_instance_ids: The list of managed instances specified lifecycle stage.
        :param pulumi.Input[str] os_family: The operating system type of the managed instance(s) in the lifecycle environment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LifecycleEnvironmentStageArgs']]]] stages: (Updatable) User specified list of ranked lifecycle stages to be created for the lifecycle environment.
        :param pulumi.Input[str] state: The current state of the lifecycle environment.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the lifecycle environment was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_modified: The time the lifecycle environment was last modified. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] vendor_name: The software source vendor name.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LifecycleEnvironmentState.__new__(_LifecycleEnvironmentState)

        __props__.__dict__["arch_type"] = arch_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["managed_instance_ids"] = managed_instance_ids
        __props__.__dict__["os_family"] = os_family
        __props__.__dict__["stages"] = stages
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_modified"] = time_modified
        __props__.__dict__["vendor_name"] = vendor_name
        return LifecycleEnvironment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Output[str]:
        """
        The CPU architecture of the managed instance(s) in the lifecycle environment.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the tenancy containing the lifecycle environment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) User specified information about the lifecycle environment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> pulumi.Output[Sequence['outputs.LifecycleEnvironmentManagedInstanceId']]:
        """
        The list of managed instances specified lifecycle stage.
        """
        return pulumi.get(self, "managed_instance_ids")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output[str]:
        """
        The operating system type of the managed instance(s) in the lifecycle environment.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Output[Sequence['outputs.LifecycleEnvironmentStage']]:
        """
        (Updatable) User specified list of ranked lifecycle stages to be created for the lifecycle environment.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the lifecycle environment.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the lifecycle environment was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> pulumi.Output[str]:
        """
        The time the lifecycle environment was last modified. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> pulumi.Output[str]:
        """
        The software source vendor name.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

