# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddressActionVerificationArgs', 'AddressActionVerification']

@pulumi.input_type
class AddressActionVerificationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 osp_home_region: pulumi.Input[str],
                 address_key: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 contributor_class: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 county: Optional[pulumi.Input[str]] = None,
                 department_name: Optional[pulumi.Input[str]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 internal_number: Optional[pulumi.Input[str]] = None,
                 job_title: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 line1: Optional[pulumi.Input[str]] = None,
                 line2: Optional[pulumi.Input[str]] = None,
                 line3: Optional[pulumi.Input[str]] = None,
                 line4: Optional[pulumi.Input[str]] = None,
                 middle_name: Optional[pulumi.Input[str]] = None,
                 municipal_inscription: Optional[pulumi.Input[str]] = None,
                 phone_country_code: Optional[pulumi.Input[str]] = None,
                 phone_number: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_inscription: Optional[pulumi.Input[str]] = None,
                 street_name: Optional[pulumi.Input[str]] = None,
                 street_number: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AddressActionVerification resource.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] osp_home_region: The home region's public name of the logged in user.
        :param pulumi.Input[str] address_key: Address identifier.
        :param pulumi.Input[str] city: Name of the city.
        :param pulumi.Input[str] company_name: Name of the customer company.
        :param pulumi.Input[str] contributor_class: Contributor class of the customer company.
        :param pulumi.Input[str] country: Country of the address.
        :param pulumi.Input[str] county: County of the address.
        :param pulumi.Input[str] department_name: Department name of the customer company.
        :param pulumi.Input[str] email_address: Contact person email address.
        :param pulumi.Input[str] first_name: First name of the contact person.
        :param pulumi.Input[str] internal_number: Internal number of the customer company.
        :param pulumi.Input[str] job_title: Job title of the contact person.
        :param pulumi.Input[str] last_name: Last name of the contact person.
        :param pulumi.Input[str] line1: Address line 1.
        :param pulumi.Input[str] line2: Address line 2.
        :param pulumi.Input[str] line3: Address line 3.
        :param pulumi.Input[str] line4: Address line 4.
        :param pulumi.Input[str] middle_name: Middle name of the contact person.
        :param pulumi.Input[str] municipal_inscription: Municipal Inscription.
        :param pulumi.Input[str] phone_country_code: Phone country code of the contact person.
        :param pulumi.Input[str] phone_number: Phone number of the contact person.
        :param pulumi.Input[str] postal_code: Post code of the address.
        :param pulumi.Input[str] province: Province of the address.
        :param pulumi.Input[str] state: State of the address.
        :param pulumi.Input[str] state_inscription: State Inscription.
        :param pulumi.Input[str] street_name: Street name of the address.
        :param pulumi.Input[str] street_number: Street number of the address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "osp_home_region", osp_home_region)
        if address_key is not None:
            pulumi.set(__self__, "address_key", address_key)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if contributor_class is not None:
            pulumi.set(__self__, "contributor_class", contributor_class)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if department_name is not None:
            pulumi.set(__self__, "department_name", department_name)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if internal_number is not None:
            pulumi.set(__self__, "internal_number", internal_number)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if line1 is not None:
            pulumi.set(__self__, "line1", line1)
        if line2 is not None:
            pulumi.set(__self__, "line2", line2)
        if line3 is not None:
            pulumi.set(__self__, "line3", line3)
        if line4 is not None:
            pulumi.set(__self__, "line4", line4)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if municipal_inscription is not None:
            pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        if phone_country_code is not None:
            pulumi.set(__self__, "phone_country_code", phone_country_code)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_inscription is not None:
            pulumi.set(__self__, "state_inscription", state_inscription)
        if street_name is not None:
            pulumi.set(__self__, "street_name", street_name)
        if street_number is not None:
            pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> pulumi.Input[str]:
        """
        The home region's public name of the logged in user.
        """
        return pulumi.get(self, "osp_home_region")

    @osp_home_region.setter
    def osp_home_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "osp_home_region", value)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> Optional[pulumi.Input[str]]:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @address_key.setter
    def address_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_key", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @company_name.setter
    def company_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "company_name", value)

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> Optional[pulumi.Input[str]]:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @contributor_class.setter
    def contributor_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contributor_class", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def county(self) -> Optional[pulumi.Input[str]]:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @county.setter
    def county(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "county", value)

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> Optional[pulumi.Input[str]]:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @department_name.setter
    def department_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "department_name", value)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[str]]:
        """
        Contact person email address.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        First name of the contact person.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> Optional[pulumi.Input[str]]:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @internal_number.setter
    def internal_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_number", value)

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[str]]:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_title", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        Last name of the contact person.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def line1(self) -> Optional[pulumi.Input[str]]:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @line1.setter
    def line1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line1", value)

    @property
    @pulumi.getter
    def line2(self) -> Optional[pulumi.Input[str]]:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @line2.setter
    def line2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line2", value)

    @property
    @pulumi.getter
    def line3(self) -> Optional[pulumi.Input[str]]:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @line3.setter
    def line3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line3", value)

    @property
    @pulumi.getter
    def line4(self) -> Optional[pulumi.Input[str]]:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @line4.setter
    def line4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line4", value)

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[pulumi.Input[str]]:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @middle_name.setter
    def middle_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "middle_name", value)

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> Optional[pulumi.Input[str]]:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @municipal_inscription.setter
    def municipal_inscription(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "municipal_inscription", value)

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> Optional[pulumi.Input[str]]:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @phone_country_code.setter
    def phone_country_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_country_code", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[str]]:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_number", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> Optional[pulumi.Input[str]]:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @state_inscription.setter
    def state_inscription(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_inscription", value)

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> Optional[pulumi.Input[str]]:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @street_name.setter
    def street_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_name", value)

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> Optional[pulumi.Input[str]]:
        """
        Street number of the address.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "street_number")

    @street_number.setter
    def street_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_number", value)


@pulumi.input_type
class _AddressActionVerificationState:
    def __init__(__self__, *,
                 address_key: Optional[pulumi.Input[str]] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input['AddressActionVerificationAddressArgs']]]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 contributor_class: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 county: Optional[pulumi.Input[str]] = None,
                 department_name: Optional[pulumi.Input[str]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 internal_number: Optional[pulumi.Input[str]] = None,
                 job_title: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 line1: Optional[pulumi.Input[str]] = None,
                 line2: Optional[pulumi.Input[str]] = None,
                 line3: Optional[pulumi.Input[str]] = None,
                 line4: Optional[pulumi.Input[str]] = None,
                 middle_name: Optional[pulumi.Input[str]] = None,
                 municipal_inscription: Optional[pulumi.Input[str]] = None,
                 osp_home_region: Optional[pulumi.Input[str]] = None,
                 phone_country_code: Optional[pulumi.Input[str]] = None,
                 phone_number: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 quality: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_inscription: Optional[pulumi.Input[str]] = None,
                 street_name: Optional[pulumi.Input[str]] = None,
                 street_number: Optional[pulumi.Input[str]] = None,
                 verification_code: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AddressActionVerification resources.
        :param pulumi.Input[str] address_key: Address identifier.
        :param pulumi.Input[Sequence[pulumi.Input['AddressActionVerificationAddressArgs']]] addresses: Address details model.
        :param pulumi.Input[str] city: Name of the city.
        :param pulumi.Input[str] company_name: Name of the customer company.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] contributor_class: Contributor class of the customer company.
        :param pulumi.Input[str] country: Country of the address.
        :param pulumi.Input[str] county: County of the address.
        :param pulumi.Input[str] department_name: Department name of the customer company.
        :param pulumi.Input[str] email_address: Contact person email address.
        :param pulumi.Input[str] first_name: First name of the contact person.
        :param pulumi.Input[str] internal_number: Internal number of the customer company.
        :param pulumi.Input[str] job_title: Job title of the contact person.
        :param pulumi.Input[str] last_name: Last name of the contact person.
        :param pulumi.Input[str] line1: Address line 1.
        :param pulumi.Input[str] line2: Address line 2.
        :param pulumi.Input[str] line3: Address line 3.
        :param pulumi.Input[str] line4: Address line 4.
        :param pulumi.Input[str] middle_name: Middle name of the contact person.
        :param pulumi.Input[str] municipal_inscription: Municipal Inscription.
        :param pulumi.Input[str] osp_home_region: The home region's public name of the logged in user.
        :param pulumi.Input[str] phone_country_code: Phone country code of the contact person.
        :param pulumi.Input[str] phone_number: Phone number of the contact person.
        :param pulumi.Input[str] postal_code: Post code of the address.
        :param pulumi.Input[str] province: Province of the address.
        :param pulumi.Input[str] quality: Address quality type.
        :param pulumi.Input[str] state: State of the address.
        :param pulumi.Input[str] state_inscription: State Inscription.
        :param pulumi.Input[str] street_name: Street name of the address.
        :param pulumi.Input[str] street_number: Street number of the address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] verification_code: Address verification code.
        """
        if address_key is not None:
            pulumi.set(__self__, "address_key", address_key)
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if company_name is not None:
            pulumi.set(__self__, "company_name", company_name)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if contributor_class is not None:
            pulumi.set(__self__, "contributor_class", contributor_class)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if county is not None:
            pulumi.set(__self__, "county", county)
        if department_name is not None:
            pulumi.set(__self__, "department_name", department_name)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if internal_number is not None:
            pulumi.set(__self__, "internal_number", internal_number)
        if job_title is not None:
            pulumi.set(__self__, "job_title", job_title)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if line1 is not None:
            pulumi.set(__self__, "line1", line1)
        if line2 is not None:
            pulumi.set(__self__, "line2", line2)
        if line3 is not None:
            pulumi.set(__self__, "line3", line3)
        if line4 is not None:
            pulumi.set(__self__, "line4", line4)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if municipal_inscription is not None:
            pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        if osp_home_region is not None:
            pulumi.set(__self__, "osp_home_region", osp_home_region)
        if phone_country_code is not None:
            pulumi.set(__self__, "phone_country_code", phone_country_code)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if postal_code is not None:
            pulumi.set(__self__, "postal_code", postal_code)
        if province is not None:
            pulumi.set(__self__, "province", province)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_inscription is not None:
            pulumi.set(__self__, "state_inscription", state_inscription)
        if street_name is not None:
            pulumi.set(__self__, "street_name", street_name)
        if street_number is not None:
            pulumi.set(__self__, "street_number", street_number)
        if verification_code is not None:
            pulumi.set(__self__, "verification_code", verification_code)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> Optional[pulumi.Input[str]]:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @address_key.setter
    def address_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_key", value)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddressActionVerificationAddressArgs']]]]:
        """
        Address details model.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddressActionVerificationAddressArgs']]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "city", value)

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @company_name.setter
    def company_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "company_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> Optional[pulumi.Input[str]]:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @contributor_class.setter
    def contributor_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contributor_class", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[str]]:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def county(self) -> Optional[pulumi.Input[str]]:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @county.setter
    def county(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "county", value)

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> Optional[pulumi.Input[str]]:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @department_name.setter
    def department_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "department_name", value)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[str]]:
        """
        Contact person email address.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        First name of the contact person.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> Optional[pulumi.Input[str]]:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @internal_number.setter
    def internal_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internal_number", value)

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> Optional[pulumi.Input[str]]:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @job_title.setter
    def job_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_title", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        Last name of the contact person.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def line1(self) -> Optional[pulumi.Input[str]]:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @line1.setter
    def line1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line1", value)

    @property
    @pulumi.getter
    def line2(self) -> Optional[pulumi.Input[str]]:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @line2.setter
    def line2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line2", value)

    @property
    @pulumi.getter
    def line3(self) -> Optional[pulumi.Input[str]]:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @line3.setter
    def line3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line3", value)

    @property
    @pulumi.getter
    def line4(self) -> Optional[pulumi.Input[str]]:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @line4.setter
    def line4(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line4", value)

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[pulumi.Input[str]]:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @middle_name.setter
    def middle_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "middle_name", value)

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> Optional[pulumi.Input[str]]:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @municipal_inscription.setter
    def municipal_inscription(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "municipal_inscription", value)

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> Optional[pulumi.Input[str]]:
        """
        The home region's public name of the logged in user.
        """
        return pulumi.get(self, "osp_home_region")

    @osp_home_region.setter
    def osp_home_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "osp_home_region", value)

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> Optional[pulumi.Input[str]]:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @phone_country_code.setter
    def phone_country_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_country_code", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[str]]:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phone_number", value)

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> Optional[pulumi.Input[str]]:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @postal_code.setter
    def postal_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postal_code", value)

    @property
    @pulumi.getter
    def province(self) -> Optional[pulumi.Input[str]]:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @province.setter
    def province(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "province", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[str]]:
        """
        Address quality type.
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> Optional[pulumi.Input[str]]:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @state_inscription.setter
    def state_inscription(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_inscription", value)

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> Optional[pulumi.Input[str]]:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @street_name.setter
    def street_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_name", value)

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> Optional[pulumi.Input[str]]:
        """
        Street number of the address.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "street_number")

    @street_number.setter
    def street_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "street_number", value)

    @property
    @pulumi.getter(name="verificationCode")
    def verification_code(self) -> Optional[pulumi.Input[str]]:
        """
        Address verification code.
        """
        return pulumi.get(self, "verification_code")

    @verification_code.setter
    def verification_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "verification_code", value)


class AddressActionVerification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_key: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 contributor_class: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 county: Optional[pulumi.Input[str]] = None,
                 department_name: Optional[pulumi.Input[str]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 internal_number: Optional[pulumi.Input[str]] = None,
                 job_title: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 line1: Optional[pulumi.Input[str]] = None,
                 line2: Optional[pulumi.Input[str]] = None,
                 line3: Optional[pulumi.Input[str]] = None,
                 line4: Optional[pulumi.Input[str]] = None,
                 middle_name: Optional[pulumi.Input[str]] = None,
                 municipal_inscription: Optional[pulumi.Input[str]] = None,
                 osp_home_region: Optional[pulumi.Input[str]] = None,
                 phone_country_code: Optional[pulumi.Input[str]] = None,
                 phone_number: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_inscription: Optional[pulumi.Input[str]] = None,
                 street_name: Optional[pulumi.Input[str]] = None,
                 street_number: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Address Action Verification resource in Oracle Cloud Infrastructure Osp Gateway service.

        Verify address

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_address_action_verification = oci.osp_gateway.AddressActionVerification("test_address_action_verification",
            compartment_id=compartment_id,
            osp_home_region=address_action_verification_osp_home_region,
            address_key=address_action_verification_address_key,
            city=address_action_verification_city,
            company_name=address_action_verification_company_name,
            contributor_class=address_action_verification_contributor_class,
            country=address_action_verification_country,
            county=address_action_verification_county,
            department_name=address_action_verification_department_name,
            email_address=address_action_verification_email_address,
            first_name=address_action_verification_first_name,
            internal_number=address_action_verification_internal_number,
            job_title=address_action_verification_job_title,
            last_name=address_action_verification_last_name,
            line1=address_action_verification_line1,
            line2=address_action_verification_line2,
            line3=address_action_verification_line3,
            line4=address_action_verification_line4,
            middle_name=address_action_verification_middle_name,
            municipal_inscription=address_action_verification_municipal_inscription,
            phone_country_code=address_action_verification_phone_country_code,
            phone_number=address_action_verification_phone_number,
            postal_code=address_action_verification_postal_code,
            province=address_action_verification_province,
            state=address_action_verification_state,
            state_inscription=address_action_verification_state_inscription,
            street_name=address_action_verification_street_name,
            street_number=address_action_verification_street_number)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        AddressActionVerifications can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OspGateway/addressActionVerification:AddressActionVerification test_address_action_verification "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_key: Address identifier.
        :param pulumi.Input[str] city: Name of the city.
        :param pulumi.Input[str] company_name: Name of the customer company.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] contributor_class: Contributor class of the customer company.
        :param pulumi.Input[str] country: Country of the address.
        :param pulumi.Input[str] county: County of the address.
        :param pulumi.Input[str] department_name: Department name of the customer company.
        :param pulumi.Input[str] email_address: Contact person email address.
        :param pulumi.Input[str] first_name: First name of the contact person.
        :param pulumi.Input[str] internal_number: Internal number of the customer company.
        :param pulumi.Input[str] job_title: Job title of the contact person.
        :param pulumi.Input[str] last_name: Last name of the contact person.
        :param pulumi.Input[str] line1: Address line 1.
        :param pulumi.Input[str] line2: Address line 2.
        :param pulumi.Input[str] line3: Address line 3.
        :param pulumi.Input[str] line4: Address line 4.
        :param pulumi.Input[str] middle_name: Middle name of the contact person.
        :param pulumi.Input[str] municipal_inscription: Municipal Inscription.
        :param pulumi.Input[str] osp_home_region: The home region's public name of the logged in user.
        :param pulumi.Input[str] phone_country_code: Phone country code of the contact person.
        :param pulumi.Input[str] phone_number: Phone number of the contact person.
        :param pulumi.Input[str] postal_code: Post code of the address.
        :param pulumi.Input[str] province: Province of the address.
        :param pulumi.Input[str] state: State of the address.
        :param pulumi.Input[str] state_inscription: State Inscription.
        :param pulumi.Input[str] street_name: Street name of the address.
        :param pulumi.Input[str] street_number: Street number of the address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddressActionVerificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Address Action Verification resource in Oracle Cloud Infrastructure Osp Gateway service.

        Verify address

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_address_action_verification = oci.osp_gateway.AddressActionVerification("test_address_action_verification",
            compartment_id=compartment_id,
            osp_home_region=address_action_verification_osp_home_region,
            address_key=address_action_verification_address_key,
            city=address_action_verification_city,
            company_name=address_action_verification_company_name,
            contributor_class=address_action_verification_contributor_class,
            country=address_action_verification_country,
            county=address_action_verification_county,
            department_name=address_action_verification_department_name,
            email_address=address_action_verification_email_address,
            first_name=address_action_verification_first_name,
            internal_number=address_action_verification_internal_number,
            job_title=address_action_verification_job_title,
            last_name=address_action_verification_last_name,
            line1=address_action_verification_line1,
            line2=address_action_verification_line2,
            line3=address_action_verification_line3,
            line4=address_action_verification_line4,
            middle_name=address_action_verification_middle_name,
            municipal_inscription=address_action_verification_municipal_inscription,
            phone_country_code=address_action_verification_phone_country_code,
            phone_number=address_action_verification_phone_number,
            postal_code=address_action_verification_postal_code,
            province=address_action_verification_province,
            state=address_action_verification_state,
            state_inscription=address_action_verification_state_inscription,
            street_name=address_action_verification_street_name,
            street_number=address_action_verification_street_number)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        AddressActionVerifications can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OspGateway/addressActionVerification:AddressActionVerification test_address_action_verification "id"
        ```

        :param str resource_name: The name of the resource.
        :param AddressActionVerificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressActionVerificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_key: Optional[pulumi.Input[str]] = None,
                 city: Optional[pulumi.Input[str]] = None,
                 company_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 contributor_class: Optional[pulumi.Input[str]] = None,
                 country: Optional[pulumi.Input[str]] = None,
                 county: Optional[pulumi.Input[str]] = None,
                 department_name: Optional[pulumi.Input[str]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 internal_number: Optional[pulumi.Input[str]] = None,
                 job_title: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 line1: Optional[pulumi.Input[str]] = None,
                 line2: Optional[pulumi.Input[str]] = None,
                 line3: Optional[pulumi.Input[str]] = None,
                 line4: Optional[pulumi.Input[str]] = None,
                 middle_name: Optional[pulumi.Input[str]] = None,
                 municipal_inscription: Optional[pulumi.Input[str]] = None,
                 osp_home_region: Optional[pulumi.Input[str]] = None,
                 phone_country_code: Optional[pulumi.Input[str]] = None,
                 phone_number: Optional[pulumi.Input[str]] = None,
                 postal_code: Optional[pulumi.Input[str]] = None,
                 province: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_inscription: Optional[pulumi.Input[str]] = None,
                 street_name: Optional[pulumi.Input[str]] = None,
                 street_number: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressActionVerificationArgs.__new__(AddressActionVerificationArgs)

            __props__.__dict__["address_key"] = address_key
            __props__.__dict__["city"] = city
            __props__.__dict__["company_name"] = company_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["contributor_class"] = contributor_class
            __props__.__dict__["country"] = country
            __props__.__dict__["county"] = county
            __props__.__dict__["department_name"] = department_name
            __props__.__dict__["email_address"] = email_address
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["internal_number"] = internal_number
            __props__.__dict__["job_title"] = job_title
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["line1"] = line1
            __props__.__dict__["line2"] = line2
            __props__.__dict__["line3"] = line3
            __props__.__dict__["line4"] = line4
            __props__.__dict__["middle_name"] = middle_name
            __props__.__dict__["municipal_inscription"] = municipal_inscription
            if osp_home_region is None and not opts.urn:
                raise TypeError("Missing required property 'osp_home_region'")
            __props__.__dict__["osp_home_region"] = osp_home_region
            __props__.__dict__["phone_country_code"] = phone_country_code
            __props__.__dict__["phone_number"] = phone_number
            __props__.__dict__["postal_code"] = postal_code
            __props__.__dict__["province"] = province
            __props__.__dict__["state"] = state
            __props__.__dict__["state_inscription"] = state_inscription
            __props__.__dict__["street_name"] = street_name
            __props__.__dict__["street_number"] = street_number
            __props__.__dict__["addresses"] = None
            __props__.__dict__["quality"] = None
            __props__.__dict__["verification_code"] = None
        super(AddressActionVerification, __self__).__init__(
            'oci:OspGateway/addressActionVerification:AddressActionVerification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_key: Optional[pulumi.Input[str]] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AddressActionVerificationAddressArgs']]]]] = None,
            city: Optional[pulumi.Input[str]] = None,
            company_name: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            contributor_class: Optional[pulumi.Input[str]] = None,
            country: Optional[pulumi.Input[str]] = None,
            county: Optional[pulumi.Input[str]] = None,
            department_name: Optional[pulumi.Input[str]] = None,
            email_address: Optional[pulumi.Input[str]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            internal_number: Optional[pulumi.Input[str]] = None,
            job_title: Optional[pulumi.Input[str]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            line1: Optional[pulumi.Input[str]] = None,
            line2: Optional[pulumi.Input[str]] = None,
            line3: Optional[pulumi.Input[str]] = None,
            line4: Optional[pulumi.Input[str]] = None,
            middle_name: Optional[pulumi.Input[str]] = None,
            municipal_inscription: Optional[pulumi.Input[str]] = None,
            osp_home_region: Optional[pulumi.Input[str]] = None,
            phone_country_code: Optional[pulumi.Input[str]] = None,
            phone_number: Optional[pulumi.Input[str]] = None,
            postal_code: Optional[pulumi.Input[str]] = None,
            province: Optional[pulumi.Input[str]] = None,
            quality: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_inscription: Optional[pulumi.Input[str]] = None,
            street_name: Optional[pulumi.Input[str]] = None,
            street_number: Optional[pulumi.Input[str]] = None,
            verification_code: Optional[pulumi.Input[str]] = None) -> 'AddressActionVerification':
        """
        Get an existing AddressActionVerification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_key: Address identifier.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AddressActionVerificationAddressArgs']]]] addresses: Address details model.
        :param pulumi.Input[str] city: Name of the city.
        :param pulumi.Input[str] company_name: Name of the customer company.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] contributor_class: Contributor class of the customer company.
        :param pulumi.Input[str] country: Country of the address.
        :param pulumi.Input[str] county: County of the address.
        :param pulumi.Input[str] department_name: Department name of the customer company.
        :param pulumi.Input[str] email_address: Contact person email address.
        :param pulumi.Input[str] first_name: First name of the contact person.
        :param pulumi.Input[str] internal_number: Internal number of the customer company.
        :param pulumi.Input[str] job_title: Job title of the contact person.
        :param pulumi.Input[str] last_name: Last name of the contact person.
        :param pulumi.Input[str] line1: Address line 1.
        :param pulumi.Input[str] line2: Address line 2.
        :param pulumi.Input[str] line3: Address line 3.
        :param pulumi.Input[str] line4: Address line 4.
        :param pulumi.Input[str] middle_name: Middle name of the contact person.
        :param pulumi.Input[str] municipal_inscription: Municipal Inscription.
        :param pulumi.Input[str] osp_home_region: The home region's public name of the logged in user.
        :param pulumi.Input[str] phone_country_code: Phone country code of the contact person.
        :param pulumi.Input[str] phone_number: Phone number of the contact person.
        :param pulumi.Input[str] postal_code: Post code of the address.
        :param pulumi.Input[str] province: Province of the address.
        :param pulumi.Input[str] quality: Address quality type.
        :param pulumi.Input[str] state: State of the address.
        :param pulumi.Input[str] state_inscription: State Inscription.
        :param pulumi.Input[str] street_name: Street name of the address.
        :param pulumi.Input[str] street_number: Street number of the address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] verification_code: Address verification code.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressActionVerificationState.__new__(_AddressActionVerificationState)

        __props__.__dict__["address_key"] = address_key
        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["city"] = city
        __props__.__dict__["company_name"] = company_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["contributor_class"] = contributor_class
        __props__.__dict__["country"] = country
        __props__.__dict__["county"] = county
        __props__.__dict__["department_name"] = department_name
        __props__.__dict__["email_address"] = email_address
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["internal_number"] = internal_number
        __props__.__dict__["job_title"] = job_title
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["line1"] = line1
        __props__.__dict__["line2"] = line2
        __props__.__dict__["line3"] = line3
        __props__.__dict__["line4"] = line4
        __props__.__dict__["middle_name"] = middle_name
        __props__.__dict__["municipal_inscription"] = municipal_inscription
        __props__.__dict__["osp_home_region"] = osp_home_region
        __props__.__dict__["phone_country_code"] = phone_country_code
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["postal_code"] = postal_code
        __props__.__dict__["province"] = province
        __props__.__dict__["quality"] = quality
        __props__.__dict__["state"] = state
        __props__.__dict__["state_inscription"] = state_inscription
        __props__.__dict__["street_name"] = street_name
        __props__.__dict__["street_number"] = street_number
        __props__.__dict__["verification_code"] = verification_code
        return AddressActionVerification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> pulumi.Output[str]:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence['outputs.AddressActionVerificationAddress']]:
        """
        Address details model.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def city(self) -> pulumi.Output[str]:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> pulumi.Output[str]:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> pulumi.Output[str]:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[str]:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> pulumi.Output[str]:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> pulumi.Output[str]:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Output[str]:
        """
        Contact person email address.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[str]:
        """
        First name of the contact person.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> pulumi.Output[str]:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> pulumi.Output[str]:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[str]:
        """
        Last name of the contact person.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> pulumi.Output[str]:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> pulumi.Output[str]:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> pulumi.Output[str]:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> pulumi.Output[str]:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> pulumi.Output[str]:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> pulumi.Output[str]:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> pulumi.Output[str]:
        """
        The home region's public name of the logged in user.
        """
        return pulumi.get(self, "osp_home_region")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> pulumi.Output[str]:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[str]:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> pulumi.Output[str]:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> pulumi.Output[str]:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def quality(self) -> pulumi.Output[str]:
        """
        Address quality type.
        """
        return pulumi.get(self, "quality")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> pulumi.Output[str]:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> pulumi.Output[str]:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> pulumi.Output[str]:
        """
        Street number of the address.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "street_number")

    @property
    @pulumi.getter(name="verificationCode")
    def verification_code(self) -> pulumi.Output[str]:
        """
        Address verification code.
        """
        return pulumi.get(self, "verification_code")

