# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInvoicesResult',
    'AwaitableGetInvoicesResult',
    'get_invoices',
    'get_invoices_output',
]

@pulumi.output_type
class GetInvoicesResult:
    """
    A collection of values returned by getInvoices.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, invoice_collections=None, invoice_id=None, osp_home_region=None, search_text=None, statuses=None, time_invoice_end=None, time_invoice_start=None, time_payment_end=None, time_payment_start=None, types=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if invoice_collections and not isinstance(invoice_collections, list):
            raise TypeError("Expected argument 'invoice_collections' to be a list")
        pulumi.set(__self__, "invoice_collections", invoice_collections)
        if invoice_id and not isinstance(invoice_id, str):
            raise TypeError("Expected argument 'invoice_id' to be a str")
        pulumi.set(__self__, "invoice_id", invoice_id)
        if osp_home_region and not isinstance(osp_home_region, str):
            raise TypeError("Expected argument 'osp_home_region' to be a str")
        pulumi.set(__self__, "osp_home_region", osp_home_region)
        if search_text and not isinstance(search_text, str):
            raise TypeError("Expected argument 'search_text' to be a str")
        pulumi.set(__self__, "search_text", search_text)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if time_invoice_end and not isinstance(time_invoice_end, str):
            raise TypeError("Expected argument 'time_invoice_end' to be a str")
        pulumi.set(__self__, "time_invoice_end", time_invoice_end)
        if time_invoice_start and not isinstance(time_invoice_start, str):
            raise TypeError("Expected argument 'time_invoice_start' to be a str")
        pulumi.set(__self__, "time_invoice_start", time_invoice_start)
        if time_payment_end and not isinstance(time_payment_end, str):
            raise TypeError("Expected argument 'time_payment_end' to be a str")
        pulumi.set(__self__, "time_payment_end", time_payment_end)
        if time_payment_start and not isinstance(time_payment_start, str):
            raise TypeError("Expected argument 'time_payment_start' to be a str")
        pulumi.set(__self__, "time_payment_start", time_payment_start)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInvoicesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invoiceCollections")
    def invoice_collections(self) -> Sequence['outputs.GetInvoicesInvoiceCollectionResult']:
        """
        The list of invoice_collection.
        """
        return pulumi.get(self, "invoice_collections")

    @property
    @pulumi.getter(name="invoiceId")
    def invoice_id(self) -> Optional[str]:
        """
        Invoice identifier which is generated on the on-premise sie. Pls note this is not an OCID
        """
        return pulumi.get(self, "invoice_id")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> str:
        return pulumi.get(self, "osp_home_region")

    @property
    @pulumi.getter(name="searchText")
    def search_text(self) -> Optional[str]:
        return pulumi.get(self, "search_text")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="timeInvoiceEnd")
    def time_invoice_end(self) -> Optional[str]:
        return pulumi.get(self, "time_invoice_end")

    @property
    @pulumi.getter(name="timeInvoiceStart")
    def time_invoice_start(self) -> Optional[str]:
        return pulumi.get(self, "time_invoice_start")

    @property
    @pulumi.getter(name="timePaymentEnd")
    def time_payment_end(self) -> Optional[str]:
        return pulumi.get(self, "time_payment_end")

    @property
    @pulumi.getter(name="timePaymentStart")
    def time_payment_start(self) -> Optional[str]:
        return pulumi.get(self, "time_payment_start")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "types")


class AwaitableGetInvoicesResult(GetInvoicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInvoicesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            invoice_collections=self.invoice_collections,
            invoice_id=self.invoice_id,
            osp_home_region=self.osp_home_region,
            search_text=self.search_text,
            statuses=self.statuses,
            time_invoice_end=self.time_invoice_end,
            time_invoice_start=self.time_invoice_start,
            time_payment_end=self.time_payment_end,
            time_payment_start=self.time_payment_start,
            types=self.types)


def get_invoices(compartment_id: Optional[str] = None,
                 filters: Optional[Sequence[pulumi.InputType['GetInvoicesFilterArgs']]] = None,
                 invoice_id: Optional[str] = None,
                 osp_home_region: Optional[str] = None,
                 search_text: Optional[str] = None,
                 statuses: Optional[Sequence[str]] = None,
                 time_invoice_end: Optional[str] = None,
                 time_invoice_start: Optional[str] = None,
                 time_payment_end: Optional[str] = None,
                 time_payment_start: Optional[str] = None,
                 types: Optional[Sequence[str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInvoicesResult:
    """
    This data source provides the list of Invoices in Oracle Cloud Infrastructure Osp Gateway service.

    Returns a list of invoices

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_invoices = oci.OspGateway.get_invoices(compartment_id=compartment_id,
        osp_home_region=invoice_osp_home_region,
        invoice_id=test_invoice["id"],
        search_text=invoice_search_text,
        statuses=invoice_status,
        time_invoice_end=invoice_time_invoice_end,
        time_invoice_start=invoice_time_invoice_start,
        time_payment_end=invoice_time_payment_end,
        time_payment_start=invoice_time_payment_start,
        types=invoice_type)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str invoice_id: The invoice query param (not unique).
    :param str osp_home_region: The home region's public name of the logged in user.
    :param str search_text: A filter to only return resources that match the given value. Looking for partial matches in the following fileds: Invoice No., Reference No. (plan number), Payment Ref, Total Amount(plan number), Balance Due(plan number) and Party/Customer Name
    :param Sequence[str] statuses: A filter to only return resources that match one of the status elements.
    :param str time_invoice_end: description: End time (UTC) of the target invoice date range for which to fetch invoice data (exclusive).
    :param str time_invoice_start: description: Start time (UTC) of the target invoice date range for which to fetch invoice data (inclusive).
    :param str time_payment_end: description: End time (UTC) of the target payment date range for which to fetch invoice data (exclusive).
    :param str time_payment_start: description: Start time (UTC) of the target payment date range for which to fetch invoice data (inclusive).
    :param Sequence[str] types: A filter to only return resources that match the given type exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['invoiceId'] = invoice_id
    __args__['ospHomeRegion'] = osp_home_region
    __args__['searchText'] = search_text
    __args__['statuses'] = statuses
    __args__['timeInvoiceEnd'] = time_invoice_end
    __args__['timeInvoiceStart'] = time_invoice_start
    __args__['timePaymentEnd'] = time_payment_end
    __args__['timePaymentStart'] = time_payment_start
    __args__['types'] = types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OspGateway/getInvoices:getInvoices', __args__, opts=opts, typ=GetInvoicesResult).value

    return AwaitableGetInvoicesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        invoice_collections=pulumi.get(__ret__, 'invoice_collections'),
        invoice_id=pulumi.get(__ret__, 'invoice_id'),
        osp_home_region=pulumi.get(__ret__, 'osp_home_region'),
        search_text=pulumi.get(__ret__, 'search_text'),
        statuses=pulumi.get(__ret__, 'statuses'),
        time_invoice_end=pulumi.get(__ret__, 'time_invoice_end'),
        time_invoice_start=pulumi.get(__ret__, 'time_invoice_start'),
        time_payment_end=pulumi.get(__ret__, 'time_payment_end'),
        time_payment_start=pulumi.get(__ret__, 'time_payment_start'),
        types=pulumi.get(__ret__, 'types'))


@_utilities.lift_output_func(get_invoices)
def get_invoices_output(compartment_id: Optional[pulumi.Input[str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetInvoicesFilterArgs']]]]] = None,
                        invoice_id: Optional[pulumi.Input[Optional[str]]] = None,
                        osp_home_region: Optional[pulumi.Input[str]] = None,
                        search_text: Optional[pulumi.Input[Optional[str]]] = None,
                        statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        time_invoice_end: Optional[pulumi.Input[Optional[str]]] = None,
                        time_invoice_start: Optional[pulumi.Input[Optional[str]]] = None,
                        time_payment_end: Optional[pulumi.Input[Optional[str]]] = None,
                        time_payment_start: Optional[pulumi.Input[Optional[str]]] = None,
                        types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInvoicesResult]:
    """
    This data source provides the list of Invoices in Oracle Cloud Infrastructure Osp Gateway service.

    Returns a list of invoices

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_invoices = oci.OspGateway.get_invoices(compartment_id=compartment_id,
        osp_home_region=invoice_osp_home_region,
        invoice_id=test_invoice["id"],
        search_text=invoice_search_text,
        statuses=invoice_status,
        time_invoice_end=invoice_time_invoice_end,
        time_invoice_start=invoice_time_invoice_start,
        time_payment_end=invoice_time_payment_end,
        time_payment_start=invoice_time_payment_start,
        types=invoice_type)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str invoice_id: The invoice query param (not unique).
    :param str osp_home_region: The home region's public name of the logged in user.
    :param str search_text: A filter to only return resources that match the given value. Looking for partial matches in the following fileds: Invoice No., Reference No. (plan number), Payment Ref, Total Amount(plan number), Balance Due(plan number) and Party/Customer Name
    :param Sequence[str] statuses: A filter to only return resources that match one of the status elements.
    :param str time_invoice_end: description: End time (UTC) of the target invoice date range for which to fetch invoice data (exclusive).
    :param str time_invoice_start: description: Start time (UTC) of the target invoice date range for which to fetch invoice data (inclusive).
    :param str time_payment_end: description: End time (UTC) of the target payment date range for which to fetch invoice data (exclusive).
    :param str time_payment_start: description: Start time (UTC) of the target payment date range for which to fetch invoice data (inclusive).
    :param Sequence[str] types: A filter to only return resources that match the given type exactly.
    """
    ...
