# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecretbundleVersionsResult',
    'AwaitableGetSecretbundleVersionsResult',
    'get_secretbundle_versions',
    'get_secretbundle_versions_output',
]

@pulumi.output_type
class GetSecretbundleVersionsResult:
    """
    A collection of values returned by getSecretbundleVersions.
    """
    def __init__(__self__, filters=None, id=None, secret_bundle_versions=None, secret_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if secret_bundle_versions and not isinstance(secret_bundle_versions, list):
            raise TypeError("Expected argument 'secret_bundle_versions' to be a list")
        pulumi.set(__self__, "secret_bundle_versions", secret_bundle_versions)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecretbundleVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="secretBundleVersions")
    def secret_bundle_versions(self) -> Sequence['outputs.GetSecretbundleVersionsSecretBundleVersionResult']:
        """
        The list of secret_bundle_versions.
        """
        return pulumi.get(self, "secret_bundle_versions")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The OCID of the secret.
        """
        return pulumi.get(self, "secret_id")


class AwaitableGetSecretbundleVersionsResult(GetSecretbundleVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretbundleVersionsResult(
            filters=self.filters,
            id=self.id,
            secret_bundle_versions=self.secret_bundle_versions,
            secret_id=self.secret_id)


def get_secretbundle_versions(filters: Optional[Sequence[pulumi.InputType['GetSecretbundleVersionsFilterArgs']]] = None,
                              secret_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretbundleVersionsResult:
    """
    This data source provides the list of Secretbundle Versions in Oracle Cloud Infrastructure Secrets service.

    Lists all secret bundle versions for the specified secret.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_secretbundle_versions = oci.Secrets.get_secretbundle_versions(secret_id=test_secret["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str secret_id: The OCID of the secret.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Secrets/getSecretbundleVersions:getSecretbundleVersions', __args__, opts=opts, typ=GetSecretbundleVersionsResult).value

    return AwaitableGetSecretbundleVersionsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        secret_bundle_versions=pulumi.get(__ret__, 'secret_bundle_versions'),
        secret_id=pulumi.get(__ret__, 'secret_id'))


@_utilities.lift_output_func(get_secretbundle_versions)
def get_secretbundle_versions_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSecretbundleVersionsFilterArgs']]]]] = None,
                                     secret_id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecretbundleVersionsResult]:
    """
    This data source provides the list of Secretbundle Versions in Oracle Cloud Infrastructure Secrets service.

    Lists all secret bundle versions for the specified secret.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_secretbundle_versions = oci.Secrets.get_secretbundle_versions(secret_id=test_secret["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str secret_id: The OCID of the secret.
    """
    ...
