# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMeshesResult',
    'AwaitableGetMeshesResult',
    'get_meshes',
    'get_meshes_output',
]

@pulumi.output_type
class GetMeshesResult:
    """
    A collection of values returned by getMeshes.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, mesh_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mesh_collections and not isinstance(mesh_collections, list):
            raise TypeError("Expected argument 'mesh_collections' to be a list")
        pulumi.set(__self__, "mesh_collections", mesh_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. The name does not have to be unique and can be changed after creation. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMeshesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="meshCollections")
    def mesh_collections(self) -> Sequence['outputs.GetMeshesMeshCollectionResult']:
        """
        The list of mesh_collection.
        """
        return pulumi.get(self, "mesh_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetMeshesResult(GetMeshesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMeshesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            mesh_collections=self.mesh_collections,
            state=self.state)


def get_meshes(compartment_id: Optional[str] = None,
               display_name: Optional[str] = None,
               filters: Optional[Sequence[pulumi.InputType['GetMeshesFilterArgs']]] = None,
               id: Optional[str] = None,
               state: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMeshesResult:
    """
    This data source provides the list of Meshes in Oracle Cloud Infrastructure Service Mesh service.

    Returns a list of Mesh objects.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_meshes = oci.ServiceMesh.get_meshes(compartment_id=compartment_id,
        display_name=mesh_display_name,
        id=mesh_id,
        state=mesh_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire displayName given.
    :param str id: Unique Mesh identifier.
    :param str state: A filter to return only resources that match the life cycle state given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceMesh/getMeshes:getMeshes', __args__, opts=opts, typ=GetMeshesResult).value

    return AwaitableGetMeshesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        mesh_collections=pulumi.get(__ret__, 'mesh_collections'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_meshes)
def get_meshes_output(compartment_id: Optional[pulumi.Input[str]] = None,
                      display_name: Optional[pulumi.Input[Optional[str]]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMeshesFilterArgs']]]]] = None,
                      id: Optional[pulumi.Input[Optional[str]]] = None,
                      state: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMeshesResult]:
    """
    This data source provides the list of Meshes in Oracle Cloud Infrastructure Service Mesh service.

    Returns a list of Mesh objects.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_meshes = oci.ServiceMesh.get_meshes(compartment_id=compartment_id,
        display_name=mesh_display_name,
        id=mesh_id,
        state=mesh_state)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire displayName given.
    :param str id: Unique Mesh identifier.
    :param str state: A filter to return only resources that match the life cycle state given.
    """
    ...
