# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricExtensionArgs', 'MetricExtension']

@pulumi.input_type
class MetricExtensionArgs:
    def __init__(__self__, *,
                 collection_recurrences: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 metric_lists: pulumi.Input[Sequence[pulumi.Input['MetricExtensionMetricListArgs']]],
                 query_properties: pulumi.Input['MetricExtensionQueryPropertiesArgs'],
                 resource_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publish_trigger: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a MetricExtension resource.
        :param pulumi.Input[str] collection_recurrences: (Updatable) Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = "FREQ";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are "MINUTELY","HOURLY","DAILY" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[str] display_name: (Updatable) Display name of the metric.
        :param pulumi.Input[Sequence[pulumi.Input['MetricExtensionMetricListArgs']]] metric_lists: (Updatable) List of metrics which are part of this metric extension
        :param pulumi.Input['MetricExtensionQueryPropertiesArgs'] query_properties: (Updatable) Collection method and query properties details of metric extension
        :param pulumi.Input[str] resource_type: Resource type to which Metric Extension applies
        :param pulumi.Input[str] description: (Updatable) Description of the metric extension.
        :param pulumi.Input[str] name: (Updatable) Name of the script file
        :param pulumi.Input[bool] publish_trigger: (Updatable) An optional property when set to `true` triggers Publish of a metric extension. Once set to `true`, it cannot be changed back to `false`. Update of publish_trigger cannot be combined with other updates in the same request. A metric extension cannot be tested and its definition cannot be updated once it is marked published or publish_trigger is updated to `true`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "collection_recurrences", collection_recurrences)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "metric_lists", metric_lists)
        pulumi.set(__self__, "query_properties", query_properties)
        pulumi.set(__self__, "resource_type", resource_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publish_trigger is not None:
            pulumi.set(__self__, "publish_trigger", publish_trigger)

    @property
    @pulumi.getter(name="collectionRecurrences")
    def collection_recurrences(self) -> pulumi.Input[str]:
        """
        (Updatable) Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = "FREQ";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are "MINUTELY","HOURLY","DAILY" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1
        """
        return pulumi.get(self, "collection_recurrences")

    @collection_recurrences.setter
    def collection_recurrences(self, value: pulumi.Input[str]):
        pulumi.set(self, "collection_recurrences", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Display name of the metric.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="metricLists")
    def metric_lists(self) -> pulumi.Input[Sequence[pulumi.Input['MetricExtensionMetricListArgs']]]:
        """
        (Updatable) List of metrics which are part of this metric extension
        """
        return pulumi.get(self, "metric_lists")

    @metric_lists.setter
    def metric_lists(self, value: pulumi.Input[Sequence[pulumi.Input['MetricExtensionMetricListArgs']]]):
        pulumi.set(self, "metric_lists", value)

    @property
    @pulumi.getter(name="queryProperties")
    def query_properties(self) -> pulumi.Input['MetricExtensionQueryPropertiesArgs']:
        """
        (Updatable) Collection method and query properties details of metric extension
        """
        return pulumi.get(self, "query_properties")

    @query_properties.setter
    def query_properties(self, value: pulumi.Input['MetricExtensionQueryPropertiesArgs']):
        pulumi.set(self, "query_properties", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        Resource type to which Metric Extension applies
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the metric extension.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the script file
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publishTrigger")
    def publish_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when set to `true` triggers Publish of a metric extension. Once set to `true`, it cannot be changed back to `false`. Update of publish_trigger cannot be combined with other updates in the same request. A metric extension cannot be tested and its definition cannot be updated once it is marked published or publish_trigger is updated to `true`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "publish_trigger")

    @publish_trigger.setter
    def publish_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_trigger", value)


@pulumi.input_type
class _MetricExtensionState:
    def __init__(__self__, *,
                 collection_method: Optional[pulumi.Input[str]] = None,
                 collection_recurrences: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled_on_resources: Optional[pulumi.Input[Sequence[pulumi.Input['MetricExtensionEnabledOnResourceArgs']]]] = None,
                 enabled_on_resources_count: Optional[pulumi.Input[int]] = None,
                 last_updated_by: Optional[pulumi.Input[str]] = None,
                 metric_lists: Optional[pulumi.Input[Sequence[pulumi.Input['MetricExtensionMetricListArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publish_trigger: Optional[pulumi.Input[bool]] = None,
                 query_properties: Optional[pulumi.Input['MetricExtensionQueryPropertiesArgs']] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetricExtension resources.
        :param pulumi.Input[str] collection_method: (Updatable) Type of possible collection methods.
        :param pulumi.Input[str] collection_recurrences: (Updatable) Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = "FREQ";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are "MINUTELY","HOURLY","DAILY" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[str] created_by: Created by user
        :param pulumi.Input[str] description: (Updatable) Description of the metric extension.
        :param pulumi.Input[str] display_name: (Updatable) Display name of the metric.
        :param pulumi.Input[Sequence[pulumi.Input['MetricExtensionEnabledOnResourceArgs']]] enabled_on_resources: List of resource objects on which this metric extension is enabled.
        :param pulumi.Input[int] enabled_on_resources_count: Count of resources on which this metric extension is enabled.
        :param pulumi.Input[str] last_updated_by: Last updated by user
        :param pulumi.Input[Sequence[pulumi.Input['MetricExtensionMetricListArgs']]] metric_lists: (Updatable) List of metrics which are part of this metric extension
        :param pulumi.Input[str] name: (Updatable) Name of the script file
        :param pulumi.Input[bool] publish_trigger: (Updatable) An optional property when set to `true` triggers Publish of a metric extension. Once set to `true`, it cannot be changed back to `false`. Update of publish_trigger cannot be combined with other updates in the same request. A metric extension cannot be tested and its definition cannot be updated once it is marked published or publish_trigger is updated to `true`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['MetricExtensionQueryPropertiesArgs'] query_properties: (Updatable) Collection method and query properties details of metric extension
        :param pulumi.Input[str] resource_type: Resource type to which Metric Extension applies
        :param pulumi.Input[str] resource_uri: The URI path that the user can do a GET on to access the metric extension metadata
        :param pulumi.Input[str] state: The current lifecycle state of the metric extension
        :param pulumi.Input[str] status: The current status of the metric extension i.e. whether it is Draft or Published
        :param pulumi.Input[str] tenant_id: Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[str] time_created: Metric Extension creation time. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: Metric Extension update time. An RFC3339 formatted datetime string.
        """
        if collection_method is not None:
            pulumi.set(__self__, "collection_method", collection_method)
        if collection_recurrences is not None:
            pulumi.set(__self__, "collection_recurrences", collection_recurrences)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enabled_on_resources is not None:
            pulumi.set(__self__, "enabled_on_resources", enabled_on_resources)
        if enabled_on_resources_count is not None:
            pulumi.set(__self__, "enabled_on_resources_count", enabled_on_resources_count)
        if last_updated_by is not None:
            pulumi.set(__self__, "last_updated_by", last_updated_by)
        if metric_lists is not None:
            pulumi.set(__self__, "metric_lists", metric_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publish_trigger is not None:
            pulumi.set(__self__, "publish_trigger", publish_trigger)
        if query_properties is not None:
            pulumi.set(__self__, "query_properties", query_properties)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="collectionMethod")
    def collection_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of possible collection methods.
        """
        return pulumi.get(self, "collection_method")

    @collection_method.setter
    def collection_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_method", value)

    @property
    @pulumi.getter(name="collectionRecurrences")
    def collection_recurrences(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = "FREQ";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are "MINUTELY","HOURLY","DAILY" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1
        """
        return pulumi.get(self, "collection_recurrences")

    @collection_recurrences.setter
    def collection_recurrences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_recurrences", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        Created by user
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the metric extension.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Display name of the metric.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enabledOnResources")
    def enabled_on_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricExtensionEnabledOnResourceArgs']]]]:
        """
        List of resource objects on which this metric extension is enabled.
        """
        return pulumi.get(self, "enabled_on_resources")

    @enabled_on_resources.setter
    def enabled_on_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricExtensionEnabledOnResourceArgs']]]]):
        pulumi.set(self, "enabled_on_resources", value)

    @property
    @pulumi.getter(name="enabledOnResourcesCount")
    def enabled_on_resources_count(self) -> Optional[pulumi.Input[int]]:
        """
        Count of resources on which this metric extension is enabled.
        """
        return pulumi.get(self, "enabled_on_resources_count")

    @enabled_on_resources_count.setter
    def enabled_on_resources_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "enabled_on_resources_count", value)

    @property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> Optional[pulumi.Input[str]]:
        """
        Last updated by user
        """
        return pulumi.get(self, "last_updated_by")

    @last_updated_by.setter
    def last_updated_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_by", value)

    @property
    @pulumi.getter(name="metricLists")
    def metric_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricExtensionMetricListArgs']]]]:
        """
        (Updatable) List of metrics which are part of this metric extension
        """
        return pulumi.get(self, "metric_lists")

    @metric_lists.setter
    def metric_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricExtensionMetricListArgs']]]]):
        pulumi.set(self, "metric_lists", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the script file
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publishTrigger")
    def publish_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when set to `true` triggers Publish of a metric extension. Once set to `true`, it cannot be changed back to `false`. Update of publish_trigger cannot be combined with other updates in the same request. A metric extension cannot be tested and its definition cannot be updated once it is marked published or publish_trigger is updated to `true`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "publish_trigger")

    @publish_trigger.setter
    def publish_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish_trigger", value)

    @property
    @pulumi.getter(name="queryProperties")
    def query_properties(self) -> Optional[pulumi.Input['MetricExtensionQueryPropertiesArgs']]:
        """
        (Updatable) Collection method and query properties details of metric extension
        """
        return pulumi.get(self, "query_properties")

    @query_properties.setter
    def query_properties(self, value: Optional[pulumi.Input['MetricExtensionQueryPropertiesArgs']]):
        pulumi.set(self, "query_properties", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type to which Metric Extension applies
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI path that the user can do a GET on to access the metric extension metadata
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uri", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the metric extension
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the metric extension i.e. whether it is Draft or Published
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Metric Extension creation time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Metric Extension update time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class MetricExtension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collection_recurrences: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metric_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricExtensionMetricListArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publish_trigger: Optional[pulumi.Input[bool]] = None,
                 query_properties: Optional[pulumi.Input[pulumi.InputType['MetricExtensionQueryPropertiesArgs']]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Metric Extension resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new metric extension resource for a given compartment

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_metric_extension = oci.stack_monitoring.MetricExtension("test_metric_extension",
            collection_recurrences=metric_extension_collection_recurrences,
            compartment_id=compartment_id,
            display_name=metric_extension_display_name,
            metric_lists=[oci.stack_monitoring.MetricExtensionMetricListArgs(
                data_type=metric_extension_metric_list_data_type,
                name=metric_extension_metric_list_name,
                compute_expression=metric_extension_metric_list_compute_expression,
                display_name=metric_extension_metric_list_display_name,
                is_dimension=metric_extension_metric_list_is_dimension,
                is_hidden=metric_extension_metric_list_is_hidden,
                metric_category=metric_extension_metric_list_metric_category,
                unit=metric_extension_metric_list_unit,
            )],
            name=metric_extension_name,
            query_properties=oci.stack_monitoring.MetricExtensionQueryPropertiesArgs(
                collection_method=metric_extension_query_properties_collection_method,
                arguments=metric_extension_query_properties_arguments,
                auto_row_prefix=metric_extension_query_properties_auto_row_prefix,
                command=metric_extension_query_properties_command,
                delimiter=metric_extension_query_properties_delimiter,
                identity_metric=metric_extension_query_properties_identity_metric,
                in_param_details=[oci.stack_monitoring.MetricExtensionQueryPropertiesInParamDetailArgs(
                    in_param_position=metric_extension_query_properties_in_param_details_in_param_position,
                    in_param_value=metric_extension_query_properties_in_param_details_in_param_value,
                )],
                is_metric_service_enabled=metric_extension_query_properties_is_metric_service_enabled,
                jmx_attributes=metric_extension_query_properties_jmx_attributes,
                managed_bean_query=metric_extension_query_properties_managed_bean_query,
                out_param_details=oci.stack_monitoring.MetricExtensionQueryPropertiesOutParamDetailsArgs(
                    out_param_position=metric_extension_query_properties_out_param_details_out_param_position,
                    out_param_type=metric_extension_query_properties_out_param_details_out_param_type,
                ),
                script_details=oci.stack_monitoring.MetricExtensionQueryPropertiesScriptDetailsArgs(
                    content=metric_extension_query_properties_script_details_content,
                    name=metric_extension_query_properties_script_details_name,
                ),
                sql_details=oci.stack_monitoring.MetricExtensionQueryPropertiesSqlDetailsArgs(
                    content=metric_extension_query_properties_sql_details_content,
                    script_file_name=metric_extension_query_properties_sql_details_script_file_name,
                ),
                sql_type=metric_extension_query_properties_sql_type,
                starts_with=metric_extension_query_properties_starts_with,
            ),
            resource_type=metric_extension_resource_type,
            description=metric_extension_description)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        MetricExtensions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/metricExtension:MetricExtension test_metric_extension "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] collection_recurrences: (Updatable) Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = "FREQ";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are "MINUTELY","HOURLY","DAILY" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[str] description: (Updatable) Description of the metric extension.
        :param pulumi.Input[str] display_name: (Updatable) Display name of the metric.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricExtensionMetricListArgs']]]] metric_lists: (Updatable) List of metrics which are part of this metric extension
        :param pulumi.Input[str] name: (Updatable) Name of the script file
        :param pulumi.Input[bool] publish_trigger: (Updatable) An optional property when set to `true` triggers Publish of a metric extension. Once set to `true`, it cannot be changed back to `false`. Update of publish_trigger cannot be combined with other updates in the same request. A metric extension cannot be tested and its definition cannot be updated once it is marked published or publish_trigger is updated to `true`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[pulumi.InputType['MetricExtensionQueryPropertiesArgs']] query_properties: (Updatable) Collection method and query properties details of metric extension
        :param pulumi.Input[str] resource_type: Resource type to which Metric Extension applies
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricExtensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Metric Extension resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new metric extension resource for a given compartment

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_metric_extension = oci.stack_monitoring.MetricExtension("test_metric_extension",
            collection_recurrences=metric_extension_collection_recurrences,
            compartment_id=compartment_id,
            display_name=metric_extension_display_name,
            metric_lists=[oci.stack_monitoring.MetricExtensionMetricListArgs(
                data_type=metric_extension_metric_list_data_type,
                name=metric_extension_metric_list_name,
                compute_expression=metric_extension_metric_list_compute_expression,
                display_name=metric_extension_metric_list_display_name,
                is_dimension=metric_extension_metric_list_is_dimension,
                is_hidden=metric_extension_metric_list_is_hidden,
                metric_category=metric_extension_metric_list_metric_category,
                unit=metric_extension_metric_list_unit,
            )],
            name=metric_extension_name,
            query_properties=oci.stack_monitoring.MetricExtensionQueryPropertiesArgs(
                collection_method=metric_extension_query_properties_collection_method,
                arguments=metric_extension_query_properties_arguments,
                auto_row_prefix=metric_extension_query_properties_auto_row_prefix,
                command=metric_extension_query_properties_command,
                delimiter=metric_extension_query_properties_delimiter,
                identity_metric=metric_extension_query_properties_identity_metric,
                in_param_details=[oci.stack_monitoring.MetricExtensionQueryPropertiesInParamDetailArgs(
                    in_param_position=metric_extension_query_properties_in_param_details_in_param_position,
                    in_param_value=metric_extension_query_properties_in_param_details_in_param_value,
                )],
                is_metric_service_enabled=metric_extension_query_properties_is_metric_service_enabled,
                jmx_attributes=metric_extension_query_properties_jmx_attributes,
                managed_bean_query=metric_extension_query_properties_managed_bean_query,
                out_param_details=oci.stack_monitoring.MetricExtensionQueryPropertiesOutParamDetailsArgs(
                    out_param_position=metric_extension_query_properties_out_param_details_out_param_position,
                    out_param_type=metric_extension_query_properties_out_param_details_out_param_type,
                ),
                script_details=oci.stack_monitoring.MetricExtensionQueryPropertiesScriptDetailsArgs(
                    content=metric_extension_query_properties_script_details_content,
                    name=metric_extension_query_properties_script_details_name,
                ),
                sql_details=oci.stack_monitoring.MetricExtensionQueryPropertiesSqlDetailsArgs(
                    content=metric_extension_query_properties_sql_details_content,
                    script_file_name=metric_extension_query_properties_sql_details_script_file_name,
                ),
                sql_type=metric_extension_query_properties_sql_type,
                starts_with=metric_extension_query_properties_starts_with,
            ),
            resource_type=metric_extension_resource_type,
            description=metric_extension_description)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        MetricExtensions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/metricExtension:MetricExtension test_metric_extension "id"
        ```

        :param str resource_name: The name of the resource.
        :param MetricExtensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricExtensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collection_recurrences: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 metric_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricExtensionMetricListArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 publish_trigger: Optional[pulumi.Input[bool]] = None,
                 query_properties: Optional[pulumi.Input[pulumi.InputType['MetricExtensionQueryPropertiesArgs']]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricExtensionArgs.__new__(MetricExtensionArgs)

            if collection_recurrences is None and not opts.urn:
                raise TypeError("Missing required property 'collection_recurrences'")
            __props__.__dict__["collection_recurrences"] = collection_recurrences
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if metric_lists is None and not opts.urn:
                raise TypeError("Missing required property 'metric_lists'")
            __props__.__dict__["metric_lists"] = metric_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["publish_trigger"] = publish_trigger
            if query_properties is None and not opts.urn:
                raise TypeError("Missing required property 'query_properties'")
            __props__.__dict__["query_properties"] = query_properties
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["collection_method"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["enabled_on_resources"] = None
            __props__.__dict__["enabled_on_resources_count"] = None
            __props__.__dict__["last_updated_by"] = None
            __props__.__dict__["resource_uri"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MetricExtension, __self__).__init__(
            'oci:StackMonitoring/metricExtension:MetricExtension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            collection_method: Optional[pulumi.Input[str]] = None,
            collection_recurrences: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enabled_on_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricExtensionEnabledOnResourceArgs']]]]] = None,
            enabled_on_resources_count: Optional[pulumi.Input[int]] = None,
            last_updated_by: Optional[pulumi.Input[str]] = None,
            metric_lists: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricExtensionMetricListArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            publish_trigger: Optional[pulumi.Input[bool]] = None,
            query_properties: Optional[pulumi.Input[pulumi.InputType['MetricExtensionQueryPropertiesArgs']]] = None,
            resource_type: Optional[pulumi.Input[str]] = None,
            resource_uri: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'MetricExtension':
        """
        Get an existing MetricExtension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] collection_method: (Updatable) Type of possible collection methods.
        :param pulumi.Input[str] collection_recurrences: (Updatable) Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = "FREQ";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are "MINUTELY","HOURLY","DAILY" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[str] created_by: Created by user
        :param pulumi.Input[str] description: (Updatable) Description of the metric extension.
        :param pulumi.Input[str] display_name: (Updatable) Display name of the metric.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricExtensionEnabledOnResourceArgs']]]] enabled_on_resources: List of resource objects on which this metric extension is enabled.
        :param pulumi.Input[int] enabled_on_resources_count: Count of resources on which this metric extension is enabled.
        :param pulumi.Input[str] last_updated_by: Last updated by user
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricExtensionMetricListArgs']]]] metric_lists: (Updatable) List of metrics which are part of this metric extension
        :param pulumi.Input[str] name: (Updatable) Name of the script file
        :param pulumi.Input[bool] publish_trigger: (Updatable) An optional property when set to `true` triggers Publish of a metric extension. Once set to `true`, it cannot be changed back to `false`. Update of publish_trigger cannot be combined with other updates in the same request. A metric extension cannot be tested and its definition cannot be updated once it is marked published or publish_trigger is updated to `true`.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[pulumi.InputType['MetricExtensionQueryPropertiesArgs']] query_properties: (Updatable) Collection method and query properties details of metric extension
        :param pulumi.Input[str] resource_type: Resource type to which Metric Extension applies
        :param pulumi.Input[str] resource_uri: The URI path that the user can do a GET on to access the metric extension metadata
        :param pulumi.Input[str] state: The current lifecycle state of the metric extension
        :param pulumi.Input[str] status: The current status of the metric extension i.e. whether it is Draft or Published
        :param pulumi.Input[str] tenant_id: Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[str] time_created: Metric Extension creation time. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: Metric Extension update time. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricExtensionState.__new__(_MetricExtensionState)

        __props__.__dict__["collection_method"] = collection_method
        __props__.__dict__["collection_recurrences"] = collection_recurrences
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enabled_on_resources"] = enabled_on_resources
        __props__.__dict__["enabled_on_resources_count"] = enabled_on_resources_count
        __props__.__dict__["last_updated_by"] = last_updated_by
        __props__.__dict__["metric_lists"] = metric_lists
        __props__.__dict__["name"] = name
        __props__.__dict__["publish_trigger"] = publish_trigger
        __props__.__dict__["query_properties"] = query_properties
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["resource_uri"] = resource_uri
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MetricExtension(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="collectionMethod")
    def collection_method(self) -> pulumi.Output[str]:
        """
        (Updatable) Type of possible collection methods.
        """
        return pulumi.get(self, "collection_method")

    @property
    @pulumi.getter(name="collectionRecurrences")
    def collection_recurrences(self) -> pulumi.Output[str]:
        """
        (Updatable) Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = "FREQ";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are "MINUTELY","HOURLY","DAILY" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1
        """
        return pulumi.get(self, "collection_recurrences")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        Created by user
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description of the metric extension.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Display name of the metric.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enabledOnResources")
    def enabled_on_resources(self) -> pulumi.Output[Sequence['outputs.MetricExtensionEnabledOnResource']]:
        """
        List of resource objects on which this metric extension is enabled.
        """
        return pulumi.get(self, "enabled_on_resources")

    @property
    @pulumi.getter(name="enabledOnResourcesCount")
    def enabled_on_resources_count(self) -> pulumi.Output[int]:
        """
        Count of resources on which this metric extension is enabled.
        """
        return pulumi.get(self, "enabled_on_resources_count")

    @property
    @pulumi.getter(name="lastUpdatedBy")
    def last_updated_by(self) -> pulumi.Output[str]:
        """
        Last updated by user
        """
        return pulumi.get(self, "last_updated_by")

    @property
    @pulumi.getter(name="metricLists")
    def metric_lists(self) -> pulumi.Output[Sequence['outputs.MetricExtensionMetricList']]:
        """
        (Updatable) List of metrics which are part of this metric extension
        """
        return pulumi.get(self, "metric_lists")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the script file
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publishTrigger")
    def publish_trigger(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) An optional property when set to `true` triggers Publish of a metric extension. Once set to `true`, it cannot be changed back to `false`. Update of publish_trigger cannot be combined with other updates in the same request. A metric extension cannot be tested and its definition cannot be updated once it is marked published or publish_trigger is updated to `true`.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "publish_trigger")

    @property
    @pulumi.getter(name="queryProperties")
    def query_properties(self) -> pulumi.Output['outputs.MetricExtensionQueryProperties']:
        """
        (Updatable) Collection method and query properties details of metric extension
        """
        return pulumi.get(self, "query_properties")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[str]:
        """
        Resource type to which Metric Extension applies
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> pulumi.Output[str]:
        """
        The URI path that the user can do a GET on to access the metric extension metadata
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the metric extension
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The current status of the metric extension i.e. whether it is Draft or Published
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Metric Extension creation time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        Metric Extension update time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

