# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetConnectHarnessResult',
    'AwaitableGetConnectHarnessResult',
    'get_connect_harness',
    'get_connect_harness_output',
]

@pulumi.output_type
class GetConnectHarnessResult:
    """
    A collection of values returned by getConnectHarness.
    """
    def __init__(__self__, compartment_id=None, connect_harness_id=None, defined_tags=None, freeform_tags=None, id=None, lifecycle_state_details=None, name=None, state=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connect_harness_id and not isinstance(connect_harness_id, str):
            raise TypeError("Expected argument 'connect_harness_id' to be a str")
        pulumi.set(__self__, "connect_harness_id", connect_harness_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the connect harness.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectHarnessId")
    def connect_harness_id(self) -> str:
        return pulumi.get(self, "connect_harness_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations": {"CostCenter": "42"}}'
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the connect harness.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Any additional details about the current state of the connect harness.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the connect harness. Avoid entering confidential information.  Example: `JDBCConnector`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the connect harness.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the connect harness was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetConnectHarnessResult(GetConnectHarnessResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectHarnessResult(
            compartment_id=self.compartment_id,
            connect_harness_id=self.connect_harness_id,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_state_details=self.lifecycle_state_details,
            name=self.name,
            state=self.state,
            time_created=self.time_created)


def get_connect_harness(connect_harness_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectHarnessResult:
    """
    This data source provides details about a specific Connect Harness resource in Oracle Cloud Infrastructure Streaming service.

    Gets detailed information about a connect harness.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_connect_harness = oci.Streaming.get_connect_harness(connect_harness_id=test_connect_harnes["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str connect_harness_id: The OCID of the connect harness.
    """
    __args__ = dict()
    __args__['connectHarnessId'] = connect_harness_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Streaming/getConnectHarness:getConnectHarness', __args__, opts=opts, typ=GetConnectHarnessResult).value

    return AwaitableGetConnectHarnessResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connect_harness_id=pulumi.get(__ret__, 'connect_harness_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_connect_harness)
def get_connect_harness_output(connect_harness_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectHarnessResult]:
    """
    This data source provides details about a specific Connect Harness resource in Oracle Cloud Infrastructure Streaming service.

    Gets detailed information about a connect harness.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_connect_harness = oci.Streaming.get_connect_harness(connect_harness_id=test_connect_harnes["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str connect_harness_id: The OCID of the connect harness.
    """
    ...
