# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetUsagelimitsResult',
    'AwaitableGetUsagelimitsResult',
    'get_usagelimits',
    'get_usagelimits_output',
]

@pulumi.output_type
class GetUsagelimitsResult:
    """
    A collection of values returned by getUsagelimits.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, limit_type=None, resource_type=None, service_type=None, subscription_id=None, usage_limit_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit_type and not isinstance(limit_type, str):
            raise TypeError("Expected argument 'limit_type' to be a str")
        pulumi.set(__self__, "limit_type", limit_type)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if service_type and not isinstance(service_type, str):
            raise TypeError("Expected argument 'service_type' to be a str")
        pulumi.set(__self__, "service_type", service_type)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if usage_limit_collections and not isinstance(usage_limit_collections, list):
            raise TypeError("Expected argument 'usage_limit_collections' to be a list")
        pulumi.set(__self__, "usage_limit_collections", usage_limit_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetUsagelimitsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="limitType")
    def limit_type(self) -> Optional[str]:
        """
        The limit type of the usage limit
        """
        return pulumi.get(self, "limit_type")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[str]:
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="usageLimitCollections")
    def usage_limit_collections(self) -> Sequence['outputs.GetUsagelimitsUsageLimitCollectionResult']:
        """
        The list of usage_limit_collection.
        """
        return pulumi.get(self, "usage_limit_collections")


class AwaitableGetUsagelimitsResult(GetUsagelimitsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsagelimitsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            limit_type=self.limit_type,
            resource_type=self.resource_type,
            service_type=self.service_type,
            subscription_id=self.subscription_id,
            usage_limit_collections=self.usage_limit_collections)


def get_usagelimits(compartment_id: Optional[str] = None,
                    filters: Optional[Sequence[pulumi.InputType['GetUsagelimitsFilterArgs']]] = None,
                    limit_type: Optional[str] = None,
                    resource_type: Optional[str] = None,
                    service_type: Optional[str] = None,
                    subscription_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsagelimitsResult:
    """
    This data source provides the list of Usagelimits in Oracle Cloud Infrastructure Usage Proxy service.

    Returns the list of usage limit for the subscription ID and tenant ID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_usagelimits = oci.UsageProxy.get_usagelimits(compartment_id=compartment_id,
        subscription_id=test_subscription["id"],
        limit_type=usagelimit_limit_type,
        resource_type=usagelimit_resource_type,
        service_type=usagelimit_service_type)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the root compartment.
    :param str limit_type: Hard or soft limit. Hard limits lead to breaches, soft to alerts.
    :param str resource_type: Resource Name.
    :param str service_type: Service Name.
    :param str subscription_id: The subscription ID for which rewards information is requested for.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['limitType'] = limit_type
    __args__['resourceType'] = resource_type
    __args__['serviceType'] = service_type
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:UsageProxy/getUsagelimits:getUsagelimits', __args__, opts=opts, typ=GetUsagelimitsResult).value

    return AwaitableGetUsagelimitsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        limit_type=pulumi.get(__ret__, 'limit_type'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        service_type=pulumi.get(__ret__, 'service_type'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        usage_limit_collections=pulumi.get(__ret__, 'usage_limit_collections'))


@_utilities.lift_output_func(get_usagelimits)
def get_usagelimits_output(compartment_id: Optional[pulumi.Input[str]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetUsagelimitsFilterArgs']]]]] = None,
                           limit_type: Optional[pulumi.Input[Optional[str]]] = None,
                           resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                           service_type: Optional[pulumi.Input[Optional[str]]] = None,
                           subscription_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUsagelimitsResult]:
    """
    This data source provides the list of Usagelimits in Oracle Cloud Infrastructure Usage Proxy service.

    Returns the list of usage limit for the subscription ID and tenant ID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_usagelimits = oci.UsageProxy.get_usagelimits(compartment_id=compartment_id,
        subscription_id=test_subscription["id"],
        limit_type=usagelimit_limit_type,
        resource_type=usagelimit_resource_type,
        service_type=usagelimit_service_type)
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the root compartment.
    :param str limit_type: Hard or soft limit. Hard limits lead to breaches, soft to alerts.
    :param str resource_type: Resource Name.
    :param str service_type: Service Name.
    :param str subscription_id: The subscription ID for which rewards information is requested for.
    """
    ...
