# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecretResult',
    'AwaitableGetSecretResult',
    'get_secret',
    'get_secret_output',
]

@pulumi.output_type
class GetSecretResult:
    """
    A collection of values returned by getSecret.
    """
    def __init__(__self__, compartment_id=None, current_version_number=None, defined_tags=None, description=None, freeform_tags=None, id=None, key_id=None, last_rotation_time=None, lifecycle_details=None, metadata=None, next_rotation_time=None, rotation_configs=None, rotation_status=None, secret_contents=None, secret_id=None, secret_name=None, secret_rules=None, state=None, time_created=None, time_of_current_version_expiry=None, time_of_deletion=None, vault_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if current_version_number and not isinstance(current_version_number, str):
            raise TypeError("Expected argument 'current_version_number' to be a str")
        pulumi.set(__self__, "current_version_number", current_version_number)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if last_rotation_time and not isinstance(last_rotation_time, str):
            raise TypeError("Expected argument 'last_rotation_time' to be a str")
        pulumi.set(__self__, "last_rotation_time", last_rotation_time)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if next_rotation_time and not isinstance(next_rotation_time, str):
            raise TypeError("Expected argument 'next_rotation_time' to be a str")
        pulumi.set(__self__, "next_rotation_time", next_rotation_time)
        if rotation_configs and not isinstance(rotation_configs, list):
            raise TypeError("Expected argument 'rotation_configs' to be a list")
        pulumi.set(__self__, "rotation_configs", rotation_configs)
        if rotation_status and not isinstance(rotation_status, str):
            raise TypeError("Expected argument 'rotation_status' to be a str")
        pulumi.set(__self__, "rotation_status", rotation_status)
        if secret_contents and not isinstance(secret_contents, list):
            raise TypeError("Expected argument 'secret_contents' to be a list")
        pulumi.set(__self__, "secret_contents", secret_contents)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if secret_name and not isinstance(secret_name, str):
            raise TypeError("Expected argument 'secret_name' to be a str")
        pulumi.set(__self__, "secret_name", secret_name)
        if secret_rules and not isinstance(secret_rules, list):
            raise TypeError("Expected argument 'secret_rules' to be a list")
        pulumi.set(__self__, "secret_rules", secret_rules)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_current_version_expiry and not isinstance(time_of_current_version_expiry, str):
            raise TypeError("Expected argument 'time_of_current_version_expiry' to be a str")
        pulumi.set(__self__, "time_of_current_version_expiry", time_of_current_version_expiry)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment where you want to create the secret.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="currentVersionNumber")
    def current_version_number(self) -> str:
        """
        The version number of the secret version that's currently in use.
        """
        return pulumi.get(self, "current_version_number")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A brief description of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the secret.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The OCID of the master encryption key that is used to encrypt the secret. You must specify a symmetric key to encrypt the secret during import to the vault. You cannot encrypt secrets with asymmetric keys. Furthermore, the key must exist in the vault that you specify.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lastRotationTime")
    def last_rotation_time(self) -> str:
        """
        A property indicating when the secret was last rotated successfully, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "last_rotation_time")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state of the secret.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, Any]:
        """
        Additional metadata that you can use to provide context about how to use the secret or during rotation or other administrative tasks. For example, for a secret that you use to connect to a database, the additional metadata might specify the connection endpoint and the connection string. Provide additional metadata as key-value pairs.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="nextRotationTime")
    def next_rotation_time(self) -> str:
        """
        A property indicating when the secret is scheduled to be rotated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "next_rotation_time")

    @property
    @pulumi.getter(name="rotationConfigs")
    def rotation_configs(self) -> Sequence['outputs.GetSecretRotationConfigResult']:
        """
        Defines the frequency of the rotation and the information about the target system
        """
        return pulumi.get(self, "rotation_configs")

    @property
    @pulumi.getter(name="rotationStatus")
    def rotation_status(self) -> str:
        """
        Additional information about the status of the secret rotation
        """
        return pulumi.get(self, "rotation_status")

    @property
    @pulumi.getter(name="secretContents")
    def secret_contents(self) -> Sequence['outputs.GetSecretSecretContentResult']:
        return pulumi.get(self, "secret_contents")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        The user-friendly name of the secret. Avoid entering confidential information.
        """
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter(name="secretRules")
    def secret_rules(self) -> Sequence['outputs.GetSecretSecretRuleResult']:
        """
        A list of rules that control how the secret is used and managed.
        """
        return pulumi.get(self, "secret_rules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the secret.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        A property indicating when the secret was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfCurrentVersionExpiry")
    def time_of_current_version_expiry(self) -> str:
        """
        An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_current_version_expiry")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property indicating when to delete the secret, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The OCID of the Vault in which the secret exists
        """
        return pulumi.get(self, "vault_id")


class AwaitableGetSecretResult(GetSecretResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretResult(
            compartment_id=self.compartment_id,
            current_version_number=self.current_version_number,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            key_id=self.key_id,
            last_rotation_time=self.last_rotation_time,
            lifecycle_details=self.lifecycle_details,
            metadata=self.metadata,
            next_rotation_time=self.next_rotation_time,
            rotation_configs=self.rotation_configs,
            rotation_status=self.rotation_status,
            secret_contents=self.secret_contents,
            secret_id=self.secret_id,
            secret_name=self.secret_name,
            secret_rules=self.secret_rules,
            state=self.state,
            time_created=self.time_created,
            time_of_current_version_expiry=self.time_of_current_version_expiry,
            time_of_deletion=self.time_of_deletion,
            vault_id=self.vault_id)


def get_secret(secret_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretResult:
    """
    This data source provides details about a specific Secret resource in Oracle Cloud Infrastructure Vault service.

    Gets information about the specified secret.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_secret = oci.Vault.get_secret(secret_id=test_secret_oci_vault_secret["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str secret_id: The OCID of the secret.
    """
    __args__ = dict()
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Vault/getSecret:getSecret', __args__, opts=opts, typ=GetSecretResult).value

    return AwaitableGetSecretResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        current_version_number=pulumi.get(__ret__, 'current_version_number'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        key_id=pulumi.get(__ret__, 'key_id'),
        last_rotation_time=pulumi.get(__ret__, 'last_rotation_time'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        metadata=pulumi.get(__ret__, 'metadata'),
        next_rotation_time=pulumi.get(__ret__, 'next_rotation_time'),
        rotation_configs=pulumi.get(__ret__, 'rotation_configs'),
        rotation_status=pulumi.get(__ret__, 'rotation_status'),
        secret_contents=pulumi.get(__ret__, 'secret_contents'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        secret_name=pulumi.get(__ret__, 'secret_name'),
        secret_rules=pulumi.get(__ret__, 'secret_rules'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_current_version_expiry=pulumi.get(__ret__, 'time_of_current_version_expiry'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'),
        vault_id=pulumi.get(__ret__, 'vault_id'))


@_utilities.lift_output_func(get_secret)
def get_secret_output(secret_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecretResult]:
    """
    This data source provides details about a specific Secret resource in Oracle Cloud Infrastructure Vault service.

    Gets information about the specified secret.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_secret = oci.Vault.get_secret(secret_id=test_secret_oci_vault_secret["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str secret_id: The OCID of the secret.
    """
    ...
