# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetSecretVersionResult',
    'AwaitableGetSecretVersionResult',
    'get_secret_version',
    'get_secret_version_output',
]

@pulumi.output_type
class GetSecretVersionResult:
    """
    A collection of values returned by getSecretVersion.
    """
    def __init__(__self__, content_type=None, id=None, name=None, secret_id=None, secret_version_number=None, stages=None, time_created=None, time_of_current_version_expiry=None, time_of_deletion=None, version_number=None):
        if content_type and not isinstance(content_type, str):
            raise TypeError("Expected argument 'content_type' to be a str")
        pulumi.set(__self__, "content_type", content_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if secret_version_number and not isinstance(secret_version_number, str):
            raise TypeError("Expected argument 'secret_version_number' to be a str")
        pulumi.set(__self__, "secret_version_number", secret_version_number)
        if stages and not isinstance(stages, list):
            raise TypeError("Expected argument 'stages' to be a list")
        pulumi.set(__self__, "stages", stages)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_current_version_expiry and not isinstance(time_of_current_version_expiry, str):
            raise TypeError("Expected argument 'time_of_current_version_expiry' to be a str")
        pulumi.set(__self__, "time_of_current_version_expiry", time_of_current_version_expiry)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if version_number and not isinstance(version_number, str):
            raise TypeError("Expected argument 'version_number' to be a str")
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The content type of the secret version's secret contents.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the secret version. A name is unique across versions of a secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> str:
        """
        The OCID of the secret.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretVersionNumber")
    def secret_version_number(self) -> str:
        return pulumi.get(self, "secret_version_number")

    @property
    @pulumi.getter
    def stages(self) -> Sequence[str]:
        """
        A list of possible rotation states for the secret version. A secret version marked `CURRENT` is currently in use. A secret version marked `PENDING` is staged and available for use, but has not been applied on the target system and, therefore, has not been rotated into current, active use. The secret most recently uploaded to a vault is always marked `LATEST`. (The first version of a secret is always marked as both `CURRENT` and `LATEST`.) A secret version marked `PREVIOUS` is the secret version that was most recently marked `CURRENT`, before the last secret version rotation. A secret version marked `DEPRECATED` is neither current, pending, nor the previous one in use. Only secret versions marked `DEPRECATED` can be scheduled for deletion.
        """
        return pulumi.get(self, "stages")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        A optional property indicating when the secret version was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfCurrentVersionExpiry")
    def time_of_current_version_expiry(self) -> str:
        """
        An optional property indicating when the current secret version will expire, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_current_version_expiry")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> str:
        """
        An optional property indicating when to delete the secret version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> str:
        """
        The version number of the secret.
        """
        return pulumi.get(self, "version_number")


class AwaitableGetSecretVersionResult(GetSecretVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretVersionResult(
            content_type=self.content_type,
            id=self.id,
            name=self.name,
            secret_id=self.secret_id,
            secret_version_number=self.secret_version_number,
            stages=self.stages,
            time_created=self.time_created,
            time_of_current_version_expiry=self.time_of_current_version_expiry,
            time_of_deletion=self.time_of_deletion,
            version_number=self.version_number)


def get_secret_version(secret_id: Optional[str] = None,
                       secret_version_number: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretVersionResult:
    """
    This data source provides details about a specific Secret Version resource in Oracle Cloud Infrastructure Vault service.

    Gets information about the specified version of a secret.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_secret_version = oci.Vault.get_secret_version(secret_id=test_secret["id"],
        secret_version_number=secret_version_secret_version_number)
    ```
    <!--End PulumiCodeChooser -->


    :param str secret_id: The OCID of the secret.
    :param str secret_version_number: The version number of the secret.
    """
    __args__ = dict()
    __args__['secretId'] = secret_id
    __args__['secretVersionNumber'] = secret_version_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Vault/getSecretVersion:getSecretVersion', __args__, opts=opts, typ=GetSecretVersionResult).value

    return AwaitableGetSecretVersionResult(
        content_type=pulumi.get(__ret__, 'content_type'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        secret_version_number=pulumi.get(__ret__, 'secret_version_number'),
        stages=pulumi.get(__ret__, 'stages'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_current_version_expiry=pulumi.get(__ret__, 'time_of_current_version_expiry'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'),
        version_number=pulumi.get(__ret__, 'version_number'))


@_utilities.lift_output_func(get_secret_version)
def get_secret_version_output(secret_id: Optional[pulumi.Input[str]] = None,
                              secret_version_number: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecretVersionResult]:
    """
    This data source provides details about a specific Secret Version resource in Oracle Cloud Infrastructure Vault service.

    Gets information about the specified version of a secret.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_secret_version = oci.Vault.get_secret_version(secret_id=test_secret["id"],
        secret_version_number=secret_version_secret_version_number)
    ```
    <!--End PulumiCodeChooser -->


    :param str secret_id: The OCID of the secret.
    :param str secret_version_number: The version number of the secret.
    """
    ...
