"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, TypedDict


class ErrorsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ErrorsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ErrorsLinksTypedDict(TypedDict):
    documentation: ErrorsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ErrorsLinks(BaseModel):
    documentation: ErrorsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ErrorResponseData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ErrorsLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


@dataclass(unsafe_hash=True)
class ErrorResponse(ClientError):
    r"""An error response object."""

    data: ErrorResponseData = field(hash=False)

    def __init__(
        self,
        data: ErrorResponseData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
