# The PEP 484 type hints stub file for the QtDataVisualization module.
#
# Generated by SIP 6.8.6
#
# Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQtDataVisualization.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QAbstract3DGraph(QtGui.QWindow):

    class OptimizationHint(int):
        OptimizationDefault = ... # type: QAbstract3DGraph.OptimizationHint
        OptimizationStatic = ... # type: QAbstract3DGraph.OptimizationHint

    class ElementType(int):
        ElementNone = ... # type: QAbstract3DGraph.ElementType
        ElementSeries = ... # type: QAbstract3DGraph.ElementType
        ElementAxisXLabel = ... # type: QAbstract3DGraph.ElementType
        ElementAxisYLabel = ... # type: QAbstract3DGraph.ElementType
        ElementAxisZLabel = ... # type: QAbstract3DGraph.ElementType
        ElementCustomItem = ... # type: QAbstract3DGraph.ElementType

    class ShadowQuality(int):
        ShadowQualityNone = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualityLow = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualityMedium = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualityHigh = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualitySoftLow = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualitySoftMedium = ... # type: QAbstract3DGraph.ShadowQuality
        ShadowQualitySoftHigh = ... # type: QAbstract3DGraph.ShadowQuality

    class SelectionFlag(int):
        SelectionNone = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionItem = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionRow = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionItemAndRow = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionColumn = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionItemAndColumn = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionRowAndColumn = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionItemRowAndColumn = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionSlice = ... # type: QAbstract3DGraph.SelectionFlag
        SelectionMultiSeries = ... # type: QAbstract3DGraph.SelectionFlag

    class SelectionFlags(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def __ixor__(self, f: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> 'QAbstract3DGraph.SelectionFlags': ...
        def __xor__(self, f: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> 'QAbstract3DGraph.SelectionFlags': ...
        def __ior__(self, f: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> 'QAbstract3DGraph.SelectionFlags': ...
        def __or__(self, f: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> 'QAbstract3DGraph.SelectionFlags': ...
        def __iand__(self, f: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> 'QAbstract3DGraph.SelectionFlags': ...
        def __and__(self, f: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> 'QAbstract3DGraph.SelectionFlags': ...
        def __invert__(self) -> 'QAbstract3DGraph.SelectionFlags': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    class OptimizationHints(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def __ixor__(self, f: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> 'QAbstract3DGraph.OptimizationHints': ...
        def __xor__(self, f: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> 'QAbstract3DGraph.OptimizationHints': ...
        def __ior__(self, f: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> 'QAbstract3DGraph.OptimizationHints': ...
        def __or__(self, f: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> 'QAbstract3DGraph.OptimizationHints': ...
        def __iand__(self, f: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> 'QAbstract3DGraph.OptimizationHints': ...
        def __and__(self, f: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> 'QAbstract3DGraph.OptimizationHints': ...
        def __invert__(self) -> 'QAbstract3DGraph.OptimizationHints': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    def hasContext(self) -> bool: ...
    marginChanged: typing.ClassVar[QtCore.pyqtSignal]
    queriedGraphPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    localeChanged: typing.ClassVar[QtCore.pyqtSignal]
    reflectivityChanged: typing.ClassVar[QtCore.pyqtSignal]
    reflectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    horizontalAspectRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    radialLabelOffsetChanged: typing.ClassVar[QtCore.pyqtSignal]
    polarChanged: typing.ClassVar[QtCore.pyqtSignal]
    def margin(self) -> float: ...
    def setMargin(self, margin: float) -> None: ...
    def queriedGraphPosition(self) -> QtGui.QVector3D: ...
    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def reflectivity(self) -> float: ...
    def setReflectivity(self, reflectivity: float) -> None: ...
    def isReflection(self) -> bool: ...
    def setReflection(self, enable: bool) -> None: ...
    def horizontalAspectRatio(self) -> float: ...
    def setHorizontalAspectRatio(self, ratio: float) -> None: ...
    def radialLabelOffset(self) -> float: ...
    def setRadialLabelOffset(self, offset: float) -> None: ...
    def isPolar(self) -> bool: ...
    def setPolar(self, enable: bool) -> None: ...
    def customItems(self) -> typing.List['QCustom3DItem']: ...
    optimizationHintsChanged: typing.ClassVar[QtCore.pyqtSignal]
    aspectRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    orthoProjectionChanged: typing.ClassVar[QtCore.pyqtSignal]
    currentFpsChanged: typing.ClassVar[QtCore.pyqtSignal]
    measureFpsChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedElementChanged: typing.ClassVar[QtCore.pyqtSignal]
    def optimizationHints(self) -> 'QAbstract3DGraph.OptimizationHints': ...
    def setOptimizationHints(self, hints: typing.Union['QAbstract3DGraph.OptimizationHints', 'QAbstract3DGraph.OptimizationHint']) -> None: ...
    def aspectRatio(self) -> float: ...
    def setAspectRatio(self, ratio: float) -> None: ...
    def selectedElement(self) -> 'QAbstract3DGraph.ElementType': ...
    def isOrthoProjection(self) -> bool: ...
    def setOrthoProjection(self, enable: bool) -> None: ...
    def currentFps(self) -> float: ...
    def measureFps(self) -> bool: ...
    def setMeasureFps(self, enable: bool) -> None: ...
    def renderToImage(self, msaaSamples: int = ..., imageSize: QtCore.QSize = ...) -> QtGui.QImage: ...
    def selectedCustomItem(self) -> typing.Optional['QCustom3DItem']: ...
    def selectedCustomItemIndex(self) -> int: ...
    def selectedAxis(self) -> typing.Optional['QAbstract3DAxis']: ...
    def selectedLabelIndex(self) -> int: ...
    def releaseCustomItem(self, item: typing.Optional['QCustom3DItem']) -> None: ...
    def removeCustomItemAt(self, position: QtGui.QVector3D) -> None: ...
    def removeCustomItem(self, item: typing.Optional['QCustom3DItem']) -> None: ...
    def removeCustomItems(self) -> None: ...
    def addCustomItem(self, item: typing.Optional['QCustom3DItem']) -> int: ...
    def wheelEvent(self, event: typing.Optional[QtGui.QWheelEvent]) -> None: ...
    def mouseMoveEvent(self, event: typing.Optional[QtGui.QMouseEvent]) -> None: ...
    def mouseReleaseEvent(self, event: typing.Optional[QtGui.QMouseEvent]) -> None: ...
    def mousePressEvent(self, event: typing.Optional[QtGui.QMouseEvent]) -> None: ...
    def touchEvent(self, event: typing.Optional[QtGui.QTouchEvent]) -> None: ...
    def mouseDoubleClickEvent(self, event: typing.Optional[QtGui.QMouseEvent]) -> None: ...
    def exposeEvent(self, event: typing.Optional[QtGui.QExposeEvent]) -> None: ...
    def resizeEvent(self, event: typing.Optional[QtGui.QResizeEvent]) -> None: ...
    def event(self, event: typing.Optional[QtCore.QEvent]) -> bool: ...
    shadowQualityChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeThemeChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeInputHandlerChanged: typing.ClassVar[QtCore.pyqtSignal]
    def shadowsSupported(self) -> bool: ...
    def activeInputHandler(self) -> typing.Optional['QAbstract3DInputHandler']: ...
    def clearSelection(self) -> None: ...
    def scene(self) -> typing.Optional['Q3DScene']: ...
    def shadowQuality(self) -> 'QAbstract3DGraph.ShadowQuality': ...
    def setShadowQuality(self, quality: 'QAbstract3DGraph.ShadowQuality') -> None: ...
    def selectionMode(self) -> 'QAbstract3DGraph.SelectionFlags': ...
    def setSelectionMode(self, mode: typing.Union['QAbstract3DGraph.SelectionFlags', 'QAbstract3DGraph.SelectionFlag']) -> None: ...
    def themes(self) -> typing.List['Q3DTheme']: ...
    def activeTheme(self) -> typing.Optional['Q3DTheme']: ...
    def setActiveTheme(self, theme: typing.Optional['Q3DTheme']) -> None: ...
    def releaseTheme(self, theme: typing.Optional['Q3DTheme']) -> None: ...
    def addTheme(self, theme: typing.Optional['Q3DTheme']) -> None: ...
    def inputHandlers(self) -> typing.List['QAbstract3DInputHandler']: ...
    def setActiveInputHandler(self, inputHandler: typing.Optional['QAbstract3DInputHandler']) -> None: ...
    def releaseInputHandler(self, inputHandler: typing.Optional['QAbstract3DInputHandler']) -> None: ...
    def addInputHandler(self, inputHandler: typing.Optional['QAbstract3DInputHandler']) -> None: ...


class Q3DBars('QAbstract3DGraph'):

    def __init__(self, format: typing.Optional[QtGui.QSurfaceFormat] = ..., parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

    floorLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def floorLevel(self) -> float: ...
    def setFloorLevel(self, level: float) -> None: ...
    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    primarySeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowAxisChanged: typing.ClassVar[QtCore.pyqtSignal]
    barSpacingRelativeChanged: typing.ClassVar[QtCore.pyqtSignal]
    barSpacingChanged: typing.ClassVar[QtCore.pyqtSignal]
    barThicknessChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiSeriesUniformChanged: typing.ClassVar[QtCore.pyqtSignal]
    def selectedSeries(self) -> typing.Optional['QBar3DSeries']: ...
    def axes(self) -> typing.List['QAbstract3DAxis']: ...
    def releaseAxis(self, axis: typing.Optional['QAbstract3DAxis']) -> None: ...
    def addAxis(self, axis: typing.Optional['QAbstract3DAxis']) -> None: ...
    def valueAxis(self) -> typing.Optional['QValue3DAxis']: ...
    def setValueAxis(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def columnAxis(self) -> typing.Optional['QCategory3DAxis']: ...
    def setColumnAxis(self, axis: typing.Optional['QCategory3DAxis']) -> None: ...
    def rowAxis(self) -> typing.Optional['QCategory3DAxis']: ...
    def setRowAxis(self, axis: typing.Optional['QCategory3DAxis']) -> None: ...
    def isBarSpacingRelative(self) -> bool: ...
    def setBarSpacingRelative(self, relative: bool) -> None: ...
    def barSpacing(self) -> QtCore.QSizeF: ...
    def setBarSpacing(self, spacing: QtCore.QSizeF) -> None: ...
    def barThickness(self) -> float: ...
    def setBarThickness(self, thicknessRatio: float) -> None: ...
    def isMultiSeriesUniform(self) -> bool: ...
    def setMultiSeriesUniform(self, uniform: bool) -> None: ...
    def seriesList(self) -> typing.List['QBar3DSeries']: ...
    def insertSeries(self, index: int, series: typing.Optional['QBar3DSeries']) -> None: ...
    def removeSeries(self, series: typing.Optional['QBar3DSeries']) -> None: ...
    def addSeries(self, series: typing.Optional['QBar3DSeries']) -> None: ...
    def primarySeries(self) -> typing.Optional['QBar3DSeries']: ...
    def setPrimarySeries(self, series: typing.Optional['QBar3DSeries']) -> None: ...


class Q3DObject(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def isDirty(self) -> bool: ...
    def setDirty(self, dirty: bool) -> None: ...
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setPosition(self, position: QtGui.QVector3D) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def parentScene(self) -> typing.Optional['Q3DScene']: ...
    def copyValuesFrom(self, source: 'Q3DObject') -> None: ...


class Q3DCamera('Q3DObject'):

    class CameraPreset(int):
        CameraPresetNone = ... # type: Q3DCamera.CameraPreset
        CameraPresetFrontLow = ... # type: Q3DCamera.CameraPreset
        CameraPresetFront = ... # type: Q3DCamera.CameraPreset
        CameraPresetFrontHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetLeftLow = ... # type: Q3DCamera.CameraPreset
        CameraPresetLeft = ... # type: Q3DCamera.CameraPreset
        CameraPresetLeftHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetRightLow = ... # type: Q3DCamera.CameraPreset
        CameraPresetRight = ... # type: Q3DCamera.CameraPreset
        CameraPresetRightHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetBehindLow = ... # type: Q3DCamera.CameraPreset
        CameraPresetBehind = ... # type: Q3DCamera.CameraPreset
        CameraPresetBehindHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetIsometricLeft = ... # type: Q3DCamera.CameraPreset
        CameraPresetIsometricLeftHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetIsometricRight = ... # type: Q3DCamera.CameraPreset
        CameraPresetIsometricRightHigh = ... # type: Q3DCamera.CameraPreset
        CameraPresetDirectlyAbove = ... # type: Q3DCamera.CameraPreset
        CameraPresetDirectlyAboveCW45 = ... # type: Q3DCamera.CameraPreset
        CameraPresetDirectlyAboveCCW45 = ... # type: Q3DCamera.CameraPreset
        CameraPresetFrontBelow = ... # type: Q3DCamera.CameraPreset
        CameraPresetLeftBelow = ... # type: Q3DCamera.CameraPreset
        CameraPresetRightBelow = ... # type: Q3DCamera.CameraPreset
        CameraPresetBehindBelow = ... # type: Q3DCamera.CameraPreset
        CameraPresetDirectlyBelow = ... # type: Q3DCamera.CameraPreset

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    targetChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxZoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    minZoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTarget(self, target: QtGui.QVector3D) -> None: ...
    def target(self) -> QtGui.QVector3D: ...
    def setMaxZoomLevel(self, zoomLevel: float) -> None: ...
    def maxZoomLevel(self) -> float: ...
    def setMinZoomLevel(self, zoomLevel: float) -> None: ...
    def minZoomLevel(self) -> float: ...
    wrapYRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    wrapXRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    cameraPresetChanged: typing.ClassVar[QtCore.pyqtSignal]
    zoomLevelChanged: typing.ClassVar[QtCore.pyqtSignal]
    yRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    xRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setZoomLevel(self, zoomLevel: float) -> None: ...
    def zoomLevel(self) -> float: ...
    def setCameraPosition(self, horizontal: float, vertical: float, zoom: float = ...) -> None: ...
    def setCameraPreset(self, preset: 'Q3DCamera.CameraPreset') -> None: ...
    def cameraPreset(self) -> 'Q3DCamera.CameraPreset': ...
    def copyValuesFrom(self, source: 'Q3DObject') -> None: ...
    def setWrapYRotation(self, isEnabled: bool) -> None: ...
    def wrapYRotation(self) -> bool: ...
    def setWrapXRotation(self, isEnabled: bool) -> None: ...
    def wrapXRotation(self) -> bool: ...
    def setYRotation(self, rotation: float) -> None: ...
    def yRotation(self) -> float: ...
    def setXRotation(self, rotation: float) -> None: ...
    def xRotation(self) -> float: ...


class QAbstract3DInputHandler(QtCore.QObject):

    class InputView(int):
        InputViewNone = ... # type: QAbstract3DInputHandler.InputView
        InputViewOnPrimary = ... # type: QAbstract3DInputHandler.InputView
        InputViewOnSecondary = ... # type: QAbstract3DInputHandler.InputView

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def previousInputPos(self) -> QtCore.QPoint: ...
    def setPreviousInputPos(self, position: QtCore.QPoint) -> None: ...
    def prevDistance(self) -> int: ...
    def setPrevDistance(self, distance: int) -> None: ...
    sceneChanged: typing.ClassVar[QtCore.pyqtSignal]
    inputViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setScene(self, scene: typing.Optional['Q3DScene']) -> None: ...
    def scene(self) -> typing.Optional['Q3DScene']: ...
    def setInputPosition(self, position: QtCore.QPoint) -> None: ...
    def inputPosition(self) -> QtCore.QPoint: ...
    def setInputView(self, inputView: 'QAbstract3DInputHandler.InputView') -> None: ...
    def inputView(self) -> 'QAbstract3DInputHandler.InputView': ...
    def wheelEvent(self, event: typing.Optional[QtGui.QWheelEvent]) -> None: ...
    def mouseMoveEvent(self, event: typing.Optional[QtGui.QMouseEvent], mousePos: QtCore.QPoint) -> None: ...
    def mouseReleaseEvent(self, event: typing.Optional[QtGui.QMouseEvent], mousePos: QtCore.QPoint) -> None: ...
    def mousePressEvent(self, event: typing.Optional[QtGui.QMouseEvent], mousePos: QtCore.QPoint) -> None: ...
    def touchEvent(self, event: typing.Optional[QtGui.QTouchEvent]) -> None: ...
    def mouseDoubleClickEvent(self, event: typing.Optional[QtGui.QMouseEvent]) -> None: ...


class Q3DInputHandler('QAbstract3DInputHandler'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    zoomAtTargetEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectionEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    zoomEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isZoomAtTargetEnabled(self) -> bool: ...
    def setZoomAtTargetEnabled(self, enable: bool) -> None: ...
    def isSelectionEnabled(self) -> bool: ...
    def setSelectionEnabled(self, enable: bool) -> None: ...
    def isZoomEnabled(self) -> bool: ...
    def setZoomEnabled(self, enable: bool) -> None: ...
    def isRotationEnabled(self) -> bool: ...
    def setRotationEnabled(self, enable: bool) -> None: ...
    def wheelEvent(self, event: typing.Optional[QtGui.QWheelEvent]) -> None: ...
    def mouseMoveEvent(self, event: typing.Optional[QtGui.QMouseEvent], mousePos: QtCore.QPoint) -> None: ...
    def mouseReleaseEvent(self, event: typing.Optional[QtGui.QMouseEvent], mousePos: QtCore.QPoint) -> None: ...
    def mousePressEvent(self, event: typing.Optional[QtGui.QMouseEvent], mousePos: QtCore.QPoint) -> None: ...


class Q3DLight('Q3DObject'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    autoPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isAutoPosition(self) -> bool: ...
    def setAutoPosition(self, enabled: bool) -> None: ...


class Q3DScatter('QAbstract3DGraph'):

    def __init__(self, format: typing.Optional[QtGui.QSurfaceFormat] = ..., parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisZChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXChanged: typing.ClassVar[QtCore.pyqtSignal]
    def selectedSeries(self) -> typing.Optional['QScatter3DSeries']: ...
    def axes(self) -> typing.List['QValue3DAxis']: ...
    def releaseAxis(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def addAxis(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def axisZ(self) -> typing.Optional['QValue3DAxis']: ...
    def setAxisZ(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def axisY(self) -> typing.Optional['QValue3DAxis']: ...
    def setAxisY(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def axisX(self) -> typing.Optional['QValue3DAxis']: ...
    def setAxisX(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def seriesList(self) -> typing.List['QScatter3DSeries']: ...
    def removeSeries(self, series: typing.Optional['QScatter3DSeries']) -> None: ...
    def addSeries(self, series: typing.Optional['QScatter3DSeries']) -> None: ...


class Q3DScene(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    graphPositionQueryChanged: typing.ClassVar[QtCore.pyqtSignal]
    def graphPositionQuery(self) -> QtCore.QPoint: ...
    def setGraphPositionQuery(self, point: QtCore.QPoint) -> None: ...
    selectionQueryPositionChanged: typing.ClassVar[QtCore.pyqtSignal]
    devicePixelRatioChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeLightChanged: typing.ClassVar[QtCore.pyqtSignal]
    activeCameraChanged: typing.ClassVar[QtCore.pyqtSignal]
    slicingActiveChanged: typing.ClassVar[QtCore.pyqtSignal]
    secondarySubviewOnTopChanged: typing.ClassVar[QtCore.pyqtSignal]
    secondarySubViewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    primarySubViewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    viewportChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setDevicePixelRatio(self, pixelRatio: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def setActiveLight(self, light: typing.Optional['Q3DLight']) -> None: ...
    def activeLight(self) -> typing.Optional['Q3DLight']: ...
    def setActiveCamera(self, camera: typing.Optional['Q3DCamera']) -> None: ...
    def activeCamera(self) -> typing.Optional['Q3DCamera']: ...
    def isSecondarySubviewOnTop(self) -> bool: ...
    def setSecondarySubviewOnTop(self, isSecondaryOnTop: bool) -> None: ...
    def isSlicingActive(self) -> bool: ...
    def setSlicingActive(self, isSlicing: bool) -> None: ...
    @staticmethod
    def invalidSelectionPoint() -> QtCore.QPoint: ...
    def selectionQueryPosition(self) -> QtCore.QPoint: ...
    def setSelectionQueryPosition(self, point: QtCore.QPoint) -> None: ...
    def isPointInSecondarySubView(self, point: QtCore.QPoint) -> bool: ...
    def setSecondarySubViewport(self, secondarySubViewport: QtCore.QRect) -> None: ...
    def secondarySubViewport(self) -> QtCore.QRect: ...
    def isPointInPrimarySubView(self, point: QtCore.QPoint) -> bool: ...
    def setPrimarySubViewport(self, primarySubViewport: QtCore.QRect) -> None: ...
    def primarySubViewport(self) -> QtCore.QRect: ...
    def viewport(self) -> QtCore.QRect: ...


class Q3DSurface('QAbstract3DGraph'):

    def __init__(self, format: typing.Optional[QtGui.QSurfaceFormat] = ..., parent: typing.Optional[QtGui.QWindow] = ...) -> None: ...

    flipHorizontalGridChanged: typing.ClassVar[QtCore.pyqtSignal]
    def flipHorizontalGrid(self) -> bool: ...
    def setFlipHorizontalGrid(self, flip: bool) -> None: ...
    selectedSeriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisZChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisYChanged: typing.ClassVar[QtCore.pyqtSignal]
    axisXChanged: typing.ClassVar[QtCore.pyqtSignal]
    def selectedSeries(self) -> typing.Optional['QSurface3DSeries']: ...
    def axes(self) -> typing.List['QValue3DAxis']: ...
    def releaseAxis(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def addAxis(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def axisZ(self) -> typing.Optional['QValue3DAxis']: ...
    def setAxisZ(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def axisY(self) -> typing.Optional['QValue3DAxis']: ...
    def setAxisY(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def axisX(self) -> typing.Optional['QValue3DAxis']: ...
    def setAxisX(self, axis: typing.Optional['QValue3DAxis']) -> None: ...
    def seriesList(self) -> typing.List['QSurface3DSeries']: ...
    def removeSeries(self, series: typing.Optional['QSurface3DSeries']) -> None: ...
    def addSeries(self, series: typing.Optional['QSurface3DSeries']) -> None: ...


class Q3DTheme(QtCore.QObject):

    class Theme(int):
        ThemeQt = ... # type: Q3DTheme.Theme
        ThemePrimaryColors = ... # type: Q3DTheme.Theme
        ThemeDigia = ... # type: Q3DTheme.Theme
        ThemeStoneMoss = ... # type: Q3DTheme.Theme
        ThemeArmyBlue = ... # type: Q3DTheme.Theme
        ThemeRetro = ... # type: Q3DTheme.Theme
        ThemeEbony = ... # type: Q3DTheme.Theme
        ThemeIsabelle = ... # type: Q3DTheme.Theme
        ThemeUserDefined = ... # type: Q3DTheme.Theme

    class ColorStyle(int):
        ColorStyleUniform = ... # type: Q3DTheme.ColorStyle
        ColorStyleObjectGradient = ... # type: Q3DTheme.ColorStyle
        ColorStyleRangeGradient = ... # type: Q3DTheme.ColorStyle

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, themeType: 'Q3DTheme.Theme', parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    colorStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBackgroundEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    fontChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBorderEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    highlightLightStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    ambientLightStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    lightStrengthChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseGradientsChanged: typing.ClassVar[QtCore.pyqtSignal]
    lightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    gridLineColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelBackgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelTextColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    windowColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseColorsChanged: typing.ClassVar[QtCore.pyqtSignal]
    typeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def colorStyle(self) -> 'Q3DTheme.ColorStyle': ...
    def setColorStyle(self, style: 'Q3DTheme.ColorStyle') -> None: ...
    def isLabelBackgroundEnabled(self) -> bool: ...
    def setLabelBackgroundEnabled(self, enabled: bool) -> None: ...
    def isGridEnabled(self) -> bool: ...
    def setGridEnabled(self, enabled: bool) -> None: ...
    def isBackgroundEnabled(self) -> bool: ...
    def setBackgroundEnabled(self, enabled: bool) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def isLabelBorderEnabled(self) -> bool: ...
    def setLabelBorderEnabled(self, enabled: bool) -> None: ...
    def highlightLightStrength(self) -> float: ...
    def setHighlightLightStrength(self, strength: float) -> None: ...
    def ambientLightStrength(self) -> float: ...
    def setAmbientLightStrength(self, strength: float) -> None: ...
    def lightStrength(self) -> float: ...
    def setLightStrength(self, strength: float) -> None: ...
    def multiHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setMultiHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def singleHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setSingleHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def baseGradients(self) -> typing.List[QtGui.QLinearGradient]: ...
    def setBaseGradients(self, gradients: typing.Iterable[QtGui.QLinearGradient]) -> None: ...
    def lightColor(self) -> QtGui.QColor: ...
    def setLightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def multiHighlightColor(self) -> QtGui.QColor: ...
    def setMultiHighlightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def singleHighlightColor(self) -> QtGui.QColor: ...
    def setSingleHighlightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def gridLineColor(self) -> QtGui.QColor: ...
    def setGridLineColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def labelBackgroundColor(self) -> QtGui.QColor: ...
    def setLabelBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def labelTextColor(self) -> QtGui.QColor: ...
    def setLabelTextColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def windowColor(self) -> QtGui.QColor: ...
    def setWindowColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def baseColors(self) -> typing.List[QtGui.QColor]: ...
    def setBaseColors(self, colors: typing.Iterable[typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]]) -> None: ...
    def type(self) -> 'Q3DTheme.Theme': ...
    def setType(self, themeType: 'Q3DTheme.Theme') -> None: ...


class QAbstract3DAxis(QtCore.QObject):

    class AxisType(int):
        AxisTypeNone = ... # type: QAbstract3DAxis.AxisType
        AxisTypeCategory = ... # type: QAbstract3DAxis.AxisType
        AxisTypeValue = ... # type: QAbstract3DAxis.AxisType

    class AxisOrientation(int):
        AxisOrientationNone = ... # type: QAbstract3DAxis.AxisOrientation
        AxisOrientationX = ... # type: QAbstract3DAxis.AxisOrientation
        AxisOrientationY = ... # type: QAbstract3DAxis.AxisOrientation
        AxisOrientationZ = ... # type: QAbstract3DAxis.AxisOrientation

    titleFixedChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelAutoRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isTitleFixed(self) -> bool: ...
    def setTitleFixed(self, fixed: bool) -> None: ...
    def isTitleVisible(self) -> bool: ...
    def setTitleVisible(self, visible: bool) -> None: ...
    def labelAutoRotation(self) -> float: ...
    def setLabelAutoRotation(self, angle: float) -> None: ...
    autoAdjustRangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    rangeChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxChanged: typing.ClassVar[QtCore.pyqtSignal]
    minChanged: typing.ClassVar[QtCore.pyqtSignal]
    orientationChanged: typing.ClassVar[QtCore.pyqtSignal]
    labelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    titleChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTitle(self, title: typing.Optional[str]) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def isAutoAdjustRange(self) -> bool: ...
    def setAutoAdjustRange(self, autoAdjust: bool) -> None: ...
    def max(self) -> float: ...
    def setMax(self, max: float) -> None: ...
    def min(self) -> float: ...
    def setMin(self, min: float) -> None: ...
    def type(self) -> 'QAbstract3DAxis.AxisType': ...
    def orientation(self) -> 'QAbstract3DAxis.AxisOrientation': ...
    def labels(self) -> typing.List[str]: ...
    def setLabels(self, labels: typing.Iterable[typing.Optional[str]]) -> None: ...
    def title(self) -> str: ...


class QAbstract3DSeries(QtCore.QObject):

    class Mesh(int):
        MeshUserDefined = ... # type: QAbstract3DSeries.Mesh
        MeshBar = ... # type: QAbstract3DSeries.Mesh
        MeshCube = ... # type: QAbstract3DSeries.Mesh
        MeshPyramid = ... # type: QAbstract3DSeries.Mesh
        MeshCone = ... # type: QAbstract3DSeries.Mesh
        MeshCylinder = ... # type: QAbstract3DSeries.Mesh
        MeshBevelBar = ... # type: QAbstract3DSeries.Mesh
        MeshBevelCube = ... # type: QAbstract3DSeries.Mesh
        MeshSphere = ... # type: QAbstract3DSeries.Mesh
        MeshMinimal = ... # type: QAbstract3DSeries.Mesh
        MeshArrow = ... # type: QAbstract3DSeries.Mesh
        MeshPoint = ... # type: QAbstract3DSeries.Mesh

    class SeriesType(int):
        SeriesTypeNone = ... # type: QAbstract3DSeries.SeriesType
        SeriesTypeBar = ... # type: QAbstract3DSeries.SeriesType
        SeriesTypeScatter = ... # type: QAbstract3DSeries.SeriesType
        SeriesTypeSurface = ... # type: QAbstract3DSeries.SeriesType

    itemLabelVisibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemLabelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isItemLabelVisible(self) -> bool: ...
    def setItemLabelVisible(self, visible: bool) -> None: ...
    def itemLabel(self) -> str: ...
    nameChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    multiHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    singleHighlightColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseGradientChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorStyleChanged: typing.ClassVar[QtCore.pyqtSignal]
    userDefinedMeshChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshRotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshSmoothChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibilityChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemLabelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setMeshAxisAndAngle(self, axis: QtGui.QVector3D, angle: float) -> None: ...
    def name(self) -> str: ...
    def setName(self, name: typing.Optional[str]) -> None: ...
    def multiHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setMultiHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def multiHighlightColor(self) -> QtGui.QColor: ...
    def setMultiHighlightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def singleHighlightGradient(self) -> QtGui.QLinearGradient: ...
    def setSingleHighlightGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def singleHighlightColor(self) -> QtGui.QColor: ...
    def setSingleHighlightColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def baseGradient(self) -> QtGui.QLinearGradient: ...
    def setBaseGradient(self, gradient: QtGui.QLinearGradient) -> None: ...
    def baseColor(self) -> QtGui.QColor: ...
    def setBaseColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def colorStyle(self) -> 'Q3DTheme.ColorStyle': ...
    def setColorStyle(self, style: 'Q3DTheme.ColorStyle') -> None: ...
    def userDefinedMesh(self) -> str: ...
    def setUserDefinedMesh(self, fileName: typing.Optional[str]) -> None: ...
    def meshRotation(self) -> QtGui.QQuaternion: ...
    def setMeshRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def isMeshSmooth(self) -> bool: ...
    def setMeshSmooth(self, enable: bool) -> None: ...
    def mesh(self) -> 'QAbstract3DSeries.Mesh': ...
    def setMesh(self, mesh: 'QAbstract3DSeries.Mesh') -> None: ...
    def isVisible(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def itemLabelFormat(self) -> str: ...
    def setItemLabelFormat(self, format: typing.Optional[str]) -> None: ...
    def type(self) -> 'QAbstract3DSeries.SeriesType': ...


class QAbstractDataProxy(QtCore.QObject):

    class DataType(int):
        DataTypeNone = ... # type: QAbstractDataProxy.DataType
        DataTypeBar = ... # type: QAbstractDataProxy.DataType
        DataTypeScatter = ... # type: QAbstractDataProxy.DataType
        DataTypeSurface = ... # type: QAbstractDataProxy.DataType

    def type(self) -> 'QAbstractDataProxy.DataType': ...


class QBar3DSeries('QAbstract3DSeries'):

    @typing.overload
    def __init__(self, dataProxy: typing.Optional['QBarDataProxy'], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    meshAngleChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedBarChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def meshAngle(self) -> float: ...
    def setMeshAngle(self, angle: float) -> None: ...
    @staticmethod
    def invalidSelectionPosition() -> QtCore.QPoint: ...
    def selectedBar(self) -> QtCore.QPoint: ...
    def setSelectedBar(self, position: QtCore.QPoint) -> None: ...
    def dataProxy(self) -> typing.Optional['QBarDataProxy']: ...
    def setDataProxy(self, proxy: typing.Optional['QBarDataProxy']) -> None: ...


class QBarDataItem(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, value: float) -> None: ...
    @typing.overload
    def __init__(self, value: float, angle: float) -> None: ...
    @typing.overload
    def __init__(self, other: 'QBarDataItem') -> None: ...

    def rotation(self) -> float: ...
    def setRotation(self, angle: float) -> None: ...
    def value(self) -> float: ...
    def setValue(self, value: float) -> None: ...


class QBarDataProxy('QAbstractDataProxy'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsInserted: typing.ClassVar[QtCore.pyqtSignal]
    rowsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    rowsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    def series(self) -> typing.Optional['QBar3DSeries']: ...
    def removeRows(self, rowIndex: int, removeCount: int, removeLabels: bool = ...) -> None: ...
    @typing.overload
    def insertRows(self, rowIndex: int, rows: typing.Iterable[typing.Iterable['QBarDataItem']]) -> None: ...
    @typing.overload
    def insertRows(self, rowIndex: int, rows: typing.Iterable[typing.Iterable['QBarDataItem']], labels: typing.Iterable[typing.Optional[str]]) -> None: ...
    @typing.overload
    def insertRow(self, rowIndex: int, row: typing.Optional[typing.Iterable['QBarDataItem']]) -> None: ...
    @typing.overload
    def insertRow(self, rowIndex: int, row: typing.Optional[typing.Iterable['QBarDataItem']], label: typing.Optional[str]) -> None: ...
    @typing.overload
    def addRows(self, rows: typing.Iterable[typing.Iterable['QBarDataItem']]) -> int: ...
    @typing.overload
    def addRows(self, rows: typing.Iterable[typing.Iterable['QBarDataItem']], labels: typing.Iterable[typing.Optional[str]]) -> int: ...
    @typing.overload
    def addRow(self, row: typing.Optional[typing.Iterable['QBarDataItem']]) -> int: ...
    @typing.overload
    def addRow(self, row: typing.Optional[typing.Iterable['QBarDataItem']], label: typing.Optional[str]) -> int: ...
    @typing.overload
    def setItem(self, rowIndex: int, columnIndex: int, item: 'QBarDataItem') -> None: ...
    @typing.overload
    def setItem(self, position: QtCore.QPoint, item: 'QBarDataItem') -> None: ...
    @typing.overload
    def setRows(self, rowIndex: int, rows: typing.Iterable[typing.Iterable['QBarDataItem']]) -> None: ...
    @typing.overload
    def setRows(self, rowIndex: int, rows: typing.Iterable[typing.Iterable['QBarDataItem']], labels: typing.Iterable[typing.Optional[str]]) -> None: ...
    @typing.overload
    def setRow(self, rowIndex: int, row: typing.Optional[typing.Iterable['QBarDataItem']]) -> None: ...
    @typing.overload
    def setRow(self, rowIndex: int, row: typing.Optional[typing.Iterable['QBarDataItem']], label: typing.Optional[str]) -> None: ...
    @typing.overload
    def resetArray(self) -> None: ...
    @typing.overload
    def resetArray(self, newArray: typing.Optional[typing.Iterable[typing.Iterable['QBarDataItem']]]) -> None: ...
    @typing.overload
    def resetArray(self, newArray: typing.Optional[typing.Iterable[typing.Iterable['QBarDataItem']]], rowLabels: typing.Iterable[typing.Optional[str]], columnLabels: typing.Iterable[typing.Optional[str]]) -> None: ...
    @typing.overload
    def itemAt(self, rowIndex: int, columnIndex: int) -> typing.Optional['QBarDataItem']: ...
    @typing.overload
    def itemAt(self, position: QtCore.QPoint) -> typing.Optional['QBarDataItem']: ...
    def rowAt(self, rowIndex: int) -> typing.Optional[typing.List['QBarDataItem']]: ...
    def array(self) -> typing.Optional[typing.List[typing.List['QBarDataItem']]]: ...
    def setColumnLabels(self, labels: typing.Iterable[typing.Optional[str]]) -> None: ...
    def columnLabels(self) -> typing.List[str]: ...
    def setRowLabels(self, labels: typing.Iterable[typing.Optional[str]]) -> None: ...
    def rowLabels(self) -> typing.List[str]: ...
    def rowCount(self) -> int: ...


class QCategory3DAxis('QAbstract3DAxis'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    labelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labels(self) -> typing.List[str]: ...
    def setLabels(self, labels: typing.Iterable[typing.Optional[str]]) -> None: ...


class QCustom3DItem(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, meshFile: typing.Optional[str], position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, texture: QtGui.QImage, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    scalingAbsoluteChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isScalingAbsolute(self) -> bool: ...
    def setScalingAbsolute(self, scalingAbsolute: bool) -> None: ...
    shadowCastingChanged: typing.ClassVar[QtCore.pyqtSignal]
    visibleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationChanged: typing.ClassVar[QtCore.pyqtSignal]
    scalingChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionAbsoluteChanged: typing.ClassVar[QtCore.pyqtSignal]
    positionChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    meshFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setTextureImage(self, textureImage: QtGui.QImage) -> None: ...
    def setRotationAxisAndAngle(self, axis: QtGui.QVector3D, angle: float) -> None: ...
    def isShadowCasting(self) -> bool: ...
    def setShadowCasting(self, enabled: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def rotation(self) -> QtGui.QQuaternion: ...
    def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def scaling(self) -> QtGui.QVector3D: ...
    def setScaling(self, scaling: QtGui.QVector3D) -> None: ...
    def isPositionAbsolute(self) -> bool: ...
    def setPositionAbsolute(self, positionAbsolute: bool) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, position: QtGui.QVector3D) -> None: ...
    def textureFile(self) -> str: ...
    def setTextureFile(self, textureFile: typing.Optional[str]) -> None: ...
    def meshFile(self) -> str: ...
    def setMeshFile(self, meshFile: typing.Optional[str]) -> None: ...


class QCustom3DLabel('QCustom3DItem'):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, text: typing.Optional[str], font: QtGui.QFont, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    facingCameraChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    borderEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    backgroundColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    textColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    fontChanged: typing.ClassVar[QtCore.pyqtSignal]
    textChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isFacingCamera(self) -> bool: ...
    def setFacingCamera(self, enabled: bool) -> None: ...
    def isBackgroundEnabled(self) -> bool: ...
    def setBackgroundEnabled(self, enabled: bool) -> None: ...
    def isBorderEnabled(self) -> bool: ...
    def setBorderEnabled(self, enabled: bool) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def textColor(self) -> QtGui.QColor: ...
    def setTextColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def text(self) -> str: ...
    def setText(self, text: typing.Optional[str]) -> None: ...


class QCustom3DVolume('QCustom3DItem'):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D, scaling: QtGui.QVector3D, rotation: QtGui.QQuaternion, textureWidth: int, textureHeight: int, textureDepth: int, textureData: typing.Optional[sip.array], textureFormat: QtGui.QImage.Format, colorTable: typing.Iterable[int], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    sliceFrameThicknessesChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameGapsChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameWidthsChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceFrameColorChanged: typing.ClassVar[QtCore.pyqtSignal]
    drawSliceFramesChanged: typing.ClassVar[QtCore.pyqtSignal]
    drawSlicesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useHighDefShaderChanged: typing.ClassVar[QtCore.pyqtSignal]
    preserveOpacityChanged: typing.ClassVar[QtCore.pyqtSignal]
    alphaMultiplierChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureDataChanged: typing.ClassVar[QtCore.pyqtSignal]
    colorTableChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexZChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexYChanged: typing.ClassVar[QtCore.pyqtSignal]
    sliceIndexXChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureDepthChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureHeightChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureWidthChanged: typing.ClassVar[QtCore.pyqtSignal]
    def renderSlice(self, axis: QtCore.Qt.Axis, index: int) -> QtGui.QImage: ...
    def sliceFrameThicknesses(self) -> QtGui.QVector3D: ...
    def setSliceFrameThicknesses(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameGaps(self) -> QtGui.QVector3D: ...
    def setSliceFrameGaps(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameWidths(self) -> QtGui.QVector3D: ...
    def setSliceFrameWidths(self, values: QtGui.QVector3D) -> None: ...
    def sliceFrameColor(self) -> QtGui.QColor: ...
    def setSliceFrameColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def drawSliceFrames(self) -> bool: ...
    def setDrawSliceFrames(self, enable: bool) -> None: ...
    def drawSlices(self) -> bool: ...
    def setDrawSlices(self, enable: bool) -> None: ...
    def useHighDefShader(self) -> bool: ...
    def setUseHighDefShader(self, enable: bool) -> None: ...
    def preserveOpacity(self) -> bool: ...
    def setPreserveOpacity(self, enable: bool) -> None: ...
    def alphaMultiplier(self) -> float: ...
    def setAlphaMultiplier(self, mult: float) -> None: ...
    def textureFormat(self) -> QtGui.QImage.Format: ...
    def setTextureFormat(self, format: QtGui.QImage.Format) -> None: ...
    @typing.overload
    def setSubTextureData(self, axis: QtCore.Qt.Axis, index: int, data: typing.Optional[PyQt5.sip.voidptr]) -> None: ...
    @typing.overload
    def setSubTextureData(self, axis: QtCore.Qt.Axis, index: int, image: QtGui.QImage) -> None: ...
    def textureData(self) -> typing.Optional[sip.array]: ...
    def createTextureData(self, images: typing.Iterable[QtGui.QImage]) -> typing.Optional[sip.array]: ...
    def setTextureData(self, data: typing.Optional[sip.array]) -> None: ...
    def colorTable(self) -> typing.List[int]: ...
    def setColorTable(self, colors: typing.Iterable[int]) -> None: ...
    def setSliceIndices(self, x: int, y: int, z: int) -> None: ...
    def sliceIndexZ(self) -> int: ...
    def setSliceIndexZ(self, value: int) -> None: ...
    def sliceIndexY(self) -> int: ...
    def setSliceIndexY(self, value: int) -> None: ...
    def sliceIndexX(self) -> int: ...
    def setSliceIndexX(self, value: int) -> None: ...
    def textureDataWidth(self) -> int: ...
    def setTextureDimensions(self, width: int, height: int, depth: int) -> None: ...
    def textureDepth(self) -> int: ...
    def setTextureDepth(self, value: int) -> None: ...
    def textureHeight(self) -> int: ...
    def setTextureHeight(self, value: int) -> None: ...
    def textureWidth(self) -> int: ...
    def setTextureWidth(self, value: int) -> None: ...


class QSurfaceDataProxy('QAbstractDataProxy'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsInserted: typing.ClassVar[QtCore.pyqtSignal]
    rowsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    rowsChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    @typing.overload
    def itemAt(self, rowIndex: int, columnIndex: int) -> typing.Optional['QSurfaceDataItem']: ...
    @typing.overload
    def itemAt(self, position: QtCore.QPoint) -> typing.Optional['QSurfaceDataItem']: ...
    def series(self) -> typing.Optional['QSurface3DSeries']: ...
    def removeRows(self, rowIndex: int, removeCount: int) -> None: ...
    def insertRows(self, rowIndex: int, rows: typing.Iterable[typing.Iterable['QSurfaceDataItem']]) -> None: ...
    def insertRow(self, rowIndex: int, row: typing.Optional[typing.Iterable['QSurfaceDataItem']]) -> None: ...
    def addRows(self, rows: typing.Iterable[typing.Iterable['QSurfaceDataItem']]) -> int: ...
    def addRow(self, row: typing.Optional[typing.Iterable['QSurfaceDataItem']]) -> int: ...
    @typing.overload
    def setItem(self, rowIndex: int, columnIndex: int, item: 'QSurfaceDataItem') -> None: ...
    @typing.overload
    def setItem(self, position: QtCore.QPoint, item: 'QSurfaceDataItem') -> None: ...
    def setRows(self, rowIndex: int, rows: typing.Iterable[typing.Iterable['QSurfaceDataItem']]) -> None: ...
    def setRow(self, rowIndex: int, row: typing.Optional[typing.Iterable['QSurfaceDataItem']]) -> None: ...
    def resetArray(self, newArray: typing.Optional[typing.Iterable[typing.Iterable['QSurfaceDataItem']]]) -> None: ...
    def array(self) -> typing.Optional[typing.List[typing.List['QSurfaceDataItem']]]: ...
    def columnCount(self) -> int: ...
    def rowCount(self) -> int: ...


class QHeightMapSurfaceDataProxy('QSurfaceDataProxy'):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, image: QtGui.QImage, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, filename: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    maxZValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    minZValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    maxXValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    minXValueChanged: typing.ClassVar[QtCore.pyqtSignal]
    heightMapFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    heightMapChanged: typing.ClassVar[QtCore.pyqtSignal]
    def maxZValue(self) -> float: ...
    def setMaxZValue(self, max: float) -> None: ...
    def minZValue(self) -> float: ...
    def setMinZValue(self, min: float) -> None: ...
    def maxXValue(self) -> float: ...
    def setMaxXValue(self, max: float) -> None: ...
    def minXValue(self) -> float: ...
    def setMinXValue(self, min: float) -> None: ...
    def setValueRanges(self, minX: float, maxX: float, minZ: float, maxZ: float) -> None: ...
    def heightMapFile(self) -> str: ...
    def setHeightMapFile(self, filename: typing.Optional[str]) -> None: ...
    def heightMap(self) -> QtGui.QImage: ...
    def setHeightMap(self, image: QtGui.QImage) -> None: ...


class QItemModelBarDataProxy('QBarDataProxy'):

    class MultiMatchBehavior(int):
        MMBFirst = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        MMBLast = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        MMBAverage = ... # type: QItemModelBarDataProxy.MultiMatchBehavior
        MMBCumulative = ... # type: QItemModelBarDataProxy.MultiMatchBehavior

    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], valueRole: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], rowRole: typing.Optional[str], columnRole: typing.Optional[str], valueRole: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], rowRole: typing.Optional[str], columnRole: typing.Optional[str], valueRole: typing.Optional[str], rotationRole: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], rowRole: typing.Optional[str], columnRole: typing.Optional[str], valueRole: typing.Optional[str], rowCategories: typing.Iterable[typing.Optional[str]], columnCategories: typing.Iterable[typing.Optional[str]], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], rowRole: typing.Optional[str], columnRole: typing.Optional[str], valueRole: typing.Optional[str], rotationRole: typing.Optional[str], rowCategories: typing.Iterable[typing.Optional[str]], columnCategories: typing.Iterable[typing.Optional[str]], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    multiMatchBehaviorChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    def multiMatchBehavior(self) -> 'QItemModelBarDataProxy.MultiMatchBehavior': ...
    def setMultiMatchBehavior(self, behavior: 'QItemModelBarDataProxy.MultiMatchBehavior') -> None: ...
    def rotationRoleReplace(self) -> str: ...
    def setRotationRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def valueRoleReplace(self) -> str: ...
    def setValueRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def columnRoleReplace(self) -> str: ...
    def setColumnRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def rowRoleReplace(self) -> str: ...
    def setRowRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def rotationRolePattern(self) -> QtCore.QRegExp: ...
    def setRotationRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def valueRolePattern(self) -> QtCore.QRegExp: ...
    def setValueRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def columnRolePattern(self) -> QtCore.QRegExp: ...
    def setColumnRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def rowRolePattern(self) -> QtCore.QRegExp: ...
    def setRowRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    autoColumnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoRowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useModelCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    valueRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def remap(self, rowRole: typing.Optional[str], columnRole: typing.Optional[str], valueRole: typing.Optional[str], rotationRole: typing.Optional[str], rowCategories: typing.Iterable[typing.Optional[str]], columnCategories: typing.Iterable[typing.Optional[str]]) -> None: ...
    def rotationRole(self) -> str: ...
    def setRotationRole(self, role: typing.Optional[str]) -> None: ...
    def columnCategoryIndex(self, category: typing.Optional[str]) -> int: ...
    def rowCategoryIndex(self, category: typing.Optional[str]) -> int: ...
    def autoColumnCategories(self) -> bool: ...
    def setAutoColumnCategories(self, enable: bool) -> None: ...
    def autoRowCategories(self) -> bool: ...
    def setAutoRowCategories(self, enable: bool) -> None: ...
    def useModelCategories(self) -> bool: ...
    def setUseModelCategories(self, enable: bool) -> None: ...
    def columnCategories(self) -> typing.List[str]: ...
    def setColumnCategories(self, categories: typing.Iterable[typing.Optional[str]]) -> None: ...
    def rowCategories(self) -> typing.List[str]: ...
    def setRowCategories(self, categories: typing.Iterable[typing.Optional[str]]) -> None: ...
    def valueRole(self) -> str: ...
    def setValueRole(self, role: typing.Optional[str]) -> None: ...
    def columnRole(self) -> str: ...
    def setColumnRole(self, role: typing.Optional[str]) -> None: ...
    def rowRole(self) -> str: ...
    def setRowRole(self, role: typing.Optional[str]) -> None: ...
    def itemModel(self) -> typing.Optional[QtCore.QAbstractItemModel]: ...
    def setItemModel(self, itemModel: typing.Optional[QtCore.QAbstractItemModel]) -> None: ...


class QScatterDataProxy('QAbstractDataProxy'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    seriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemsInserted: typing.ClassVar[QtCore.pyqtSignal]
    itemsRemoved: typing.ClassVar[QtCore.pyqtSignal]
    itemsChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemsAdded: typing.ClassVar[QtCore.pyqtSignal]
    arrayReset: typing.ClassVar[QtCore.pyqtSignal]
    def series(self) -> typing.Optional['QScatter3DSeries']: ...
    def removeItems(self, index: int, removeCount: int) -> None: ...
    def insertItems(self, index: int, items: typing.Iterable['QScatterDataItem']) -> None: ...
    def insertItem(self, index: int, item: 'QScatterDataItem') -> None: ...
    def addItems(self, items: typing.Iterable['QScatterDataItem']) -> int: ...
    def addItem(self, item: 'QScatterDataItem') -> int: ...
    def setItems(self, index: int, items: typing.Iterable['QScatterDataItem']) -> None: ...
    def setItem(self, index: int, item: 'QScatterDataItem') -> None: ...
    def resetArray(self, newArray: typing.Optional[typing.Iterable['QScatterDataItem']]) -> None: ...
    def itemAt(self, index: int) -> typing.Optional['QScatterDataItem']: ...
    def array(self) -> typing.Optional[typing.List['QScatterDataItem']]: ...
    def itemCount(self) -> int: ...


class QItemModelScatterDataProxy('QScatterDataProxy'):

    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], xPosRole: typing.Optional[str], yPosRole: typing.Optional[str], zPosRole: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], xPosRole: typing.Optional[str], yPosRole: typing.Optional[str], zPosRole: typing.Optional[str], rotationRole: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    zPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rotationRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    def rotationRoleReplace(self) -> str: ...
    def setRotationRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def zPosRoleReplace(self) -> str: ...
    def setZPosRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def yPosRoleReplace(self) -> str: ...
    def setYPosRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def xPosRoleReplace(self) -> str: ...
    def setXPosRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def rotationRolePattern(self) -> QtCore.QRegExp: ...
    def setRotationRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def zPosRolePattern(self) -> QtCore.QRegExp: ...
    def setZPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def yPosRolePattern(self) -> QtCore.QRegExp: ...
    def setYPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def xPosRolePattern(self) -> QtCore.QRegExp: ...
    def setXPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    rotationRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def remap(self, xPosRole: typing.Optional[str], yPosRole: typing.Optional[str], zPosRole: typing.Optional[str], rotationRole: typing.Optional[str]) -> None: ...
    def rotationRole(self) -> str: ...
    def setRotationRole(self, role: typing.Optional[str]) -> None: ...
    def zPosRole(self) -> str: ...
    def setZPosRole(self, role: typing.Optional[str]) -> None: ...
    def yPosRole(self) -> str: ...
    def setYPosRole(self, role: typing.Optional[str]) -> None: ...
    def xPosRole(self) -> str: ...
    def setXPosRole(self, role: typing.Optional[str]) -> None: ...
    def itemModel(self) -> typing.Optional[QtCore.QAbstractItemModel]: ...
    def setItemModel(self, itemModel: typing.Optional[QtCore.QAbstractItemModel]) -> None: ...


class QItemModelSurfaceDataProxy('QSurfaceDataProxy'):

    class MultiMatchBehavior(int):
        MMBFirst = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        MMBLast = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        MMBAverage = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior
        MMBCumulativeY = ... # type: QItemModelSurfaceDataProxy.MultiMatchBehavior

    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], yPosRole: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], rowRole: typing.Optional[str], columnRole: typing.Optional[str], yPosRole: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], rowRole: typing.Optional[str], columnRole: typing.Optional[str], yPosRole: typing.Optional[str], rowCategories: typing.Iterable[typing.Optional[str]], columnCategories: typing.Iterable[typing.Optional[str]], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], rowRole: typing.Optional[str], columnRole: typing.Optional[str], xPosRole: typing.Optional[str], yPosRole: typing.Optional[str], zPosRole: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, itemModel: typing.Optional[QtCore.QAbstractItemModel], rowRole: typing.Optional[str], columnRole: typing.Optional[str], xPosRole: typing.Optional[str], yPosRole: typing.Optional[str], zPosRole: typing.Optional[str], rowCategories: typing.Iterable[typing.Optional[str]], columnCategories: typing.Iterable[typing.Optional[str]], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    multiMatchBehaviorChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleReplaceChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRolePatternChanged: typing.ClassVar[QtCore.pyqtSignal]
    def multiMatchBehavior(self) -> 'QItemModelSurfaceDataProxy.MultiMatchBehavior': ...
    def setMultiMatchBehavior(self, behavior: 'QItemModelSurfaceDataProxy.MultiMatchBehavior') -> None: ...
    def zPosRoleReplace(self) -> str: ...
    def setZPosRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def yPosRoleReplace(self) -> str: ...
    def setYPosRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def xPosRoleReplace(self) -> str: ...
    def setXPosRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def columnRoleReplace(self) -> str: ...
    def setColumnRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def rowRoleReplace(self) -> str: ...
    def setRowRoleReplace(self, replace: typing.Optional[str]) -> None: ...
    def zPosRolePattern(self) -> QtCore.QRegExp: ...
    def setZPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def yPosRolePattern(self) -> QtCore.QRegExp: ...
    def setYPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def xPosRolePattern(self) -> QtCore.QRegExp: ...
    def setXPosRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def columnRolePattern(self) -> QtCore.QRegExp: ...
    def setColumnRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    def rowRolePattern(self) -> QtCore.QRegExp: ...
    def setRowRolePattern(self, pattern: QtCore.QRegExp) -> None: ...
    autoColumnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoRowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    useModelCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowCategoriesChanged: typing.ClassVar[QtCore.pyqtSignal]
    zPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    yPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    xPosRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    columnRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    rowRoleChanged: typing.ClassVar[QtCore.pyqtSignal]
    itemModelChanged: typing.ClassVar[QtCore.pyqtSignal]
    def remap(self, rowRole: typing.Optional[str], columnRole: typing.Optional[str], xPosRole: typing.Optional[str], yPosRole: typing.Optional[str], zPosRole: typing.Optional[str], rowCategories: typing.Iterable[typing.Optional[str]], columnCategories: typing.Iterable[typing.Optional[str]]) -> None: ...
    def zPosRole(self) -> str: ...
    def setZPosRole(self, role: typing.Optional[str]) -> None: ...
    def yPosRole(self) -> str: ...
    def setYPosRole(self, role: typing.Optional[str]) -> None: ...
    def xPosRole(self) -> str: ...
    def setXPosRole(self, role: typing.Optional[str]) -> None: ...
    def columnCategoryIndex(self, category: typing.Optional[str]) -> int: ...
    def rowCategoryIndex(self, category: typing.Optional[str]) -> int: ...
    def autoColumnCategories(self) -> bool: ...
    def setAutoColumnCategories(self, enable: bool) -> None: ...
    def autoRowCategories(self) -> bool: ...
    def setAutoRowCategories(self, enable: bool) -> None: ...
    def useModelCategories(self) -> bool: ...
    def setUseModelCategories(self, enable: bool) -> None: ...
    def columnCategories(self) -> typing.List[str]: ...
    def setColumnCategories(self, categories: typing.Iterable[typing.Optional[str]]) -> None: ...
    def rowCategories(self) -> typing.List[str]: ...
    def setRowCategories(self, categories: typing.Iterable[typing.Optional[str]]) -> None: ...
    def columnRole(self) -> str: ...
    def setColumnRole(self, role: typing.Optional[str]) -> None: ...
    def rowRole(self) -> str: ...
    def setRowRole(self, role: typing.Optional[str]) -> None: ...
    def itemModel(self) -> typing.Optional[QtCore.QAbstractItemModel]: ...
    def setItemModel(self, itemModel: typing.Optional[QtCore.QAbstractItemModel]) -> None: ...


class QValue3DAxisFormatter(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def locale(self) -> QtCore.QLocale: ...
    def setLocale(self, locale: QtCore.QLocale) -> None: ...
    def labelStrings(self) -> typing.List[str]: ...
    def labelPositions(self) -> typing.List[float]: ...
    def subGridPositions(self) -> typing.List[float]: ...
    def gridPositions(self) -> typing.List[float]: ...
    def axis(self) -> typing.Optional['QValue3DAxis']: ...
    def markDirty(self, labelsChange: bool = ...) -> None: ...
    def populateCopy(self, copy: 'QValue3DAxisFormatter') -> None: ...
    def valueAt(self, position: float) -> float: ...
    def positionAt(self, value: float) -> float: ...
    def stringForValue(self, value: float, format: typing.Optional[str]) -> str: ...
    def recalculate(self) -> None: ...
    def createNewInstance(self) -> typing.Optional['QValue3DAxisFormatter']: ...
    def allowZero(self) -> bool: ...
    def setAllowZero(self, allow: bool) -> None: ...
    def allowNegatives(self) -> bool: ...
    def setAllowNegatives(self, allow: bool) -> None: ...


class QLogValue3DAxisFormatter('QValue3DAxisFormatter'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def populateCopy(self, copy: 'QValue3DAxisFormatter') -> None: ...
    def valueAt(self, position: float) -> float: ...
    def positionAt(self, value: float) -> float: ...
    def recalculate(self) -> None: ...
    def createNewInstance(self) -> typing.Optional['QValue3DAxisFormatter']: ...
    showEdgeLabelsChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoSubGridChanged: typing.ClassVar[QtCore.pyqtSignal]
    baseChanged: typing.ClassVar[QtCore.pyqtSignal]
    def showEdgeLabels(self) -> bool: ...
    def setShowEdgeLabels(self, enabled: bool) -> None: ...
    def autoSubGrid(self) -> bool: ...
    def setAutoSubGrid(self, enabled: bool) -> None: ...
    def base(self) -> float: ...
    def setBase(self, base: float) -> None: ...


class QScatter3DSeries('QAbstract3DSeries'):

    @typing.overload
    def __init__(self, dataProxy: typing.Optional['QScatterDataProxy'], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    itemSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedItemChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def itemSize(self) -> float: ...
    def setItemSize(self, size: float) -> None: ...
    @staticmethod
    def invalidSelectionIndex() -> int: ...
    def selectedItem(self) -> int: ...
    def setSelectedItem(self, index: int) -> None: ...
    def dataProxy(self) -> typing.Optional['QScatterDataProxy']: ...
    def setDataProxy(self, proxy: typing.Optional['QScatterDataProxy']) -> None: ...


class QScatterDataItem(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D, rotation: QtGui.QQuaternion) -> None: ...
    @typing.overload
    def __init__(self, other: 'QScatterDataItem') -> None: ...

    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def setZ(self, value: float) -> None: ...
    def setY(self, value: float) -> None: ...
    def setX(self, value: float) -> None: ...
    def rotation(self) -> QtGui.QQuaternion: ...
    def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, position: QtGui.QVector3D) -> None: ...


class QSurface3DSeries('QAbstract3DSeries'):

    class DrawFlag(int):
        DrawWireframe = ... # type: QSurface3DSeries.DrawFlag
        DrawSurface = ... # type: QSurface3DSeries.DrawFlag
        DrawSurfaceAndWireframe = ... # type: QSurface3DSeries.DrawFlag

    class DrawFlags(PyQt5.sipsimplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __ne__(self, other: object): ...
        def __eq__(self, other: object): ...
        def __ixor__(self, f: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> 'QSurface3DSeries.DrawFlags': ...
        def __xor__(self, f: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> 'QSurface3DSeries.DrawFlags': ...
        def __ior__(self, f: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> 'QSurface3DSeries.DrawFlags': ...
        def __or__(self, f: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> 'QSurface3DSeries.DrawFlags': ...
        def __iand__(self, f: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> 'QSurface3DSeries.DrawFlags': ...
        def __and__(self, f: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> 'QSurface3DSeries.DrawFlags': ...
        def __invert__(self) -> 'QSurface3DSeries.DrawFlags': ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...

    @typing.overload
    def __init__(self, dataProxy: typing.Optional['QSurfaceDataProxy'], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    textureFileChanged: typing.ClassVar[QtCore.pyqtSignal]
    textureChanged: typing.ClassVar[QtCore.pyqtSignal]
    def textureFile(self) -> str: ...
    def setTextureFile(self, filename: typing.Optional[str]) -> None: ...
    def texture(self) -> QtGui.QImage: ...
    def setTexture(self, texture: QtGui.QImage) -> None: ...
    drawModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    flatShadingSupportedChanged: typing.ClassVar[QtCore.pyqtSignal]
    flatShadingEnabledChanged: typing.ClassVar[QtCore.pyqtSignal]
    selectedPointChanged: typing.ClassVar[QtCore.pyqtSignal]
    dataProxyChanged: typing.ClassVar[QtCore.pyqtSignal]
    def isFlatShadingSupported(self) -> bool: ...
    def drawMode(self) -> 'QSurface3DSeries.DrawFlags': ...
    def setDrawMode(self, mode: typing.Union['QSurface3DSeries.DrawFlags', 'QSurface3DSeries.DrawFlag']) -> None: ...
    def isFlatShadingEnabled(self) -> bool: ...
    def setFlatShadingEnabled(self, enabled: bool) -> None: ...
    @staticmethod
    def invalidSelectionPosition() -> QtCore.QPoint: ...
    def selectedPoint(self) -> QtCore.QPoint: ...
    def setSelectedPoint(self, position: QtCore.QPoint) -> None: ...
    def dataProxy(self) -> typing.Optional['QSurfaceDataProxy']: ...
    def setDataProxy(self, proxy: typing.Optional['QSurfaceDataProxy']) -> None: ...


class QSurfaceDataItem(PyQt5.sipsimplewrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, position: QtGui.QVector3D) -> None: ...
    @typing.overload
    def __init__(self, other: 'QSurfaceDataItem') -> None: ...

    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def setZ(self, value: float) -> None: ...
    def setY(self, value: float) -> None: ...
    def setX(self, value: float) -> None: ...
    def position(self) -> QtGui.QVector3D: ...
    def setPosition(self, position: QtGui.QVector3D) -> None: ...


class QTouch3DInputHandler('Q3DInputHandler'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def touchEvent(self, event: typing.Optional[QtGui.QTouchEvent]) -> None: ...


class QValue3DAxis('QAbstract3DAxis'):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    reversedChanged: typing.ClassVar[QtCore.pyqtSignal]
    formatterChanged: typing.ClassVar[QtCore.pyqtSignal]
    def reversed(self) -> bool: ...
    def setReversed(self, enable: bool) -> None: ...
    def formatter(self) -> typing.Optional['QValue3DAxisFormatter']: ...
    def setFormatter(self, formatter: typing.Optional['QValue3DAxisFormatter']) -> None: ...
    labelFormatChanged: typing.ClassVar[QtCore.pyqtSignal]
    subSegmentCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    segmentCountChanged: typing.ClassVar[QtCore.pyqtSignal]
    def labelFormat(self) -> str: ...
    def setLabelFormat(self, format: typing.Optional[str]) -> None: ...
    def subSegmentCount(self) -> int: ...
    def setSubSegmentCount(self, count: int) -> None: ...
    def segmentCount(self) -> int: ...
    def setSegmentCount(self, count: int) -> None: ...


def qDefaultSurfaceFormat(antialias: bool = ...) -> QtGui.QSurfaceFormat: ...


PYQT_DATAVISUALIZATION_VERSION = ... # type: int
PYQT_DATAVISUALIZATION_VERSION_STR = ... # type: str
QTDATAVISUALIZATION_VERSION = ... # type: int
QTDATAVISUALIZATION_VERSION_STR = ... # type: str
