"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUtils = exports.CfnUtilsProvider = void 0;
const construct_compat_1 = require("../construct-compat");
const custom_resource_1 = require("../custom-resource");
const custom_resource_provider_1 = require("../custom-resource-provider");
/**
 * A custom resource provider for CFN utilities such as `CfnJson`.
 */
class CfnUtilsProvider extends construct_compat_1.Construct {
    static getOrCreate(scope) {
        return custom_resource_provider_1.CustomResourceProvider.getOrCreate(scope, 'AWSCDKCfnUtilsProvider', {
            runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_12_X,
            codeDirectory: `${__dirname}/cfn-utils-provider`,
        });
    }
}
exports.CfnUtilsProvider = CfnUtilsProvider;
/**
 * Utility functions provided by the CfnUtilsProvider
 */
class CfnUtils {
    /**
     * Encode a structure to JSON at CloudFormation deployment time
     *
     * This would have been suitable for the JSON-encoding of abitrary structures, however:
     *
     * - It uses a custom resource to do the encoding, and we'd rather not use a custom
     *   resource if we can avoid it.
     * - It cannot be used to encode objects where the keys of the objects can contain
     *   tokens--because those cannot be represented in the JSON encoding that CloudFormation
     *   templates use.
     *
     * This helper is used by `CloudFormationLang.toJSON()` if and only if it encounters
     * objects that cannot be stringified any other way.
     */
    static stringify(scope, id, value) {
        const resource = new custom_resource_1.CustomResource(scope, id, {
            serviceToken: CfnUtilsProvider.getOrCreate(scope),
            resourceType: "Custom::AWSCDKCfnJsonStringify" /* CFN_JSON_STRINGIFY */,
            properties: {
                Value: value,
            },
        });
        return resource.getAttString('Value');
    }
}
exports.CfnUtils = CfnUtils;
//# sourceMappingURL=data:application/json;base64,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